/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.trans;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.enhydra.dods.Common;
import org.enhydra.dods.trans.Column;
import org.enhydra.dods.trans.DefaultTagValues;
import org.enhydra.dods.trans.Index;
import org.enhydra.dods.trans.InvalidDomlException;
import org.enhydra.dods.trans.Referrer;
import org.enhydra.dods.trans.Table;
import org.enhydra.dods.wizard.TraceDialog;
import org.enhydra.dods.xslt.XSLTUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransientXMLBuilderFactory {
    public static final String ERROR_NO_PARSED_DOCUMENT = "ERROR_NO_PARSED_DOCUMENT";
    public static final String ERROR_NO_DATABASE_TAG = "ERROR_NO_DATABASE_TAG";
    public static final String ERROR_NO_DATABASE_ATTRIBUTES = "ERROR_NO_DATABASE_ATTRIBUTES";
    public static final String ERROR_NO_DATABASE_ATTRIBUTE = "ERROR_NO_DATABASE_ATTRIBUTE";
    public static final String ERROR_NO_TABLE_TAG = "ERROR_NO_TABLE_TAG";
    public static final String ERROR_NO_COLUMN_TAG = "ERROR_NO_COLUMN_TAG";
    public static final String[] TABLE_ATTR_NAMES = new String[]{"id", "dbTableName", "isView", "generateSecure", "generateInsecure", "multidb", "dirtyDOs", "massUpdates", "massDeletes"};
    public static final String DIRTY_DO_DEFAULT = "Compatible";
    static final int TABLE_ID = 0;
    static final int TABLE_DB_TABLE_NAME = 1;
    static final int TABLE_IS_VIEW = 2;
    static final int TABLE_SECURITY = 3;
    static final int TABLE_NON_SECURITY = 4;
    static final int TABLE_MULTIDB = 5;
    static final int TABLE_DIRTY_DOS = 6;
    static final int TABLE_MASS_UPDATES = 7;
    static final int TABLE_MASS_DELETES = 8;
    public static final String[] COLUMN_ATT_NAMES = new String[]{"id", "usedForQuery", "isConstant", "generateSecure", "generateInsecure"};
    static final int COLUMN_ID = 0;
    static final int COLUMN_USED_FOR_QUERY = 1;
    static final int COLUMN_IS_CONSTANT = 2;
    static final int COLUMN_SECURITY = 3;
    static final int COLUMN_NON_SECURITY = 4;
    public static final String[] REF_OBJECT_ATTR_NAMES = new String[]{"constraint", "reference"};
    static final int COLUMN_CONSTRAINT = 0;
    static final int COLUMN_REFERENCE = 1;
    public static final String[] TYPE_ATTR_NAMES = new String[]{"size", "canBeNull", "dbType", "javaType"};
    static final int COLUMN_SIZE = 0;
    static final int COLUMN_CAN_BE_NULL = 1;
    static final int COLUMN_DB_TYPE = 2;
    static final int COLUMN_JAVA_TYPE = 3;
    public static final String[] INDEX_ATTR_NAMES = new String[]{"id", "unique", "clustered"};
    static final int INDEX_ID = 0;
    static final int INDEX_UNIQUE = 1;
    static final int INDEX_CLUSTERED = 2;
    protected HashMap tables;
    protected String project = "DODS Project";
    protected String author = "NN";
    protected String database = null;
    protected String templateSet = "standard";
    protected TraceDialog td = null;

    public TransientXMLBuilderFactory() {
        this.tables = new HashMap();
    }

    public TransientXMLBuilderFactory(TraceDialog td) {
        this.td = td;
        this.tables = new HashMap();
    }

    public String readDoml() throws InvalidDomlException {
        NodeList nodeListTagTable;
        NodeList nodeText;
        String projectRoot = Common.getProjectRoot();
        String domlFile = projectRoot + File.separator + Common.getDomlFileName();
        Document doc = null;
        String nodeValue = "";
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(domlFile);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (doc == null) {
            return ERROR_NO_PARSED_DOCUMENT;
        }
        try {
            NodeList nodeListTagAuthor = doc.getElementsByTagName("author");
            if (nodeListTagAuthor != null && (nodeText = nodeListTagAuthor.item(0).getChildNodes()).item(0) != null) {
                this.author = nodeText.item(0).getNodeValue();
            }
        }
        catch (Exception nodeListTagAuthor) {
            // empty catch block
        }
        try {
            NodeList nodeListTagProject = doc.getElementsByTagName("projectname");
            if (nodeListTagProject != null && (nodeText = nodeListTagProject.item(0).getChildNodes()).item(0) != null) {
                this.project = nodeText.item(0).getNodeValue();
            }
        }
        catch (Exception nodeListTagProject) {
            // empty catch block
        }
        NodeList nodeListTagDatabase = doc.getElementsByTagName("database");
        if (nodeListTagDatabase == null) {
            return ERROR_NO_DATABASE_TAG;
        }
        NamedNodeMap databaseAttrs = nodeListTagDatabase.item(0).getAttributes();
        if (this.database == null || this.database.equals("database_not_set")) {
            if (databaseAttrs == null) {
                return ERROR_NO_DATABASE_ATTRIBUTES;
            }
            Node nodeDatabase = databaseAttrs.getNamedItem("database");
            if (nodeDatabase == null) {
                return ERROR_NO_DATABASE_ATTRIBUTE;
            }
            this.database = nodeDatabase.getNodeValue();
            if (System.getProperty("DATABASE_VENDOR") == null || System.getProperty("DATABASE_VENDOR").equals("database_not_set")) {
                System.setProperty("DATABASE_VENDOR", this.database);
            }
        }
        DefaultTagValues.loadDatabaseValues(this.database);
        Node nodeTemplateSet = databaseAttrs.getNamedItem("templateset");
        if (nodeTemplateSet != null) {
            this.templateSet = nodeTemplateSet.getNodeValue();
        }
        Node dirtyTag = databaseAttrs.getNamedItem("dirtyDOs");
        String dirty = null;
        dirty = dirtyTag != null ? dirtyTag.getNodeValue() : DIRTY_DO_DEFAULT;
        boolean dbMassUpdate = false;
        Node dbMassUpdateTag = databaseAttrs.getNamedItem("massUpdates");
        if (dbMassUpdateTag != null) {
            dbMassUpdate = dbMassUpdateTag.getNodeValue().equalsIgnoreCase("true");
        }
        boolean dbMassDelete = false;
        Node dbMassDeleteTag = databaseAttrs.getNamedItem("massDeletes");
        if (dbMassDeleteTag != null) {
            dbMassDelete = dbMassDeleteTag.getNodeValue().equalsIgnoreCase("true");
        }
        boolean dbGenerateSecure = false;
        Node dbGenerateSecureTag = databaseAttrs.getNamedItem("generateSecure");
        if (dbGenerateSecureTag != null) {
            dbGenerateSecure = dbGenerateSecureTag.getNodeValue().equalsIgnoreCase("true");
        }
        boolean dbGenerateInsecure = true;
        Node dbGenerateInsecureTag = databaseAttrs.getNamedItem("generateInsecure");
        if (dbGenerateInsecureTag != null) {
            dbGenerateInsecure = dbGenerateInsecureTag.getNodeValue().equalsIgnoreCase("true");
        }
        if ((nodeListTagTable = doc.getElementsByTagName("table")) == null) {
            return ERROR_NO_TABLE_TAG;
        }
        for (int i = 0; i < nodeListTagTable.getLength(); ++i) {
            NodeList nodeListTagIndex;
            int j;
            NamedNodeMap tableAttrs = nodeListTagTable.item(i).getAttributes();
            if (tableAttrs == null) continue;
            Table table = null;
            String tableID = null;
            Referrer referrer = null;
            Object dirtyTable = null;
            boolean md = dbMassDelete;
            boolean mu = dbMassUpdate;
            block41: for (int j2 = 0; j2 < TABLE_ATTR_NAMES.length; ++j2) {
                Node nodeTable = tableAttrs.getNamedItem(TABLE_ATTR_NAMES[j2]);
                if (nodeTable == null) continue;
                nodeValue = nodeTable.getNodeValue();
                switch (j2) {
                    case 0: {
                        tableID = nodeValue;
                        table = (Table)this.tables.get(tableID);
                        if (table == null) {
                            table = new Table(dbGenerateSecure, dbGenerateInsecure, dirty);
                            this.tables.put(tableID, table);
                        }
                        String className = Common.capitalizeName((String)tableID.substring(tableID.lastIndexOf(46) + 1));
                        table.pckg(tableID.substring(0, tableID.lastIndexOf(46)));
                        table.projectName(tableID.substring(0, tableID.indexOf(46)));
                        table.tableName(className);
                        table.className(className);
                        continue block41;
                    }
                    case 1: {
                        table.tableName(nodeValue);
                        continue block41;
                    }
                    case 2: {
                        continue block41;
                    }
                    case 3: {
                        table.doSecure(nodeValue.equalsIgnoreCase("true"));
                        continue block41;
                    }
                    case 4: {
                        table.doInSecure(nodeValue.equalsIgnoreCase("true"));
                        continue block41;
                    }
                    case 5: {
                        table.doMultidb(nodeValue.equalsIgnoreCase("true"));
                        continue block41;
                    }
                    case 6: {
                        table.setDirtyDOs(nodeValue);
                        continue block41;
                    }
                    case 7: {
                        mu = nodeValue.equalsIgnoreCase("true");
                        if (dbMassUpdate) continue block41;
                        mu = mu || dbMassUpdate;
                        continue block41;
                    }
                    case 8: {
                        md = nodeValue.equalsIgnoreCase("true");
                        if (dbMassDelete) continue block41;
                        md = md || dbMassDelete;
                    }
                }
            }
            Element tagTable = (Element)nodeListTagTable.item(i);
            NodeList nodeListTagColumn = tagTable.getElementsByTagName("column");
            if (nodeListTagColumn == null) {
                return ERROR_NO_COLUMN_TAG;
            }
            for (j = 0; j < nodeListTagColumn.getLength(); ++j) {
                String refTableID;
                NodeList nodeListTagType;
                NodeList nodeListTagReferenceObject;
                NodeList nodeListTagInitialValue;
                NodeList nodeListTagJavadoc;
                Column column = new Column(table.doSecure(), table.doInSecure());
                NamedNodeMap columnAttrs = nodeListTagColumn.item(j).getAttributes();
                if (columnAttrs == null) continue;
                block43: for (int k = 0; k < COLUMN_ATT_NAMES.length; ++k) {
                    Node nodeColumn = columnAttrs.getNamedItem(COLUMN_ATT_NAMES[k]);
                    if (nodeColumn == null) continue;
                    nodeValue = nodeColumn.getNodeValue();
                    switch (k) {
                        case 0: {
                            column.name(nodeValue.substring(nodeValue.lastIndexOf(46) + 1));
                            continue block43;
                        }
                        case 1: {
                            column.usedForQuery(nodeValue.equalsIgnoreCase("true"));
                            continue block43;
                        }
                        case 2: {
                            column.isConstant(nodeValue.equalsIgnoreCase("true"));
                            continue block43;
                        }
                        case 3: {
                            column.isSecure(nodeValue.equalsIgnoreCase("true"));
                            if (!nodeValue.equalsIgnoreCase("true")) continue block43;
                            table.anyColumnSecure(true);
                            continue block43;
                        }
                        case 4: {
                            column.isInSecure(nodeValue.equalsIgnoreCase("true"));
                        }
                    }
                }
                Element columnTag = (Element)nodeListTagColumn.item(j);
                NodeList nodeListTagError = columnTag.getElementsByTagName("error");
                if (nodeListTagError != null) {
                    for (int k = 0; k < nodeListTagError.getLength(); ++k) {
                        NodeList nodeText2 = nodeListTagError.item(k).getChildNodes();
                        if (nodeText2.item(0) == null) continue;
                    }
                }
                if ((nodeListTagJavadoc = columnTag.getElementsByTagName("javadoc")) != null) {
                    for (int k = 0; k < nodeListTagJavadoc.getLength(); ++k) {
                        NodeList nodeText3 = nodeListTagJavadoc.item(k).getChildNodes();
                        if (nodeText3.item(0) == null) continue;
                        column.javadoc(nodeText3.item(0).getNodeValue());
                    }
                }
                if ((nodeListTagInitialValue = columnTag.getElementsByTagName("initialValue")) != null) {
                    for (int k = 0; k < nodeListTagInitialValue.getLength(); ++k) {
                        NodeList nodeText4 = nodeListTagInitialValue.item(k).getChildNodes();
                        if (nodeText4.item(0) == null) continue;
                        column.javaDefaultValue(nodeText4.item(0).getNodeValue());
                    }
                }
                if ((nodeListTagReferenceObject = columnTag.getElementsByTagName("referenceObject")) != null) {
                    NamedNodeMap referenceObjectAttrs;
                    for (int k = 0; k < nodeListTagReferenceObject.getLength() && (referenceObjectAttrs = nodeListTagReferenceObject.item(k).getAttributes()) != null; ++k) {
                        block48: for (int l = 0; l < REF_OBJECT_ATTR_NAMES.length; ++l) {
                            Node nodeReferenceObject = referenceObjectAttrs.getNamedItem(REF_OBJECT_ATTR_NAMES[l]);
                            if (nodeReferenceObject == null) continue;
                            nodeValue = nodeReferenceObject.getNodeValue();
                            switch (l) {
                                case 1: {
                                    column.refPackage(nodeValue.substring(0, nodeValue.lastIndexOf(46)));
                                    column.refName(Common.capitalizeName((String)nodeValue.substring(nodeValue.lastIndexOf(46) + 1)));
                                    continue block48;
                                }
                                case 0: {
                                    column.refConstarint(nodeValue.equalsIgnoreCase("true"));
                                }
                            }
                        }
                    }
                }
                if ((nodeListTagType = columnTag.getElementsByTagName("type")) != null) {
                    for (int k = 0; k < nodeListTagType.getLength(); ++k) {
                        if (nodeListTagType.item(k) == null) continue;
                        NamedNodeMap typeAttrs = nodeListTagType.item(k).getAttributes();
                        if (typeAttrs == null) break;
                        block50: for (int l = 0; l < TYPE_ATTR_NAMES.length; ++l) {
                            Node nodeType = typeAttrs.getNamedItem(TYPE_ATTR_NAMES[l]);
                            if (nodeType == null) continue;
                            nodeValue = nodeType.getNodeValue();
                            switch (l) {
                                case 0: {
                                    column.size(nodeValue);
                                    continue block50;
                                }
                                case 1: {
                                    column.canBeNull(nodeValue.equalsIgnoreCase("true"));
                                    continue block50;
                                }
                                case 2: {
                                    column.dbType(nodeValue);
                                    continue block50;
                                }
                                case 3: {
                                    column.javaType(nodeValue);
                                }
                            }
                        }
                    }
                }
                table.addColumn(column);
                if (!column.isReference() || column.refPackage() == null || column.refName() == null || (refTableID = column.refPackage() + "." + column.refName()).equals(".") || !column.usedForQuery() || column.refIsAbstarct() || column.refIsForeignKey()) continue;
                if (referrer == null) {
                    referrer = new Referrer(table.pckg(), table.className());
                }
                referrer.secure(table.doSecure());
                referrer.addAttribute(column.name(), refTableID, column.isSecure());
            }
            if (referrer != null) {
                for (j = 0; j < referrer.size(); ++j) {
                    String refTableID = referrer.attributeDoName(j);
                    Table refTable = (Table)this.tables.get(refTableID);
                    if (refTable == null) {
                        refTable = new Table(dbGenerateSecure, dbGenerateInsecure, dirty);
                        this.tables.put(refTableID, refTable);
                    }
                    refTable.addReferrer(referrer);
                }
            }
            if ((nodeListTagIndex = tagTable.getElementsByTagName("index")) != null) {
                for (int j3 = 0; j3 < nodeListTagIndex.getLength(); ++j3) {
                    if (nodeListTagIndex.item(j3) == null) continue;
                    NamedNodeMap indexAttrs = nodeListTagIndex.item(j3).getAttributes();
                    if (indexAttrs == null) break;
                    Index index = new Index();
                    block53: for (int k = 0; k < INDEX_ATTR_NAMES.length; ++k) {
                        Node nodeType = indexAttrs.getNamedItem(INDEX_ATTR_NAMES[k]);
                        if (nodeType == null) continue;
                        nodeValue = nodeType.getNodeValue();
                        switch (k) {
                            case 0: {
                                index.id(nodeValue);
                                continue block53;
                            }
                            case 1: {
                                index.isUnique(nodeValue.equalsIgnoreCase("true"));
                                continue block53;
                            }
                            case 2: {
                                index.isClustered(nodeValue.equalsIgnoreCase("true"));
                            }
                        }
                    }
                    Element indexTag = (Element)nodeListTagIndex.item(j3);
                    NodeList nodeListTagIndexColumn = indexTag.getElementsByTagName("indexColumn");
                    if (nodeListTagIndexColumn != null) {
                        NamedNodeMap indexColumnAttrs;
                        for (int k = 0; k < nodeListTagIndexColumn.getLength() && (indexColumnAttrs = nodeListTagIndexColumn.item(k).getAttributes()) != null; ++k) {
                            Node nodeIndexColumnID = indexColumnAttrs.getNamedItem("id");
                            if (nodeIndexColumnID == null) continue;
                            index.addIndexColumn(new String(nodeIndexColumnID.getNodeValue()));
                        }
                    }
                    table.addIndex(index);
                }
            }
            table.doMassUpdates(mu);
            table.doMassDeletes(md);
        }
        return "";
    }

    public void generateTransientXML() throws InvalidDomlException {
        if (this.td == null) {
            System.out.println("Creating TransientXML");
        } else {
            this.td.appendLine("Creating TransientXML\n");
        }
        Iterator iter = this.tables.values().iterator();
        StringBuffer tablesBuff = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n");
        tablesBuff.append("<DATABASE>\n");
        while (iter.hasNext()) {
            int i;
            Table table = (Table)iter.next();
            if (table.pckg() == null) {
                throw new InvalidDomlException("Invalid table package");
            }
            if (table.tableName() == null) {
                throw new InvalidDomlException("Invalid table name");
            }
            if (table.className() == null) {
                throw new InvalidDomlException("Invalid class name");
            }
            if (table.pckg() == null) {
                throw new InvalidDomlException("Invalid table package");
            }
            tablesBuff.append(" <TABLE name=\"" + table.tableName() + "\" ");
            tablesBuff.append("id=\"" + table.pckg() + "." + table.className() + "\" ");
            tablesBuff.append("path=\"" + table.pckg().replace('.', '/') + "\" ");
            tablesBuff.append("class=\"" + table.className() + "\"/>\n");
            StringBuffer xmlBuff = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n");
            xmlBuff.append("\n<TABLE>\n");
            xmlBuff.append("    <PACKAGE>" + XSLTUtil.getAdjustedPackageName(table.pckg()) + "</PACKAGE>\n");
            xmlBuff.append("    <AUTHOR>" + this.author + "</AUTHOR>\n");
            xmlBuff.append("    <PROJECT_NAME>" + this.project + "</PROJECT_NAME>\n");
            xmlBuff.append("    <TABLE_NAME>" + table.tableName() + "</TABLE_NAME>\n");
            xmlBuff.append("    <CLASS_NAME>" + table.className() + "</CLASS_NAME>\n");
            xmlBuff.append("    <DB_VENDOR>" + table.dbVendor() + "</DB_VENDOR>\n");
            xmlBuff.append("    <TEMPLATE_SET>" + this.templateSet + "</TEMPLATE_SET>\n");
            xmlBuff.append("    <GENERATE_SECURE>" + table.doSecure() + "</GENERATE_SECURE>\n");
            xmlBuff.append("    <GENERATE_INSECURE>" + table.doInSecure() + "</GENERATE_INSECURE>\n");
            xmlBuff.append("    <MASS_UPDATES>" + table.doMassUpdates() + "</MASS_UPDATES>\n");
            xmlBuff.append("    <MASS_DELETES>" + table.doMassDeletes() + "</MASS_DELETES>\n");
            xmlBuff.append("    <DO_IS_OID_BASED>" + table.doIsOidBased() + "</DO_IS_OID_BASED>\n");
            xmlBuff.append("    <IS_ABSTRACT>" + table.isAbstract() + "</IS_ABSTRACT>\n");
            xmlBuff.append("    <DELETE_CASCADES>" + table.deleteCascade() + "</DELETE_CASCADES>\n");
            xmlBuff.append("    <DO_IS_MULTIDB_BASED>" + table.doMultidb() + "</DO_IS_MULTIDB_BASED>\n");
            xmlBuff.append("    <IS_ANY_COLUMN_SECURE>" + table.isAnyColumnSecure() + "</IS_ANY_COLUMN_SECURE>\n");
            xmlBuff.append("    <GENERATE_DIRTY>" + table.getDirtyDOs() + "</GENERATE_DIRTY>\n\n");
            for (i = 0; i < table.columnsSize(); ++i) {
                Column column = table.column(i);
                if (column.name() == null) {
                    throw new InvalidDomlException("Invalid column name");
                }
                if (column.dbType() == null) {
                    throw new InvalidDomlException("Invalid column database type");
                }
                if (column.javaType() == null) {
                    throw new InvalidDomlException("Invalid column java type");
                }
                if (column.size() == null) {
                    column.size(DefaultTagValues.getDefaultSize(column.dbType(), column.javaType()));
                }
                if (!column.isSecure() && !column.isInSecure()) {
                    column.isInSecure(true);
                }
                xmlBuff.append("    <COLUMN name=\"" + column.name() + "\">\n");
                if (column.isReference()) {
                    String refTableName = column.refName();
                    Table refTable = (Table)this.tables.get(column.refPackage() + "." + column.refName());
                    if (refTable != null) {
                        refTableName = refTable.tableName();
                    }
                    if (column.refName() == null) {
                        throw new InvalidDomlException("Invalid column reference name");
                    }
                    if (column.refPackage() == null) {
                        throw new InvalidDomlException("Invalid column reference package");
                    }
                    xmlBuff.append("      <REFERENCE_OBJECT name=\"" + column.refName() + "\">\n");
                    xmlBuff.append("          <CONSTRAINT>" + column.refConstarint() + "</CONSTRAINT>\n");
                    xmlBuff.append("          <IS_ABSTRACT>" + column.refIsAbstarct() + "</IS_ABSTRACT>\n");
                    xmlBuff.append("          <IS_FOREIGN_KEY>" + column.refIsForeignKey() + "</IS_FOREIGN_KEY>\n");
                    xmlBuff.append("          <PACKAGE>" + XSLTUtil.getAdjustedPackageName(column.refPackage()) + "</PACKAGE>\n");
                    xmlBuff.append("          <TABLE_NAME>" + refTableName + "</TABLE_NAME>\n");
                    if (column.refForeignKeyColumnName() != null) {
                        xmlBuff.append("            <FOREIGN_KEY_COLUMN>" + column.refForeignKeyColumnName() + "</FOREIGN_KEY_COLUMN>\n");
                    }
                    if (column.refForeignKeyGroup() != null) {
                        xmlBuff.append("            <FOREIGN_KEY_GROUP>" + column.refForeignKeyGroup() + "</FOREIGN_KEY_GROUP>\n");
                    }
                    xmlBuff.append("      </REFERENCE_OBJECT>\n");
                }
                xmlBuff.append("        <IS_CONSTANT>" + column.isConstant() + "</IS_CONSTANT>\n");
                if (column.javadoc() != null) {
                    xmlBuff.append("      <JAVADOC>" + column.javadoc() + "</JAVADOC>\n");
                }
                xmlBuff.append("        <DB_TYPE>" + column.dbType() + "</DB_TYPE>\n");
                xmlBuff.append("        <JAVA_TYPE>" + XSLTUtil.adjustJavaType(column.javaType()) + "</JAVA_TYPE>\n");
                if (column.javaDefaultValue() != null) {
                    xmlBuff.append("        <JAVA_DEFAULT_VALUE>" + column.javaDefaultValue() + "</JAVA_DEFAULT_VALUE>\n");
                }
                xmlBuff.append("        <USED_FOR_QUERY>" + column.usedForQuery() + "</USED_FOR_QUERY>\n");
                xmlBuff.append("        <CAN_BE_NULL>" + column.canBeNull() + "</CAN_BE_NULL>\n");
                xmlBuff.append("        <IS_PRIMARY_KEY>" + column.isPrimaryKey() + "</IS_PRIMARY_KEY>\n");
                if (column.size() != null) {
                    xmlBuff.append("        <SIZE>" + column.size() + "</SIZE>\n");
                }
                xmlBuff.append("        <IS_ARRAY>" + column.isArray() + "</IS_ARRAY>\n");
                xmlBuff.append("        <GENERATE_SECURE>" + column.isSecure() + "</GENERATE_SECURE>\n");
                xmlBuff.append("        <GENERATE_INSECURE>" + column.isInSecure() + "</GENERATE_INSECURE>\n");
                xmlBuff.append("    </COLUMN>\n\n\n");
            }
            for (i = 0; i < table.indexesSize(); ++i) {
                Index index = table.index(i);
                if (index.id() == null) {
                    throw new InvalidDomlException("Invalid index id");
                }
                xmlBuff.append("    <INDEX id=\"" + XSLTUtil.getAdjustedPackageName(index.id()) + "\" unique=\"" + index.isUnique() + "\" clustered=\"" + index.isClustered() + "\">\n");
                for (int j = 0; j < index.size(); ++j) {
                    xmlBuff.append("        <INDEX_COLUMN id=\"" + index.indexColumn(j) + "\"/>\n");
                }
                xmlBuff.append("    </INDEX>\n\n");
            }
            Iterator refIter = table.referrersValueIterator();
            while (refIter.hasNext()) {
                Referrer referrer = (Referrer)refIter.next();
                xmlBuff.append("    <REFERRER name=\"" + referrer.name() + "\" package=\"" + XSLTUtil.getAdjustedPackageName(referrer.pckg()) + "\" generateSecure=\"" + referrer.isSecure() + "\">\n");
                for (int i2 = 0; i2 < referrer.size(); ++i2) {
                    boolean n2n = false;
                    String another = "";
                    if (referrer.size() == 2 && !(table.pckg() + "." + table.className()).equals(referrer.attributeDoName(i2))) {
                        n2n = true;
                        Table doTable = (Table)this.tables.get(referrer.attributeDoName(i2));
                        if (doTable.isAbstract()) {
                            n2n = false;
                        }
                        if (doTable.referrers().containsKey(table.pckg() + "." + table.className())) {
                            n2n = false;
                        }
                        if (table.referrers().containsKey(referrer.attributeDoName(i2))) {
                            n2n = false;
                        }
                        if (n2n) {
                            int j = 0 == i2 ? 1 : 0;
                            another = "\" another=\"" + referrer.attributeName(j);
                        }
                    }
                    xmlBuff.append("        <REFATTR name=\"" + referrer.attributeName(i2) + "\" do_name=\"" + XSLTUtil.getAdjustedPackageName(referrer.attributeDoName(i2)) + "\" n2n=\"" + n2n + another + "\" generateSecure=\"" + referrer.attributeSecurity(i2) + "\"/>\n");
                }
                xmlBuff.append("    </REFERRER>\n");
            }
            xmlBuff.append("\n</TABLE>\n");
            String filename = Common.getProjectRoot() + File.separator + (XSLTUtil.getAdjustedPackageName(table.pckg()) + "." + table.className()).replace('.', File.separatorChar) + ".xml";
            String dirname = Common.getProjectRoot() + File.separator + XSLTUtil.getAdjustedPackageName(table.pckg()).replace('.', File.separatorChar);
            if (this.td == null) {
                System.out.println("Creating " + filename);
            } else {
                this.td.appendLine("Creating " + filename + "\n");
            }
            File file = new File(filename);
            File dir = new File(dirname);
            dir.mkdirs();
            try {
                FileOutputStream outStream = new FileOutputStream(file);
                outStream.write(xmlBuff.toString().getBytes("UTF-8"));
                outStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        tablesBuff.append("</DATABASE>\n");
        String tablesname = Common.getProjectRoot() + File.separator + "tables.xml";
        File file = new File(tablesname);
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(tablesBuff.toString().getBytes("UTF-8"));
            outStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generateTablesXML() throws InvalidDomlException {
        Iterator iter = this.tables.values().iterator();
        StringBuffer tablesBuff = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n");
        tablesBuff.append("<DATABASE>\n");
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (table.pckg() == null) {
                throw new InvalidDomlException("Invalid table package");
            }
            if (table.tableName() == null) {
                throw new InvalidDomlException("Invalid table name");
            }
            if (table.className() == null) {
                throw new InvalidDomlException("Invalid class name");
            }
            if (table.pckg() == null) {
                throw new InvalidDomlException("Invalid table package");
            }
            tablesBuff.append(" <TABLE name=\"" + table.tableName() + "\" ");
            tablesBuff.append("id=\"" + XSLTUtil.getAdjustedPackageName(table.pckg()) + "." + table.className() + "\" ");
            tablesBuff.append("path=\"" + XSLTUtil.getAdjustedPackageName(table.pckg()).replace('.', '/') + "\" ");
            tablesBuff.append("massUpdates=\"" + table.doMassUpdates() + "\" ");
            tablesBuff.append("massDeletes=\"" + table.doMassDeletes() + "\" ");
            tablesBuff.append("class=\"" + table.className() + "\"/>\n");
        }
        tablesBuff.append("</DATABASE>\n");
        String tablesname = Common.getProjectRoot() + File.separator + "tables.xml";
        File file = new File(tablesname);
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(tablesBuff.toString().getBytes("UTF-8"));
            outStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generateClassList() throws InvalidDomlException {
        Iterator iter = this.tables.values().iterator();
        StringBuffer tablesBuff = new StringBuffer("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n\n");
        tablesBuff.append("<CLASSES>\n");
        while (iter.hasNext()) {
            Table table = (Table)iter.next();
            if (table.pckg() == null) {
                throw new InvalidDomlException("Invalid table package");
            }
            if (table.tableName() == null) {
                throw new InvalidDomlException("Invalid table name");
            }
            if (table.className() == null) {
                throw new InvalidDomlException("Invalid class name");
            }
            if (table.pckg() == null) {
                throw new InvalidDomlException("Invalid table package");
            }
            tablesBuff.append("    <CLASS name=\"" + XSLTUtil.getAdjustedPackageName(table.pckg()) + "." + table.className() + "DO\"/>\n");
        }
        tablesBuff.append("</CLASSES>\n");
        String dirname = Common.getProjectRoot() + File.separator + "org" + File.separator + "enhydra" + File.separator + "dods";
        String filename = Common.getProjectRoot() + File.separator + "org" + File.separator + "enhydra" + File.separator + "dods" + File.separator + "DODSClassList.xml";
        File file = new File(filename);
        File dir = new File(dirname);
        dir.mkdirs();
        try {
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(tablesBuff.toString().getBytes("UTF-8"));
            outStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void showAllTables() {
        for (Map.Entry map : this.tables.entrySet()) {
            String tableID = (String)map.getKey();
            Table table = (Table)map.getValue();
            System.out.println("Table: " + tableID + "\n" + table);
        }
    }

    public static void main(String[] args) throws Exception {
        try {
            TransientXMLBuilderFactory transientXMLBuilder = new TransientXMLBuilderFactory();
            if (args.length > 1) {
                transientXMLBuilder.database = args[1];
            }
            transientXMLBuilder.readDoml();
            if (args[0].equals("ClassList")) {
                transientXMLBuilder.generateClassList();
            } else if (new Boolean(args[0]).booleanValue()) {
                transientXMLBuilder.generateTablesXML();
            } else {
                transientXMLBuilder.generateTransientXML();
            }
        }
        catch (InvalidDomlException ide) {
            ide.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

