
package org.enhydra.dods.wizard;

import java.awt.AWTEvent ;
import java.awt.BorderLayout ;
import java.awt.Color ;
import java.awt.Dimension ;
import java.awt.FlowLayout ;
import java.awt.GridBagLayout ;
import java.awt.Image ;
import java.awt.Insets ;
import java.awt.Toolkit ;
import java.awt.event.ActionEvent ;
import java.awt.event.WindowEvent ;
import java.io.File ;
import java.util.HashSet ;
import java.util.Iterator ;
import java.util.ResourceBundle ;
import java.util.Set ;

import javax.swing.DebugGraphics ;
import javax.swing.ImageIcon ;
import javax.swing.JButton ;
import javax.swing.JCheckBox ;
import javax.swing.JComboBox ;
import javax.swing.JFileChooser ;
import javax.swing.JFrame ;
import javax.swing.JLabel ;
import javax.swing.JOptionPane ;
import javax.swing.JPanel ;
import javax.swing.JTextField ;

import org.enhydra.dods.Common;
import org.enhydra.dods.xml.XmlUtil;

/**
 * DODS Generator Wizard main frame
 * @author Nenad Vico
 * @version 1.0
 */
public class WizardFrame1 extends JFrame  {
    JPanel  contentPane;
    JPanel  jButtonPanel = new JPanel ();
    JPanel  jPictPanel = new JPanel ();
    JPanel  jContentPanel = new JPanel ();
    BorderLayout  borderLayout1 = new BorderLayout ();
    FlowLayout  flowLayout1 = new FlowLayout ();
    GridBagLayout  gridBagLayout1 = new GridBagLayout ();
    XYLayout xyLayout = new XYLayout();
    JLabel  jIconLabel = new JLabel ();
    JLabel  jTitleLabel = new JLabel ();
    JLabel  jOutputDirLabel = new JLabel ();
    JLabel  jDomlRootLabel = new JLabel ();
    JLabel  jTemplateTypeLabel = new JLabel ();
    JLabel  jDocLabel = new JLabel ();
    JLabel  jVendorTypeLabel = new JLabel ();
    JLabel  jJavaLabel = new JLabel ();
    JLabel  jConfigDirLabel = new JLabel ();
    JTextField  jOutputDirTextField = new JTextField ();
    JTextField  jDomlTextField = new JTextField ();
    JTextField  jConfigDirTextField = new JTextField ();
    JButton  jDomlButton = new JButton ();
    JButton  jSpaceButton = new JButton ();
    JButton  jGenerateButton = new JButton ();
    JButton  jCancelButton = new JButton ();
    JButton  jOutputDirButton = new JButton ();
    JButton  jSpace = new JButton ();
    JButton  jCloseButton = new JButton ();
    JButton  jSpace1 = new JButton ();
    JButton  jConfigDirButton = new JButton ();
    Image  appImage = Toolkit.getDefaultToolkit().getImage(getClass().getResource("smallicon.gif"));
    ImageIcon  enhydra = new ImageIcon (Toolkit.getDefaultToolkit().getImage(getClass().getResource("Enhydra.gif")));
    ResourceBundle  rb;
    JCheckBox  jCheckBoxSQL = new JCheckBox ();
    JCheckBox  jCheckBoxSQLSplitter = new JCheckBox ();
    JCheckBox  jCheckBoxJava = new JCheckBox ();
    JCheckBox  jCheckBoxCompile = new JCheckBox ();
    JCheckBox  jCheckBoxDoml2Html = new JCheckBox ();
    JCheckBox  jCheckBoxDoml2Pdf = new JCheckBox ();
    JCheckBox  jCheckBoxDoml2Xmi = new JCheckBox ();
    JCheckBox  jCheckBoxDoml2Ptl = new JCheckBox ();
    JCheckBox  jCheckBoxForce = new JCheckBox ();
    JCheckBox  jCheckBoxInvoke = new JCheckBox ();
    JComboBox  jComboBoxTemplateSet = new JComboBox ();
    JComboBox  jComboBoxVendors = new JComboBox ();
    // Construct the frame
 public WizardFrame1() {
        enableEvents(AWTEvent.WINDOW_EVENT_MASK);
        try {
            jbInit();
        } catch (Exception  e) {
            e.printStackTrace();
        }
    }

    // Component initialization
 private void jbInit() throws Exception  {
        setIconImage(appImage);
        this.setResizable(false);
        contentPane = (JPanel ) this.getContentPane();
        contentPane.setLayout(borderLayout1);
        this.setSize(new Dimension (570, 550));
        this.setTitle("DODS Generator Wizard");
        jButtonPanel.setDebugGraphicsOptions(DebugGraphics.NONE_OPTION);
        jButtonPanel.setMinimumSize(new Dimension (233, 50));
        jButtonPanel.setPreferredSize(new Dimension (500, 50));
        jContentPanel.setLayout(xyLayout);
        jGenerateButton.setFont(new java.awt.Font ("SansSerif", 0, 11));
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            jGenerateButton.setNextFocusableComponent(jCheckBoxInvoke);
        } else {
            jGenerateButton.setNextFocusableComponent(jConfigDirTextField);
        }
        jGenerateButton.setActionCommand("Generate");
        jGenerateButton.setSelected(true);
        jGenerateButton.setText("Generate");
        jGenerateButton.addActionListener(new java.awt.event.ActionListener () {
            public void actionPerformed(ActionEvent  e) {
                jGenerateButton_actionPerformed(e);
            }
        });
        jCancelButton.setFont(new java.awt.Font ("SansSerif", 0, 11));
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            jCancelButton.setNextFocusableComponent(jCloseButton);
        } else {
            jCancelButton.setNextFocusableComponent(jGenerateButton);
        }
        jCancelButton.setText("Cancel");
        jCancelButton.addActionListener(new java.awt.event.ActionListener () {
            public void actionPerformed(ActionEvent  e) {
                jCancelButton_actionPerformed(e);
            }
        });
        jCloseButton.setFont(new java.awt.Font ("SansSerif", 0, 11));
        jCloseButton.setNextFocusableComponent(jGenerateButton);
        jCloseButton.setText(" Close ");
        jCloseButton.addActionListener(new java.awt.event.ActionListener () {
            public void actionPerformed(ActionEvent  e) {
                jCloseButton_actionPerformed(e);
            }
        });
        jConfigDirTextField.setNextFocusableComponent(jConfigDirButton);
        jConfigDirTextField.setText(Common.getConfigDir());
        jConfigDirLabel.setFont(new java.awt.Font ("SansSerif", 0, 12));
        jConfigDirLabel.setText("Config directory :");
        jConfigDirButton.setFont(new java.awt.Font ("SansSerif", 0, 12));
        jConfigDirButton.setMaximumSize(new Dimension (55, 25));
        jConfigDirButton.setMinimumSize(new Dimension (55, 25));
        jConfigDirButton.setNextFocusableComponent(jOutputDirTextField);
        jConfigDirButton.setPreferredSize(new Dimension (55, 25));
        jConfigDirButton.setMargin(new Insets (2, 14, 3, 14));
        jConfigDirButton.setText("Set ...");
        jConfigDirButton.addActionListener(new java.awt.event.ActionListener () {
            public void actionPerformed(ActionEvent  e) {
                jConfigDirButton_actionPerformed(e);
            }
        });
        jSpace.setEnabled(false);
        jSpace.setBorder(null);
        jSpace.setPreferredSize(new Dimension (30, 20));
        jSpace.setFocusPainted(false);
        jSpace.setMargin(new Insets (2, 50, 2, 14));
        jSpace1.setEnabled(false);
        jSpace1.setBorder(null);
        jSpace1.setPreferredSize(new Dimension (30, 20));
        jSpace1.setFocusPainted(false);
        jSpace1.setMargin(new Insets (2, 50, 2, 14));
        jOutputDirTextField.setNextFocusableComponent(jOutputDirButton);
        jOutputDirTextField.setText(DefaultDODSWizard.getGenerator().getOutputDir());
        jDomlTextField.setNextFocusableComponent(jDomlButton);
        jDomlTextField.setText(DefaultDODSWizard.getGenerator().getDoml());
        jTitleLabel.setFont(new java.awt.Font ("SansSerif", 0, 12));
        jTitleLabel.setText("Please select config directory, output directory, doml file, template set and choose actions.");
        jOutputDirLabel.setFont(new java.awt.Font ("SansSerif", 0, 12));
        jOutputDirLabel.setText("Output directory :");
        jOutputDirButton.setFont(new java.awt.Font ("SansSerif", 0, 12));
        jOutputDirButton.setMaximumSize(new Dimension (55, 25));
        jOutputDirButton.setMinimumSize(new Dimension (55, 25));
        jOutputDirButton.setNextFocusableComponent(jDomlTextField);
        jOutputDirButton.setPreferredSize(new Dimension (55, 25));
        jOutputDirButton.setMargin(new Insets (2, 14, 3, 14));
        jOutputDirButton.setText("Set ...");
        jOutputDirButton.addActionListener(new java.awt.event.ActionListener () {
            public void actionPerformed(ActionEvent  e) {
                jOutputDirButton_actionPerformed(e);
            }
        });
        jDomlRootLabel.setText("Doml file :");
        jDomlRootLabel.setFont(new java.awt.Font ("SansSerif", 0, 12));
        jDomlButton.setFont(new java.awt.Font ("SansSerif", 0, 12));
        jDomlButton.setMaximumSize(new Dimension (50, 25));
        jDomlButton.setMinimumSize(new Dimension (55, 25));
        jDomlButton.setNextFocusableComponent(jCheckBoxDoml2Html);
        jDomlButton.setPreferredSize(new Dimension (55, 25));
        jDomlButton.setMargin(new Insets (2, 14, 3, 14));
        jDomlButton.setText("Set ...");
        jDomlButton.addActionListener(new java.awt.event.ActionListener () {
            public void actionPerformed(ActionEvent  e) {
                jDomlButton_actionPerformed(e);
            }
        });
        jDocLabel.setText("Documentation :");
        jDocLabel.setFont(new java.awt.Font ("SansSerif", 0, 12));
        jCheckBoxDoml2Html.setMaximumSize(new Dimension (100, 22));
        jCheckBoxDoml2Html.setMinimumSize(new Dimension (100, 22));
        jCheckBoxDoml2Html.setNextFocusableComponent(jCheckBoxDoml2Pdf);
        jCheckBoxDoml2Html.setSelected(DefaultDODSWizard.getGenerator().getHtml());
        jCheckBoxDoml2Html.setText(" HTML");
        jCheckBoxDoml2Pdf.setMaximumSize(new Dimension (100, 22));
        jCheckBoxDoml2Pdf.setMinimumSize(new Dimension (100, 22));
        jCheckBoxDoml2Pdf.setNextFocusableComponent(jCheckBoxDoml2Xmi);
        jCheckBoxDoml2Pdf.setSelected(DefaultDODSWizard.getGenerator().getPdf());
        jCheckBoxDoml2Pdf.setText(" PDF");
        jCheckBoxDoml2Xmi.setMaximumSize(new Dimension (100, 22));
        jCheckBoxDoml2Xmi.setMinimumSize(new Dimension (100, 22));
        jCheckBoxDoml2Xmi.setNextFocusableComponent(jCheckBoxDoml2Ptl);
        jCheckBoxDoml2Xmi.setSelected(DefaultDODSWizard.getGenerator().getXmi());
        jCheckBoxDoml2Xmi.setText(" XMI");
        jCheckBoxDoml2Ptl.setMaximumSize(new Dimension (100, 22));
        jCheckBoxDoml2Ptl.setMinimumSize(new Dimension (100, 22));
        jCheckBoxDoml2Ptl.setNextFocusableComponent(jComboBoxTemplateSet);
        jCheckBoxDoml2Ptl.setSelected(DefaultDODSWizard.getGenerator().getPtl());
        jCheckBoxDoml2Ptl.setText("PTL");
        jCheckBoxForce.setMaximumSize(new Dimension (100, 22));
        jCheckBoxForce.setMinimumSize(new Dimension (100, 22));
        jCheckBoxForce.setNextFocusableComponent(jComboBoxVendors);
        jCheckBoxForce.setSelected(true);
        if (DefaultDODSWizard.getGenerator().getForce().equals("false")) {
            jCheckBoxForce.setSelected(false);
        }
        jCheckBoxForce.setText("Overwrite");
        jCheckBoxInvoke.setNextFocusableComponent(jOutputDirTextField);
        jCheckBoxInvoke.setSelected(DefaultDODSWizard.getGenerator().getInvoke());
        jCheckBoxInvoke.setText("Invoke DODS generator during project ant rebild");
        jTemplateTypeLabel.setText("Template set :");
        jTemplateTypeLabel.setFont(new java.awt.Font ("SansSerif", 0, 12));
        jComboBoxTemplateSet.setNextFocusableComponent(jCheckBoxForce);
        HashSet  dirs = Common.getAllTemplateSets();
          String  item = null;
          int i = 0;
          int selIndex = 1;
                
         if (dirs!=null){   
            for (Iterator  iter = dirs.iterator(); iter.hasNext(); i++) {
                item = (String ) iter.next();
                jComboBoxTemplateSet.addItem(" " + item);
                if (item.equals(DefaultDODSWizard.getGenerator().getTemplateSet())) {
                    selIndex = i;
                }
            }
                        
            jComboBoxTemplateSet.setSelectedIndex(selIndex);
            jComboBoxTemplateSet.setMinimumSize(new Dimension (135, 20));
            jVendorTypeLabel.setText("DB vendor :");
            jVendorTypeLabel.setFont(new java.awt.Font ("SansSerif", 0, 12));
            jJavaLabel.setText("Java code :");
            jJavaLabel.setFont(new java.awt.Font ("SansSerif", 0, 12));
            Set  vendors = Common.getDodsConfVendorNames();
            String  vendor = null;
    
            i = 0;
            selIndex = 0;
            jComboBoxVendors.addItem(" ");
            for (Iterator  iter = vendors.iterator(); iter.hasNext(); i++) {
                vendor = (String ) iter.next();
                jComboBoxVendors.addItem(" " + vendor);
                if (vendor.equals(DefaultDODSWizard.getGenerator().getDatabase())) {
                    selIndex = i;
                }
            }
         }else{
             JOptionPane.showMessageDialog(null,"Error configuration folder not found.");
             System.exit(1);
         }
        jComboBoxVendors.setSelectedIndex(selIndex);
        jComboBoxVendors.setMinimumSize(new Dimension (121, 20));
        jComboBoxVendors.setNextFocusableComponent(jCheckBoxSQL);
        jSpaceButton.setEnabled(false);
        jSpaceButton.setForeground(Color.lightGray);
        jSpaceButton.setBorder(null);
        jSpaceButton.setMaximumSize(new Dimension (20, 20));
        jSpaceButton.setMinimumSize(new Dimension (20, 20));
        jSpaceButton.setPreferredSize(new Dimension (30, 30));
        jSpaceButton.setActionCommand("");
        jSpaceButton.setFocusPainted(false);
        jSpaceButton.setMargin(new Insets (3, 3, 3, 3));
        jIconLabel.setIconTextGap(10);
        jIconLabel.setIcon(enhydra);
        jPictPanel.setLayout(flowLayout1);
        flowLayout1.setHgap(0);
        flowLayout1.setVgap(20);
        jCheckBoxSQL.setMaximumSize(new Dimension (103, 22));
        jCheckBoxSQL.setMinimumSize(new Dimension (103, 22));
        jCheckBoxSQL.setNextFocusableComponent(jCheckBoxSQLSplitter);
        jCheckBoxSQL.setSelected(false);
        jCheckBoxSQL.setText("SQL generate");
        jCheckBoxSQL.addActionListener(new java.awt.event.ActionListener () {
            public void actionPerformed(ActionEvent  e) {
                jCheckBoxSQL_actionPerformed(e);
            }
        });
        jCheckBoxSQLSplitter.setMaximumSize(new Dimension (103, 22));
        jCheckBoxSQLSplitter.setMinimumSize(new Dimension (103, 22));
        jCheckBoxSQLSplitter.setNextFocusableComponent(jCheckBoxJava);
        jCheckBoxSQLSplitter.setSelected(false);
        jCheckBoxSQLSplitter.setText("SQL splitter");
        jCheckBoxJava.setMaximumSize(new Dimension (104, 22));
        jCheckBoxJava.setMinimumSize(new Dimension (104, 22));
        jCheckBoxJava.setNextFocusableComponent(jCheckBoxCompile);
        jCheckBoxJava.setSelected(false);
        jCheckBoxJava.setText("Java generate");
        jCheckBoxJava.addActionListener(new java.awt.event.ActionListener () {
            public void actionPerformed(ActionEvent  e) {
                jCheckBoxJava_actionPerformed(e);
            }
        });
        jCheckBoxCompile.setMaximumSize(new Dimension (100, 22));
        jCheckBoxCompile.setMinimumSize(new Dimension (100, 22));
        jCheckBoxCompile.setNextFocusableComponent(jCancelButton);
        jCheckBoxCompile.setText("Compile java");
        jCheckBoxCompile.setSelected(false);
        String  action = DefaultDODSWizard.getGenerator().getAction();

        if (action.equals("dods:build_all") || action.equals("dods:sql")
                || action.equals("dods:noCompile")
                || action.equals("build_all_split")
                || action.equals("dods:sqlsplit")
                || action.equals("dods:noCompileSplit")) {
            jCheckBoxSQL.setSelected(true);
        }
        if (action.equals("build_all_split") || action.equals("dods:sqlsplit")
                || action.equals("dods:noCompileSplit")) {
            jCheckBoxSQLSplitter.setSelected(true);
        }
        if (action.equals("dods:build_all") || action.equals("dods:java")
                || action.equals("dods:noCompile")
                || action.equals("build_all_split")
                || action.equals("dods:javaNoCompile")
                || action.equals("dods:noCompileSplit")) {
            jCheckBoxJava.setSelected(true);
        }
        if (action.equals("dods:build_all") || action.equals("dods:java")
                || action.equals("build_all_split")) {
            if (!DefaultDODSWizard.getGenerator().getKelp()) {
                jCheckBoxCompile.setSelected(true);
            }
        }
        int kelp = 0;

        if (DefaultDODSWizard.getGenerator().getKelp()) {
            jContentPanel.add(jCheckBoxInvoke, new XYConstraints(32, 0, -1, -1));
            jContentPanel.add(jTitleLabel, new XYConstraints(35, 35, -1, -1));
            kelp = 10;
        } else {
            jContentPanel.add(jTitleLabel, new XYConstraints(35, 15, -1, -1));
        }
        jContentPanel.add(jConfigDirLabel,
                new XYConstraints(35, 60 + kelp, -1, -1));
        jContentPanel.add(jConfigDirTextField,
                new XYConstraints(130, 60 + kelp, 290, 20));
        jContentPanel.add(jConfigDirButton,
                new XYConstraints(430, 60 + kelp, 65, 20));
        jContentPanel.add(jOutputDirLabel,
                new XYConstraints(35, 95 + kelp, -1, -1));
        jContentPanel.add(jOutputDirTextField,
                new XYConstraints(130, 95 + kelp, 290, 20));
        jContentPanel.add(jOutputDirButton,
                new XYConstraints(430, 95 + kelp, 65, 20));
        jContentPanel.add(jDomlRootLabel,
                new XYConstraints(35, 130 + kelp, -1, -1));
        jContentPanel.add(jDomlTextField,
                new XYConstraints(130, 130 + kelp, 290, 20));
        jContentPanel.add(jDomlButton,
                new XYConstraints(430, 130 + kelp, 65, 20));
        jContentPanel.add(jDocLabel, new XYConstraints(35, 165 + kelp, -1, -1));
        jContentPanel.add(jCheckBoxDoml2Html,
                new XYConstraints(132, 165 + kelp, -1, 20));
        jContentPanel.add(jCheckBoxDoml2Pdf,
                new XYConstraints(212, 165 + kelp, -1, 20));
        jContentPanel.add(jCheckBoxDoml2Xmi,
                new XYConstraints(292, 165 + kelp, -1, 20));
        jContentPanel.add(jCheckBoxDoml2Ptl,
                new XYConstraints(372, 165 + kelp, -1, 20));
        jContentPanel.add(jTemplateTypeLabel,
                new XYConstraints(35, 205 + kelp, -1, -1));
        jContentPanel.add(jComboBoxTemplateSet,
                new XYConstraints(135, 205 + kelp, 165, 20));
        jContentPanel.add(jCheckBoxForce,
                new XYConstraints(372, 205 + kelp, -1, 20));
        jContentPanel.add(jVendorTypeLabel,
                new XYConstraints(35, 240 + kelp, -1, 20));
        jContentPanel.add(jComboBoxVendors,
                new XYConstraints(135, 240 + kelp, -1, 20));
        jContentPanel.add(jCheckBoxSQL,
                new XYConstraints(265, 240 + kelp, -1, 20));
        jContentPanel.add(jCheckBoxSQLSplitter,
                new XYConstraints(372, 240 + kelp, -1, 20));
        jContentPanel.add(jJavaLabel, new XYConstraints(35, 275 + kelp, -1, 20));
        jContentPanel.add(jCheckBoxJava,
                new XYConstraints(135, 275 + kelp, -1, 20));
        if (!DefaultDODSWizard.getGenerator().getKelp()) {
            jContentPanel.add(jCheckBoxCompile,
                    new XYConstraints(265, 275 + kelp, -1, 20));
        }
        jButtonPanel.add(jGenerateButton, null);
        jButtonPanel.add(jSpace, null);
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            jButtonPanel.add(jCloseButton, null);
            jButtonPanel.add(jSpace1, null);
        }
        jButtonPanel.add(jCancelButton, null);
        contentPane.add(jPictPanel, BorderLayout.NORTH);
        contentPane.add(jButtonPanel, BorderLayout.SOUTH);
        jPictPanel.add(jIconLabel, null);
        contentPane.add(jContentPanel, BorderLayout.CENTER);
    }

    public void setDefaultFocus() {
        jGenerateButton.requestFocus();
    }

    // Overridden so we can exit when window is closed
 protected void processWindowEvent(WindowEvent  e) {
        super.processWindowEvent(e);
        if (e.getID() == WindowEvent.WINDOW_CLOSING) {
            DefaultDODSWizard.getGenerator().preCancel();
            if (DefaultDODSWizard.getGenerator().getKelp()) {
                this.dispose();
            } else {
                System.exit(0);
            }
        }
    }

    void jCancelButton_actionPerformed(ActionEvent  e) {
        DefaultDODSWizard.getGenerator().preCancel();
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            this.dispose();
        } else {
            System.exit(0);
        }
    }

    void jCloseButton_actionPerformed(ActionEvent  e) {
        saveParameters();
        DefaultDODSWizard.getGenerator().preClose();
        this.dispose();
    }

    void jOutputDirButton_actionPerformed(ActionEvent  e) {
        JFileChooser  chooser = null;
        File          choice = null;

        chooser = new JFileChooser ();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setFileFilter((javax.swing.filechooser.FileFilter ) new DirectoryFilter());
        chooser.setDialogTitle("Select Project Root");
        chooser.setApproveButtonText("OK");
        String  strFieldText = jDomlTextField.getText();

        if ((strFieldText == null) || strFieldText.equals("")) {
            strFieldText = System.getProperty("user.dir");
        }
        chooser.setCurrentDirectory(new File (strFieldText));
        int v = chooser.showOpenDialog(this);

        this.requestFocus();
        switch (v) {
        case JFileChooser.APPROVE_OPTION:
            if (chooser.getSelectedFile() != null) {
                if (chooser.getSelectedFile().exists()) {
                    choice = chooser.getSelectedFile();
                } else {
                    File  parentFile = new File (chooser.getSelectedFile().getParent());

                    choice = parentFile;
                }
                jOutputDirTextField.setText(choice.getPath());
            }
            break;

        case JFileChooser.CANCEL_OPTION:
        case JFileChooser.ERROR_OPTION:
        }
        chooser.removeAll();
        chooser = null;
    }

    void jDomlButton_actionPerformed(ActionEvent  e) {
        JFileChooser  chooser = null;
        File          choice = null;

        chooser = new JFileChooser ();
        chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
        chooser.setFileFilter((javax.swing.filechooser.FileFilter ) new DomlFilter());
        chooser.setDialogTitle("Select .doml file");
        chooser.setAcceptAllFileFilterUsed(false);
        String  strFieldText = jDomlTextField.getText();

        if ((strFieldText == null) || strFieldText.equals("")) {
            strFieldText = System.getProperty("user.dir");
        }
        chooser.setCurrentDirectory(new File (strFieldText));
        chooser.setApproveButtonText("OK");
        int v = chooser.showOpenDialog(this);

        this.requestFocus();
        switch (v) {
        case JFileChooser.APPROVE_OPTION:
            if (chooser.getSelectedFile() != null) {
                if (chooser.getSelectedFile().exists()) {
                    choice = chooser.getSelectedFile();
                } else {
                    File  parentFile = new File (chooser.getSelectedFile().getParent());

                    choice = parentFile;
                }
                jDomlTextField.setText(choice.getPath());
                String  tempSet = null;
                String  vendor = null;

                try {
                    if (choice.isFile()) {
                        tempSet = XmlUtil.getSingleAttribute(choice.getPath(),
                                "/doml/database@templateset", null);
                        vendor = XmlUtil.getSingleAttribute(choice.getPath(),
                                "/doml/database@database", null);
                    }
                } catch (Exception  ex) {}
                if (tempSet != null) {
                    tempSet = " " + tempSet;
                    for (int i = 0; i < jComboBoxTemplateSet.getItemCount(); i++) {
                        if (((String ) jComboBoxTemplateSet.getItemAt(i)).equals(tempSet)) {
                            jComboBoxTemplateSet.setSelectedIndex(i);
                            break;
                        }
                    }
                }
                if (vendor != null) {
                    vendor = " " + vendor;
                    for (int i = 0; i < jComboBoxVendors.getItemCount(); i++) {
                        if (((String ) jComboBoxVendors.getItemAt(i)).equals(vendor)) {
                            jComboBoxVendors.setSelectedIndex(i);
                            break;
                        }
                    }
                }
            }
            break;

        case JFileChooser.CANCEL_OPTION:
        case JFileChooser.ERROR_OPTION:
        }
        chooser.removeAll();
        chooser = null;
    }

    void jGenerateButton_actionPerformed(ActionEvent  e) {
        try {
            File  outDir = new File (jOutputDirTextField.getText());
            File  dfile = new File (jDomlTextField.getText());

            if (dfile.isFile()) {
                if (!outDir.mkdirs() && !outDir.isDirectory()) {  // making directory
 MessageDialog message = new MessageDialog(" Please enter or choose valid project root directory file ",
                            this, " Invalid project root directory ");
                    Dimension  dimension = Toolkit.getDefaultToolkit().getScreenSize();

                    message.setLocation((dimension.width
                                    - message.getSize().width)
                            / 2,
                            (dimension.height - message.getSize().height) / 2);
                    message.setVisible(true);
                    return;
                }
                saveParameters();
                DefaultDODSWizard.getGenerator().preGenerate();
                // Creating properties file
                Common.setDomlFile(DefaultDODSWizard.getGenerator().getDoml());
                Common.setProjectRoot(DefaultDODSWizard.getGenerator().getOutputDir());
                Common.setConfigDir(DefaultDODSWizard.getGenerator().getConfigDir());
                // Execute action
 ExecThread runEjen = new ExecThread();

                runEjen.start();
            } else {
                MessageDialog message = new MessageDialog(" Please enter or choose valid .doml file ",
                        this, " Invalid .doml file ");
                Dimension  dimension = Toolkit.getDefaultToolkit().getScreenSize();

                message.setLocation((dimension.width - message.getSize().width)
                        / 2,
                        (dimension.height - message.getSize().height) / 2);
                message.setVisible(true);
            }
        } catch (Exception  ex) {
            ex.printStackTrace();
        }
    }

    void saveParameters() {
        DefaultDODSWizard.getGenerator().setOutputDir(jOutputDirTextField.getText());
        DefaultDODSWizard.getGenerator().setDoml(jDomlTextField.getText());
        DefaultDODSWizard.getGenerator().setConfigDir(jConfigDirTextField.getText());
        DefaultDODSWizard.getGenerator().setAction("dods:build_all"); // default
 if (jCheckBoxSQL.isSelected() && !jCheckBoxSQLSplitter.isSelected()
                && !jCheckBoxJava.isSelected()) {
            DefaultDODSWizard.getGenerator().setAction("dods:sql");
        }
        if (jCheckBoxSQL.isSelected() && jCheckBoxSQLSplitter.isSelected()
                && !jCheckBoxJava.isSelected()) {
            DefaultDODSWizard.getGenerator().setAction("dods:sqlsplit");
        }
        if (!jCheckBoxSQL.isSelected() && jCheckBoxJava.isSelected()) {
            if (jCheckBoxCompile.isSelected()) {
                DefaultDODSWizard.getGenerator().setAction("dods:java");
            } else {
                DefaultDODSWizard.getGenerator().setAction("dods:javaNoCompile");
            }
        }
        if (jCheckBoxSQL.isSelected() && jCheckBoxJava.isSelected()) {
            if (jCheckBoxCompile.isSelected()
                    && !jCheckBoxSQLSplitter.isSelected()) {
                DefaultDODSWizard.getGenerator().setAction("dods:build_all");
            } // default
 else if (jCheckBoxCompile.isSelected()
                    && jCheckBoxSQLSplitter.isSelected()) {
                DefaultDODSWizard.getGenerator().setAction("dods:build_all_split");
            } else if (!jCheckBoxCompile.isSelected()
                    && !jCheckBoxSQLSplitter.isSelected()) {
                DefaultDODSWizard.getGenerator().setAction("dods:noCompile");
            } else {
                DefaultDODSWizard.getGenerator().setAction("dods:noCompileSplit");
            }
        }
        if (jCheckBoxDoml2Html.isSelected()) {
            DefaultDODSWizard.getGenerator().setHtml(true);
        } else {
            DefaultDODSWizard.getGenerator().setHtml(false);
        }
        if (jCheckBoxDoml2Pdf.isSelected()) {
            DefaultDODSWizard.getGenerator().setPdf(true);
        } else {
            DefaultDODSWizard.getGenerator().setPdf(false);
        }
        if (jCheckBoxDoml2Xmi.isSelected()) {
            DefaultDODSWizard.getGenerator().setXmi(true);
        } else {
            DefaultDODSWizard.getGenerator().setXmi(false);
        }
        if (jCheckBoxDoml2Ptl.isSelected()) {
            DefaultDODSWizard.getGenerator().setPtl(true);
        } else {
            DefaultDODSWizard.getGenerator().setPtl(false);
        }
        if (jCheckBoxForce.isSelected()) {
            DefaultDODSWizard.getGenerator().setForce("true");
        } else {
            DefaultDODSWizard.getGenerator().setForce("false");
        }
        DefaultDODSWizard.getGenerator().setTemplateSet(((String ) jComboBoxTemplateSet.getSelectedItem()).substring(1));
        if (!((String ) jComboBoxVendors.getSelectedItem()).equals(" ")) {
            DefaultDODSWizard.getGenerator().setDatabase(((String ) jComboBoxVendors.getSelectedItem()).substring(1));
        }
        if (DefaultDODSWizard.getGenerator().getKelp()) {
            if (jCheckBoxInvoke.isSelected()) {
                DefaultDODSWizard.getGenerator().setInvoke(true);
            } else {
                DefaultDODSWizard.getGenerator().setInvoke(false);
            }
        }
    }

    void jCheckBoxSQL_actionPerformed(ActionEvent  e) {
        if (jCheckBoxSQL.isSelected()) {
            jCheckBoxSQLSplitter.setSelected(true);
            jCheckBoxSQLSplitter.setEnabled(true);
        } else {
            jCheckBoxSQLSplitter.setSelected(true);
            jCheckBoxSQLSplitter.setSelected(false);
            jCheckBoxSQLSplitter.setEnabled(false);
            jCheckBoxJava.setSelected(true);
            if (!DefaultDODSWizard.getGenerator().getKelp()) {
                jCheckBoxCompile.setSelected(true);
            }
            jCheckBoxCompile.setEnabled(true);
        }
    }
    
    void jConfigDirButton_actionPerformed(ActionEvent  e) {
        JFileChooser  chooser = null;
        File          choice = null;

        chooser = new JFileChooser ();
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setFileFilter((javax.swing.filechooser.FileFilter ) new DirectoryFilter());
        chooser.setDialogTitle("Select Config Dir");
        chooser.setApproveButtonText("OK");
        String  strFieldText = Common.getConfigDir();

        if ((strFieldText == null) || strFieldText.equals("")) {
            strFieldText = System.getProperty("user.dir");
        }
        chooser.setCurrentDirectory(new File (strFieldText));
        int v = chooser.showOpenDialog(this);

        this.requestFocus();
        switch (v) {
        case JFileChooser.APPROVE_OPTION:
            if (chooser.getSelectedFile() != null) {
                if (chooser.getSelectedFile().exists()) {
                    File  confFile = new File (chooser.getSelectedFile().getAbsolutePath()
                            + File.separator + "dodsConf.xml");

                    if (confFile.exists() || confFile.isFile()) {
                        choice = chooser.getSelectedFile();
                    } else {
                        choice = new File (Common.getConfigDir());
                    }
                } else {
                    choice = new File (Common.getConfigDir());
                }
                jConfigDirTextField.setText(choice.getPath());
                Common.setConfigDir(choice.getPath());
            }
            break;

        case JFileChooser.CANCEL_OPTION:
        case JFileChooser.ERROR_OPTION:
        }
        chooser.removeAll();
        chooser = null;
            
        Set  vendors = Common.getDodsConfVendorNames();
        String  vendor = null;
        int i = 0;
        int selIndex = 0;

        jComboBoxVendors.removeAllItems();
        jComboBoxVendors.addItem(" ");
        for (Iterator  iter = vendors.iterator(); iter.hasNext(); i++) {
            vendor = (String ) iter.next();
            jComboBoxVendors.addItem(" " + vendor);
            if (vendor.equals(DefaultDODSWizard.getGenerator().getDatabase())) {
                selIndex = i;
            }
        }
        jComboBoxVendors.setSelectedIndex(selIndex);
    }

    void jCheckBoxJava_actionPerformed(ActionEvent  e) {
        if (jCheckBoxJava.isSelected()) {
            if (!DefaultDODSWizard.getGenerator().getKelp()) {
                jCheckBoxCompile.setSelected(true);
            }
            jCheckBoxCompile.setEnabled(true);
            jCheckBoxSQLSplitter.setEnabled(true);
        } else {
            jCheckBoxSQL.setSelected(true);
            jCheckBoxSQLSplitter.setEnabled(true);
            if (!DefaultDODSWizard.getGenerator().getKelp()) {
                jCheckBoxCompile.setSelected(false);
            }
            jCheckBoxCompile.setEnabled(false);
        }
    }
}
