/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.cache;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.DataStructCache;
import org.enhydra.dods.cache.QueryCache;

public final class Wrapper {
    private static Wrapper instance = null;
    private long locked = 0L;
    private long timeout;
    protected Vector vec = new Vector();
    protected HashMap nonVisibleSimpleComplexQCList = new HashMap();
    protected HashMap nonVisibleMultiJoinQCList = new HashMap();

    public static Wrapper getInstance() {
        if (null == instance) {
            instance = new Wrapper();
        }
        return instance;
    }

    private Wrapper() {
    }

    public void registerCache(DataStructCache dc) {
        if (dc instanceof QueryCache) {
            this.vec.add(dc);
        }
    }

    public void setTimeout(long to) {
        this.timeout = to;
    }

    public synchronized long lock() {
        if (this.locked > 0L && this.locked < System.currentTimeMillis()) {
            return 0L;
        }
        Enumeration e = this.vec.elements();
        while (e.hasMoreElements()) {
            ((DataStructCache)e.nextElement()).lock();
        }
        this.locked = System.currentTimeMillis() + this.timeout;
        return this.locked;
    }

    public synchronized void unlock(long handle) {
        if (handle != this.locked) {
            DODS.getLogChannel().write(7, "Wrapper: wrong handle to unlock " + handle);
            return;
        }
        Enumeration e = this.vec.elements();
        while (e.hasMoreElements()) {
            ((DataStructCache)e.nextElement()).unlock();
        }
        this.locked = 0L;
    }

    public void removeAllComplexQueries() {
        Enumeration e = this.vec.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof QueryCache)) continue;
            ((QueryCache)obj).getCacheAdministration(2).refresh();
        }
    }

    public void removeAllMultiJoinQueries() {
        Enumeration e = this.vec.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof QueryCache)) continue;
            ((QueryCache)obj).getCacheAdministration(3).refresh();
        }
    }

    public void makeSimpleComplexQCachesInvisible(Vector vecQC) {
        Enumeration e = vecQC.elements();
        while (e.hasMoreElements()) {
            Class doClass = (Class)e.nextElement();
            Method mtd = null;
            QueryCache qc = null;
            try {
                mtd = doClass.getMethod("getConfigurationAdministration", new Class[0]);
                qc = (QueryCache)mtd.invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                DODS.getLogChannel().write(7, "Wrapper: couldn't get QueryCache for " + doClass);
                continue;
            }
            Integer intObj = (Integer)this.nonVisibleSimpleComplexQCList.get(qc);
            if (intObj != null) {
                int num = intObj;
                this.nonVisibleSimpleComplexQCList.put(qc, new Integer(++num));
                continue;
            }
            this.nonVisibleSimpleComplexQCList.put(qc, new Integer(1));
            qc.lockSimpleComplexQCache();
        }
    }

    public void makeSimpleComplexQCachesVisible(Vector vecQC) {
        Enumeration e = vecQC.elements();
        while (e.hasMoreElements()) {
            Class doClass = (Class)e.nextElement();
            Method mtd = null;
            QueryCache qc = null;
            try {
                mtd = doClass.getMethod("getConfigurationAdministration", new Class[0]);
                qc = (QueryCache)mtd.invoke(null, new Object[0]);
            }
            catch (Throwable t) {
                DODS.getLogChannel().write(7, "Wrapper: couldn't get QueryCache for " + doClass);
                continue;
            }
            Integer intObj = (Integer)this.nonVisibleSimpleComplexQCList.get(qc);
            if (intObj == null) continue;
            int num = intObj;
            if (--num == 0) {
                this.nonVisibleSimpleComplexQCList.remove(qc);
                qc.unlockSimpleComplexQCache();
                continue;
            }
            this.nonVisibleSimpleComplexQCList.put(qc, new Integer(num));
        }
    }

    public void makeMultiJoinQCachesInvisible() {
        Enumeration e = this.vec.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (!(obj instanceof QueryCache)) continue;
            QueryCache qc = (QueryCache)obj;
            Integer intObj = (Integer)this.nonVisibleMultiJoinQCList.get(qc);
            if (intObj != null) {
                int num = intObj;
                this.nonVisibleMultiJoinQCList.put(qc, new Integer(++num));
                continue;
            }
            this.nonVisibleMultiJoinQCList.put(qc, new Integer(1));
            qc.lockMultiJoinQCache();
        }
    }

    public void makeMultiJoinQCachesVisible() {
        Enumeration e = this.vec.elements();
        while (e.hasMoreElements()) {
            QueryCache qc;
            Integer intObj;
            Object obj = e.nextElement();
            if (!(obj instanceof QueryCache) || (intObj = (Integer)this.nonVisibleSimpleComplexQCList.get(qc = (QueryCache)obj)) == null) continue;
            int num = intObj;
            if (--num == 0) {
                this.nonVisibleMultiJoinQCList.remove(qc);
                qc.unlockMultiJoinQCache();
                continue;
            }
            this.nonVisibleMultiJoinQCList.put(qc, new Integer(num));
        }
    }
}

