/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods;

import com.lutris.appserver.server.sql.DatabaseManager;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.StandardDatabaseManager;
import com.lutris.logging.LogChannel;
import com.lutris.logging.Logger;
import com.lutris.logging.StandardLogger;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.ConfigFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.enhydra.dods.Common;
import org.enhydra.dods.DODSException;

public class DODS {
    private static HashMap databaseManagers;
    private static DatabaseManager defaultDatabaseManager;
    private static HashMap logChannels;
    private static LogChannel defaultLogChannel;
    private static boolean threading;
    private static boolean dodsConfigured;

    public static void registerDefault(DatabaseManager databaseManager) {
        defaultDatabaseManager = databaseManager;
        DODS.setDodsConfigured(true);
    }

    public static void registerDefault(String fileName) throws ConfigException, DatabaseManagerException, SQLException {
        defaultDatabaseManager = StandardDatabaseManager.newInstance(fileName);
        DODS.setDodsConfigured(true);
    }

    public static void register(DatabaseManager databaseManager) {
        if (threading) {
            databaseManagers.put(Thread.currentThread(), databaseManager);
            if (defaultDatabaseManager == null) {
                defaultDatabaseManager = databaseManager;
            }
            DODS.setDodsConfigured(true);
            return;
        }
        defaultDatabaseManager = databaseManager;
        DODS.setDodsConfigured(true);
    }

    public static void startup(String fileName) throws ConfigException, DatabaseManagerException, SQLException {
        LogChannel channel = null;
        try {
            channel = DODS.getLogChannel(fileName);
        }
        catch (Exception ex) {
            throw new ConfigException("Unable to invoke Logging Class defined in : " + fileName);
        }
        defaultLogChannel = channel;
        DatabaseManager databaseManager = StandardDatabaseManager.newInstance(fileName);
        if (threading) {
            databaseManagers.put(Thread.currentThread(), databaseManager);
            logChannels.put(Thread.currentThread(), channel);
            if (defaultDatabaseManager == null) {
                defaultDatabaseManager = databaseManager;
            }
            defaultLogChannel = channel;
            DODS.setDodsConfigured(true);
            return;
        }
        defaultDatabaseManager = databaseManager;
        ((StandardDatabaseManager)databaseManager).initChaches(databaseManager.getClass().getClassLoader());
        DODS.setDodsConfigured(true);
    }

    public static void startup(URL confURL, String confFile) throws ConfigException, DatabaseManagerException, SQLException {
        LogChannel channel = null;
        try {
            channel = DODS.getLogChannel(confURL, confFile);
        }
        catch (Exception ex) {
            throw new ConfigException("Unable to invoke Logging Class defined in : " + confFile);
        }
        defaultLogChannel = channel;
        DatabaseManager databaseManager = StandardDatabaseManager.newInstance(confURL, confFile);
        if (threading) {
            databaseManagers.put(Thread.currentThread(), databaseManager);
            logChannels.put(Thread.currentThread(), channel);
            if (defaultDatabaseManager == null) {
                defaultDatabaseManager = databaseManager;
            }
            defaultLogChannel = channel;
            DODS.setDodsConfigured(true);
            return;
        }
        defaultDatabaseManager = databaseManager;
        ((StandardDatabaseManager)databaseManager).initChaches(databaseManager.getClass().getClassLoader());
        DODS.setDodsConfigured(true);
    }

    public static void startup(Thread thread, String fileName) throws ConfigException, DatabaseManagerException, SQLException {
        LogChannel channel = null;
        try {
            channel = DODS.getLogChannel(fileName);
        }
        catch (Exception ex) {
            throw new ConfigException("Unable to invoke Logging Class defined in : " + fileName);
        }
        logChannels.put(Thread.currentThread(), channel);
        DatabaseManager databaseManager = StandardDatabaseManager.newInstance(fileName);
        databaseManagers.put(thread, databaseManager);
        if (defaultDatabaseManager == null) {
            defaultLogChannel = channel;
            defaultDatabaseManager = databaseManager;
        }
        ((StandardDatabaseManager)databaseManager).initChaches(databaseManager.getClass().getClassLoader());
        DODS.setDodsConfigured(true);
    }

    private static LogChannel getLogChannel(String cf) throws Exception {
        try {
            FileInputStream configFIS = new FileInputStream(cf);
            ConfigFile cFile = new ConfigFile((InputStream)configFIS);
            Config config = cFile.getConfig();
            configFIS.close();
            Config logSection = (Config)config.getSection("DatabaseManager");
            String logClassName = logSection.getString("LogClassName", "com.lutris.logging.StandardLogger");
            Class[] argTypeArr = new Class[]{Boolean.TYPE};
            Object[] argArr = new Object[]{new Boolean(false)};
            Class<?> loggerClass = Class.forName(logClassName);
            Constructor<?> logConstructor = loggerClass.getConstructor(argTypeArr);
            Logger logger = (Logger)logConstructor.newInstance(argArr);
            logger.configure(logSection);
            return logger.getChannel("DatabaseManager");
        }
        catch (Throwable throwable) {
            return DODS.getLogChannel(null, cf);
        }
    }

    private static LogChannel getLogChannel(URL confURL, String confFile) throws ConfigException {
        try {
            InputStream configIS = Common.getConfFileFromURL(confURL, confFile);
            ConfigFile configFile = new ConfigFile(configIS);
            Config config = configFile.getConfig();
            configIS.close();
            Config logSection = (Config)config.getSection("DatabaseManager");
            String logClassName = logSection.getString("LogClassName", "com.lutris.logging.StandardLogger");
            Class[] argTypeArr = new Class[]{Boolean.TYPE};
            Object[] argArr = new Object[]{new Boolean(false)};
            Class<?> loggerClass = Class.forName(logClassName);
            Constructor<?> logConstructor = loggerClass.getConstructor(argTypeArr);
            Logger logger = (Logger)logConstructor.newInstance(argArr);
            logger.configure(logSection);
            return logger.getChannel("DatabaseManager");
        }
        catch (Throwable throwable) {
            return DODS.configureStandardLogerChannel();
        }
    }

    public static LogChannel configureStandardLogerChannel() throws ConfigException {
        Object channel = null;
        try {
            File logFile = new File("DatabaseManager.log");
            StandardLogger logger = new StandardLogger(false);
            String[] fileLogLevels = new String[]{"EMERGENCY", "ALERT", "CRITICAL", "ERROR", "WARNING", "NOTICE", "INFO"};
            String[] stdErrLogLevels = new String[]{"EMERGENCY", "ALERT", "CRITICAL", "ERROR", "WARNING", "NOTICE", "INFO"};
            logger.configure(logFile, fileLogLevels, stdErrLogLevels);
            return logger.getChannel("databaseManager");
        }
        catch (Exception ex) {
            throw new ConfigException("Unable to invoke standard logger.");
        }
    }

    public static void register(Thread thread, DatabaseManager databaseManager) {
        databaseManagers.put(thread, databaseManager);
        if (defaultDatabaseManager == null) {
            defaultDatabaseManager = databaseManager;
        }
        DODS.setDodsConfigured(true);
    }

    public static void registerDefaultLogChannel(LogChannel channel) {
        defaultLogChannel = channel;
    }

    public static void registerLogChannel(LogChannel channel) {
        if (threading) {
            logChannels.put(Thread.currentThread(), channel);
        }
        if (defaultLogChannel == null) {
            defaultLogChannel = channel;
        }
    }

    public static void registerLogChannel(Thread thread, LogChannel channel) {
        logChannels.put(thread, channel);
        if (defaultLogChannel == null) {
            defaultLogChannel = channel;
        }
    }

    public static DatabaseManager unregisterDefault() throws DODSException {
        try {
            DatabaseManager dbManager = defaultDatabaseManager;
            defaultDatabaseManager = null;
            return dbManager;
        }
        catch (Exception e) {
            throw new DODSException((Throwable)e);
        }
    }

    public static DatabaseManager unregister() throws DODSException {
        try {
            if (threading) {
                return (DatabaseManager)databaseManagers.remove(Thread.currentThread());
            }
            DatabaseManager dbManager = defaultDatabaseManager;
            defaultDatabaseManager = null;
            return dbManager;
        }
        catch (Exception e) {
            throw new DODSException((Throwable)e);
        }
    }

    public static DatabaseManager unregister(Thread thread) throws DODSException {
        try {
            return (DatabaseManager)databaseManagers.remove(thread);
        }
        catch (Exception e) {
            throw new DODSException((Throwable)e);
        }
    }

    public static LogChannel unregisterDefaultLogChannel() throws DODSException {
        try {
            LogChannel channel = defaultLogChannel;
            defaultLogChannel = null;
            return channel;
        }
        catch (Exception e) {
            throw new DODSException((Throwable)e);
        }
    }

    public static LogChannel unregisterLogChannel() throws DODSException {
        try {
            if (threading) {
                return (LogChannel)logChannels.remove(Thread.currentThread());
            }
            return DODS.unregisterDefaultLogChannel();
        }
        catch (Exception e) {
            throw new DODSException((Throwable)e);
        }
    }

    public static LogChannel unregisterLogChannel(Thread thread) throws DODSException {
        try {
            return (LogChannel)logChannels.remove(thread);
        }
        catch (Exception e) {
            throw new DODSException((Throwable)e);
        }
    }

    public static DatabaseManager getDefaultDatabaseManager() {
        DODS.checkDodsConfiguration();
        return defaultDatabaseManager;
    }

    public static DatabaseManager getDatabaseManager() {
        DatabaseManager dbManager;
        DODS.checkDodsConfiguration();
        if (threading && (dbManager = (DatabaseManager)databaseManagers.get(Thread.currentThread())) != null) {
            return dbManager;
        }
        return defaultDatabaseManager;
    }

    public static DatabaseManager getDatabaseManager(Thread thread) {
        DODS.checkDodsConfiguration();
        DatabaseManager dbManager = (DatabaseManager)databaseManagers.get(thread);
        if (dbManager != null) {
            return dbManager;
        }
        return defaultDatabaseManager;
    }

    public static LogChannel getDefaultLogChannel() {
        try {
            if (defaultLogChannel == null) {
                defaultLogChannel = DODS.configureStandardLogerChannel();
            }
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        return defaultLogChannel;
    }

    public static LogChannel getLogChannel() {
        LogChannel channel;
        if (threading && (channel = (LogChannel)logChannels.get(Thread.currentThread())) != null) {
            return channel;
        }
        return DODS.getDefaultLogChannel();
    }

    public static LogChannel getLogChannel(Thread thread) {
        LogChannel channel = (LogChannel)logChannels.get(thread);
        if (channel != null) {
            return channel;
        }
        return defaultLogChannel;
    }

    public static void shutdown() throws DODSException {
        try {
            if (threading) {
                Set keys = databaseManagers.keySet();
                for (Thread key : keys) {
                    DatabaseManager dbManager = (DatabaseManager)databaseManagers.remove(key);
                    if (dbManager == null) continue;
                    dbManager.shutdown();
                    Object var3_4 = null;
                }
                keys = logChannels.keySet();
                for (Thread key : keys) {
                    logChannels.remove(key);
                }
            }
            if (defaultDatabaseManager != null) {
                defaultDatabaseManager.shutdown();
                defaultDatabaseManager = null;
            }
            dodsConfigured = false;
        }
        catch (Exception e) {
            throw new DODSException((Throwable)e);
        }
    }

    public static boolean isThreading() {
        return threading;
    }

    public static void setThreading(boolean mode) {
        threading = mode;
    }

    protected static void init() {
        dodsConfigured = false;
        threading = false;
        databaseManagers = new HashMap();
        logChannels = new HashMap();
    }

    private static void checkDodsConfiguration() {
        block7: {
            String confFilePath = null;
            try {
                if (dodsConfigured) break block7;
                confFilePath = System.getProperty("dodsConfigFile");
                if (null == confFilePath) {
                    try {
                        InitialContext initContext = new InitialContext();
                        Context envContext = (Context)initContext.lookup("java:/comp/env");
                        confFilePath = (String)envContext.lookup("dods/dodsConfigFile");
                    }
                    catch (Exception initContext) {
                        // empty catch block
                    }
                }
                if (confFilePath != null) {
                    DODS.startup(confFilePath);
                } else {
                    DODS.startup((URL)null, "/dods/conf/databaseManager.conf");
                }
            }
            catch (Exception e) {
                dodsConfigured = false;
            }
        }
    }

    protected static boolean isDodsConfigured() {
        return dodsConfigured;
    }

    protected static void setDodsConfigured(boolean configured) {
        dodsConfigured = configured;
    }

    static {
        DODS.init();
    }
}

