/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods;

import com.lutris.util.ConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.enhydra.dods.wizard.DirectoryNameFilter;
import org.enhydra.xml.XMLConfig;
import org.enhydra.xml.XMLDocumentFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class Common {
    public static final String VENDOR_ORDERED_RESULT_SET = "OrderedResultSet";
    protected static boolean configured = false;
    protected static String configDir = null;
    public static final String DODS_CONF_JAR_PATH = "org/enhydra/dods/conf";
    public static final String DATABASE_MANAGER_CONF_FILE = "dods/conf/databaseManager.conf";
    protected static Properties dods_conf;
    protected static String dbase;
    protected static XMLConfig dodsConf;
    protected static HashMap dodsVendorConfs;
    protected static HashMap dodsDriversMap;
    protected static Vector dodsDriversNamesVec;
    protected static Vector dodsVendorsNamesVec;
    protected static Vector dodsDriverClassVec;
    protected static String projRoot;
    protected static String domlfile;
    protected static String customTemplateDir;
    protected static HashMap changeAutocommit;
    protected static String templateSet;

    public static void setChangeAutocommit(String dbName, boolean value) {
        Boolean newValue = new Boolean(value);
        changeAutocommit.put(dbName, newValue);
    }

    public static boolean isChangeAutocommitEnabled(String dbName) {
        Boolean res = (Boolean)changeAutocommit.get(dbName);
        if (res == null) {
            return true;
        }
        return res;
    }

    private static void init() {
        if (!configured) {
            if (configDir != null) {
                Common.init(configDir);
            } else {
                Common.init(Common.getDefaultConfigDir());
            }
        }
    }

    private static void init(String confDir) {
        Common.setConfigDir(confDir);
        String dodsFile = confDir + File.separator + "dodsConf.xml";
        dodsFile.replace('\\', '/');
        Document doc = null;
        if (confDir != null) {
            doc = XMLDocumentFactory.parse((String)dodsFile);
        } else {
            try {
                Class<?> comClass = Class.forName("org.enhydra.dods.Common");
                InputStream inStream = comClass.getClassLoader().getResourceAsStream("org/enhydra/dods/conf/dodsConf.xml");
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                doc = builder.parse(inStream);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        dodsConf = XMLConfig.newXMLConfigInstance((Document)doc);
        dodsVendorConfs = new HashMap();
        dodsDriversMap = new HashMap();
        dodsDriversNamesVec = new Vector();
        dodsVendorsNamesVec = new Vector();
        dodsDriverClassVec = new Vector();
        XMLConfig vendor = null;
        String vendorName = null;
        String vendorFile = null;
        NodeList vendors = dodsConf.getSubElementsByTagName("Database/Vendor");
        for (int i = 0; i < vendors.getLength(); ++i) {
            vendor = (XMLConfig)vendors.item(i);
            vendorName = vendor.getAttribute("name");
            vendorFile = confDir + File.separator + vendor.getText();
            if (confDir != null) {
                doc = XMLDocumentFactory.parse((String)vendorFile);
            } else {
                try {
                    Class<?> comClass = Class.forName("org.enhydra.dods.Common");
                    InputStream inStream = comClass.getClassLoader().getResourceAsStream("org/enhydra/dods/conf/" + vendor.getText());
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    doc = builder.parse(inStream);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            XMLConfig dodsVendorConf = XMLConfig.newXMLConfigInstance((Document)doc);
            dodsVendorConfs.put(vendorName, dodsVendorConf);
        }
        NodeList driverVendorsNl = dodsConf.getSubElementsByTagName("Drivers/DatabaseVendor");
        for (int i = 0; i < driverVendorsNl.getLength(); ++i) {
            XMLConfig driverN = (XMLConfig)driverVendorsNl.item(i);
            String driverVendorName = driverN.getAttribute("name");
            NodeList driverClassesNl = driverN.getChildrenByTagName("Driver");
            for (int j = 0; j < driverClassesNl.getLength(); ++j) {
                String driverClassName = null;
                String driverMetadataName = null;
                XMLConfig driver = (XMLConfig)driverClassesNl.item(j);
                driverClassName = driver.getAttribute("class");
                driverMetadataName = driver.getAttribute("name");
                if (driverClassName != null && driverClassName != "") {
                    dodsDriversMap.put(driverClassName, driverVendorName);
                }
                if (driverMetadataName == null || driverMetadataName == "") continue;
                dodsDriverClassVec.add(driverClassName);
                dodsDriversNamesVec.add(driverMetadataName);
                dodsVendorsNamesVec.add(driverVendorName);
            }
        }
        configured = true;
    }

    public static String getDatabaseVendor(String driverClassName) {
        String res = null;
        Common.init();
        if (driverClassName != null && dodsDriversMap.containsKey(driverClassName)) {
            res = (String)dodsDriversMap.get(driverClassName);
        } else {
            System.out.println("Unknown JDBC Driver Vendor for : " + driverClassName + " using default (Standard) insted");
            res = "Standard";
        }
        return res;
    }

    public static String getDatabaseVendorFromDriverName(String driverMetadataName) throws ConfigException {
        Common.init();
        int vendorIndex = -1;
        for (int i = 0; i < dodsDriversNamesVec.size(); ++i) {
            if (driverMetadataName.indexOf((String)dodsDriversNamesVec.elementAt(i)) == -1) continue;
            String res = (String)dodsVendorsNamesVec.elementAt(i);
            return (String)dodsVendorsNamesVec.elementAt(i);
        }
        throw new ConfigException("Unknown JDBC Driver Vendor for : " + driverMetadataName);
    }

    public static String getDatabaseDriverClassFromDriverName(String driverMetadataName) throws ConfigException {
        Common.init();
        int vendorIndex = -1;
        for (int i = 0; i < dodsDriversNamesVec.size(); ++i) {
            if (driverMetadataName.indexOf((String)dodsDriversNamesVec.elementAt(i)) == -1) continue;
            String res = (String)dodsVendorsNamesVec.elementAt(i);
            return (String)dodsDriverClassVec.elementAt(i);
        }
        throw new ConfigException("Unknown JDBC Driver for : " + driverMetadataName);
    }

    public static XMLConfig getDodsConf() {
        Common.init();
        return dodsConf;
    }

    public static String getDodsConfProperty(String key, String database) {
        Common.init();
        XMLConfig vendor = (XMLConfig)dodsVendorConfs.get(database);
        if (vendor != null) {
            return vendor.getText(key);
        }
        return null;
    }

    public static void showDodsConf() {
        Common.init();
        StringBuffer ret = new StringBuffer();
        for (Map.Entry<Object, Object> elm : dods_conf.entrySet()) {
            ret.append(elm.getKey()).append("=").append(elm.getValue()).append("\n");
        }
    }

    public static Set getDodsConfVendorNames() {
        Common.init();
        return dodsVendorConfs.keySet();
    }

    public static String getDodsEjenPropertyFilename() {
        String SYS_USER_HOME = "user.home";
        String DIR_ENHYDRA = ".enhydra";
        String PROPERTY_FILENAME = "dods-ejen.properties";
        StringBuffer buf = new StringBuffer();
        buf.append(System.getProperties().getProperty("user.home"));
        buf.append(File.separator);
        buf.append(".enhydra");
        buf.append(File.separator);
        buf.append("dods-ejen.properties");
        return buf.toString();
    }

    public static String getDomlFile() {
        Common.init();
        String strDoml = null;
        strDoml = System.getProperty("DOML_FILE");
        String domlFile = null;
        if (strDoml == null) {
            File current = new File(".");
            String[] files = current.list();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].toLowerCase().endsWith(".doml")) {
                    domlFile = files[i];
                    break;
                }
                domlFile = null;
            }
            strDoml = domlFile;
        }
        return strDoml;
    }

    public static String getDomlFileName() {
        Common.init();
        String domlFileName = Common.getDomlFile();
        String fileSep = System.getProperty("file.separator");
        if (System.getProperty("os.name").toLowerCase().startsWith("win") && fileSep != "/") {
            domlFileName = domlFileName.replace('\\', '/');
        }
        return domlFileName.substring(domlFileName.lastIndexOf("/") + 1);
    }

    public static String getFileName() {
        Common.init();
        String fileName = Common.getDomlFileName();
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static String getDatabaseVendor() {
        Common.init();
        String database = System.getProperty("DATABASE_VENDOR");
        return database;
    }

    public static String getSplitSQLPrimary() {
        String ret = "true";
        try {
            ret = Common.getDodsConfProperty("SplitSQLPrimary", Common.getDatabaseVendor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null) {
            return "true";
        }
        return ret;
    }

    public static void setDomlFile(String doml) {
        domlfile = doml;
    }

    public static void setConfigDir(String confD) {
        if (confD != null) {
            File tempFile = new File(confD + File.separator + "dodsConf.xml");
            if (!tempFile.isFile()) {
                System.out.println("File dodsConf.xml not exists on path: '" + confD + "' using default insted");
                confD = Common.getDefaultConfigDir();
            }
            configDir = confD;
        } else {
            configDir = Common.getDefaultConfigDir();
        }
        configured = false;
    }

    public static String getDefaultConfigDir() {
        String dodsHome = System.getProperty("DODS_HOME");
        if (dodsHome == null) {
            dodsHome = System.getProperty("enhydra.home");
            if (dodsHome != null) {
                dodsHome = dodsHome + File.separator + "dods";
            } else {
                return null;
            }
        }
        String resultStr = dodsHome + File.separator + "build" + File.separator + "conf";
        return resultStr;
    }

    public static String getConfigDir() {
        Common.init();
        String resultStr = configDir;
        if (configDir == null) {
            resultStr = Common.getDefaultConfigDir();
        }
        return resultStr;
    }

    public static InputStream getConfFileFromURL(URL confURL, String confFile) throws ConfigException {
        if (confURL != null) {
            URL[] cURL = new URL[]{confURL};
        } else {
            URL[] cURL = new URL[]{};
        }
        ClassLoader ucl = Common.class.getClassLoader();
        InputStream configIS = null;
        if (confFile != null) {
            try {
                configIS = ucl.getResourceAsStream(confFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (configIS == null) {
            try {
                configIS = ucl.getResourceAsStream(DATABASE_MANAGER_CONF_FILE);
            }
            catch (Exception e) {
                throw new ConfigException((Throwable)e);
            }
        }
        return configIS;
    }

    public static void setCustomTemplateDir(String dirString) {
        customTemplateDir = dirString;
    }

    public static String getCustomTemplateDir() {
        Common.init();
        return customTemplateDir;
    }

    public static String getProjectRoot() {
        String projectRoot = null;
        projectRoot = System.getProperty("PROJECT_ROOT");
        if (projectRoot == null) {
            projectRoot = ".";
        }
        return projectRoot;
    }

    public static void setProjectRoot(String projectRoot) {
        projRoot = projectRoot;
    }

    public static String getTemplateSet() {
        String tempSet = System.getProperty("TEMPLATESET");
        if (tempSet == null) {
            tempSet = "standard";
        }
        if (tempSet.equals("multidb")) {
            tempSet = "standard";
        }
        if (tempSet.equals("webdocwf")) {
            tempSet = "webdocwf";
        }
        if (tempSet.equals("multidb_webdocwf")) {
            tempSet = "webdocwf";
        }
        return tempSet;
    }

    public static void setTemplateSet(String set) {
        templateSet = set;
    }

    public static String getExtensions() {
        String tempSet = null;
        tempSet = System.getProperty("TEMPLATESET");
        if (tempSet == null) {
            tempSet = "standard";
        }
        return tempSet;
    }

    public static String getForce() {
        String force = System.getProperty("FORCE");
        return force;
    }

    public static String getInstallProperties() {
        String dodsHome = null;
        String home = null;
        try {
            Properties properties = new Properties();
            String strFileSep = System.getProperty("file.separator");
            home = System.getProperty("DODS_HOME");
            dodsHome = home + strFileSep + "build" + strFileSep + "dods.properties";
            if (System.getProperty("os.name").toLowerCase().startsWith("win") && dodsHome != "/") {
                dodsHome = dodsHome.replace('/', '\\');
            }
            if (home == null) {
                dodsHome = System.getProperty("ENHYDRA_DIR") + strFileSep + "dods.properties";
                if (System.getProperty("os.name").toLowerCase().startsWith("win") && dodsHome != "/") {
                    dodsHome = dodsHome.replace('/', '\\');
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return dodsHome;
    }

    public static String getDODSRoot() {
        String enhHome = null;
        try {
            String strFileSep = System.getProperty("file.separator");
            enhHome = System.getProperty("DODS_HOME");
            if (System.getProperty("os.name").toLowerCase().startsWith("win") && enhHome != "/") {
                enhHome = enhHome.replace('\\', '/');
            }
            if (enhHome == null) {
                String strInstall = Common.getInstallProperties();
                if (System.getProperty("os.name").toLowerCase().startsWith("win") && System.getProperty("file.separator") != "/") {
                    strInstall = strInstall.replace('/', '\\');
                }
                FileInputStream fisInstallProp = new FileInputStream(strInstall);
                Properties properties = new Properties();
                properties.load(fisInstallProp);
                enhHome = properties.getProperty("enhydra.root");
                if (System.getProperty("os.name").toLowerCase().startsWith("win") && enhHome != "/") {
                    enhHome = enhHome.replace('/', '\\');
                }
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return enhHome;
    }

    public static String getInstallPropertiesParam() {
        String enhydraRoot = null;
        String dodsConf = null;
        String strReturn = null;
        Common.init();
        try {
            Properties properties = new Properties();
            String strFileSep = System.getProperty("file.separator");
            String strInstall = Common.getInstallProperties();
            if (System.getProperty("os.name").toLowerCase().startsWith("win") && strFileSep != "/") {
                strInstall = strInstall.replace('/', '\\');
            }
            FileInputStream fisInstallProp = new FileInputStream(strInstall);
            properties.load(fisInstallProp);
            enhydraRoot = properties.getProperty("enhydra.root");
            if (System.getProperty("os.name").toLowerCase().startsWith("win") && enhydraRoot != "/") {
                enhydraRoot = enhydraRoot.replace('/', '\\');
            }
            dodsConf = properties.getProperty("dods.conf");
            if (System.getProperty("os.name").toLowerCase().startsWith("win") && dodsConf != "/") {
                dodsConf = dodsConf.replace('/', '\\');
            }
            fisInstallProp.close();
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        strReturn = "<property name=\"enhydra.root\" value=\"" + enhydraRoot + "\"/>\n";
        strReturn = strReturn + "<property name=\"dods.conf\" value=\"" + dodsConf + "\"/>\n";
        return strReturn;
    }

    public static String getTemplateDir() {
        String templateDir = null;
        Common.init();
        try {
            Properties properties = new Properties();
            String strFileSep = System.getProperty("file.separator");
            String strInstall = Common.getInstallProperties();
            if (System.getProperty("os.name").toLowerCase().startsWith("win") && strFileSep != "/") {
                strInstall = strInstall.replace('/', '\\');
            }
            FileInputStream fisDodsEjen = new FileInputStream(strInstall);
            properties.load(fisDodsEjen);
            fisDodsEjen.close();
            templateDir = properties.getProperty("template.dir");
            if (System.getProperty("os.name").toLowerCase().startsWith("win") && templateDir != "/") {
                templateDir = templateDir.replace('/', '\\');
            }
        }
        catch (IOException properties) {
        }
        catch (NullPointerException nullpointerexception) {
            return null;
        }
        return templateDir;
    }

    public static HashSet getAllTemplateSets() {
        HashSet<String> dirs = new HashSet<String>();
        Common.init();
        try {
            File templateDirs = new File(Common.getTemplateDir());
            String[] temp = templateDirs.list(new DirectoryNameFilter());
            dirs.add("standard");
            for (int i = 0; i < temp.length; ++i) {
                dirs.add(temp[i]);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return dirs;
    }

    public static String capitalizeName(String name) {
        String otherLetters = name.substring(1);
        return name.toUpperCase(Locale.ENGLISH).substring(0, 1).concat(otherLetters);
    }

    public static String upperCaseName(String name) {
        return name.toUpperCase();
    }

    public static String replaceAll(String input, String forReplace, String replaceWith) {
        if (input == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        boolean hasMore = true;
        while (hasMore) {
            int start = input.indexOf(forReplace);
            int end = start + forReplace.length();
            if (start != -1) {
                result.append(input.substring(0, start) + replaceWith);
                input = input.substring(end);
                continue;
            }
            hasMore = false;
            result.append(input);
        }
        if (result.toString().equals("")) {
            return input;
        }
        return result.toString();
    }

    public static void main(String[] args) {
        Common.showDodsConf();
        System.out.println("Database.OidJdbcType = " + Common.getDodsConfProperty("Database.OidJdbcType", "Standard"));
    }

    static {
        customTemplateDir = null;
        changeAutocommit = new HashMap();
    }
}

