
/**
 * Title:        WebDocWf AccessRightException<p>
 * Description:  AccessEvalException is thrown if a user is not allowed to perform a vertain access<p>
 * Copyright:    Copyright (c) Together Teamlösungen EDV-Dienstleistungen GmbH. under LGPL<p>
 * Company:      Together Teamlösungen EDV-Dienstleistungen GmbH.<p>
 * @author Alfred Madl (a.madl@together.at)
 * @version 1.0
 */
package org.webdocwf.dods.access;

public class AccessRightException extends AccessException {

    /**
     * Construct an exception without a specified message.
     *
     * @param msg The message associated with the exception.
     */
    public AccessRightException(String  msg) {
        super(msg);
    }

    /**
     * Construct an exception with a message and detail data.
     *
     * @param msg The message associated with the exception.
     * @param inUsr The user for the access right check
     * @param inOperation The desired operation
     * @param inObj The accessed object
     * @param inClassName The accessed class
     * @param inAttrName The accessed attribute
     * @param inValue The accessed value
     * @param inOldValue The new value in set-operations
     * @param inDatatype The datatype of the value
     * @param inCmp_op The comparison operator for queries
     */
    public AccessRightException(String  msg, User inUsr, String  inOperation, SecureDO inObj, String  inClassName, String  inAttrName, String  inValue, String  inOldValue, String  inDatatype, String  inCmp_op) {
        super(msg, inUsr, inOperation, inObj, inClassName, inAttrName, inValue,
                inOldValue, inDatatype, inCmp_op);
    }
}
