
package org.enhydra.dods;

/**
 * DriverDependancies
 *
 * @author Vladimir Puskas
 */
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.dods.builder.generator.query.RDBColumn;
import java.sql.ResultSet ;
import java.sql.SQLException ;

public interface DriverDependencies {
    /**
     * Method insertBlob
     *
     * @param    rs                  a  ResultSet
     * @param    cont                a  byte[]
     * @param    column              a  RDBColumn
     * @param    handle              a  String
     *
     * @exception   SQLException
     */
    public void insertBlob(DBConnection conn,
                           byte[] cont,
                           RDBColumn primary,
                           RDBColumn blobColumn,
                           String  handle) throws SQLException ;

    /**
     * Method readBlob
     *
     * @param    blob                a  Blob
     *
     * @return   a byte[]
     *
     * @exception   SQLException
     */
    public byte[] readBlob(ResultSet  rs, String  colName) throws SQLException ;
    public boolean isBlobAccessSpecial();
}
