
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: CoreDataStruct.java,v 1.1 2004/09/03 13:42:38 sinisa Exp $
 */
package com.lutris.appserver.server.sql;

import org.enhydra.dods.cache.Condition;

/**
 * Base class from which the data objects are derived.
 *
 * @version $Revision: 1.1 $
 * @author Kyle Clark
 */
abstract public class CoreDataStruct {

    /**
     * The 'oid' and 'version' column names are made public so
     * they can be modified by StandardDatabaseManager.
     * These could be maintained in the LogicalDatabase but that
     * would require extensive modifications to DBTransaction and
     * DBQuery.
     * This means that you are currently limited to using the
     * same column names for all databases in applications using
     * multiple databases.
     */
    private static String  oidColumnName = "oid";
    private static String  versionColumnName = "version";
    // The object id associated with this object.
 protected ObjectId oId;
    // The version of this object.
 protected int version = 0;
    // The next version of this object.
 protected int newVersion = 0;

    /**
     * Public constructor.
     */
    public CoreDataStruct() {}

    /**
     * Returns the object identifier column name.
     * @return the object identifier column name.
     */
    protected static String  get_OIdColumnName() {
        return oidColumnName;
    }

    /**
     * Sets the object identifier column name.
     * @param _oidColumnName Name of object identifier column.
     */
    protected static void set_OIdColumnName(String  _oidColumnName) {
        oidColumnName = _oidColumnName;
    }

    /**
     * Returns the version column name.
     * @return the version column name.
     */
    protected static String  get_versionColumnName() {
        return versionColumnName;
    }

    /**
     * Sets the version column name.
     * @param _versionColumnName Name of version column.
     */
    protected static void set_versionColumnName(String  _versionColumnName) {
        CoreDataStruct.versionColumnName = _versionColumnName;
    }

    /**
     * @deprecated Use set_Version()
     * @param _version the object's version.
     */
    protected void setVersion(int _version) {
        set_Version(_version);
    }

    /**
     * Sets this object's version.
     * @param _version the object's version.
     */
    protected void set_Version(int _version) {
        version = _version;
    }

    /**
     * @deprecated Use get_Version()
     * @return this object's version.
     */
    protected int getVersion() {
        return get_Version();
    }

    /**
     * Returns this object's version.
     * @return this object's version.
     */
    protected int get_Version() {
        return version;
    }

    /**
     * @deprecated Use get_OId()
     * @return this object's identifier.
     */
    public ObjectId getOId() {
        return get_OId();
    }

    /**
     * Returns this object's identifier.
     * @return this object's identifier.
     */
    public ObjectId get_OId() {
        return oId;
    }

    /**
     * @deprecated Use set_OId()
     * @param oId this object's identifier.
     */
    protected void setOId(ObjectId oId) {
        set_OId(oId);
    }

    /**
     * Sets this object's identifier.
     * @param oId this object's identifier.
     */
    protected void set_OId(ObjectId oId) {
        this.oId = oId;
    }

    /**
     * Subclass should override this method if wants to use it.
     * This method checks if this DataStruct object satisfies condition cond.
     *
     * @param cond Condition of the query.
     * @return true if this DataStruct object satisfies condition of this query,
     * otherwise false.
     */
    public boolean compareCond(Condition cond) {
        return false;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Returns this object's handle (identifier as a string).
     * @return This object's identifier as a string.
     *
     * @exception DatabaseManagerException
     *   If a connection to the database cannot be established, etc.
     * @deprecated Use get_Handle() instead.          
     */
    public String  getHandle() throws DatabaseManagerException {
        return null;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Returns this object's handle (identifier as a string).
     * @return This object's identifier as a string.
     *
     * @exception DatabaseManagerException
     *   If a connection to the database cannot be established, etc.
     */
    public String  get_Handle() throws DatabaseManagerException {
        return null;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Returns this object's cache handle (String in the form:
     * "<database_name>.<indetifier_as_String>").
     *
     * @return cache handle.
     * @exception DatabaseManagerException
     *   If a connection to the database cannot be established, etc.
     */
    public String  get_CacheHandle() throws DatabaseManagerException {
        return null;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Returns the name of the logical database for which was this object
     * created.
     *
     * @return logical database name.
     */
    public String  get_Database() {
        return null;
    }
    
    /**
     * @return CoreDataStruct new empty instance
     */
    abstract public CoreDataStruct dumpData(boolean incrementVersion);
}
