
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: CloneableDO.java,v 1.1 2004/09/03 13:42:37 sinisa Exp $
 */
package com.lutris.appserver.server.sql;

import java.sql.ResultSet ;
import java.sql.SQLException ;
import org.enhydra.dods.DODS;

/**
 * Base class from which the data objects are created.
 * Provides functionality for cloning data objects.  The cloned
 * data object will have a unique object identifier.
 *
 * @version $Revision: 1.1 $
 * @since LBS1.8
 * @author Kyle Clark
 */
abstract public class CloneableDO extends CoreDO implements Cloneable  {

    /**
     * Public constructor.
     */
    public CloneableDO() {
        super();
    }
    
    /**
     * Public constructor.
     * @param rs a result set.
     * @exception SQLException if an error occurs while instantiating this
     * object from the result set.
     * @exception ObjectIdException if the object id for this object is
     * invalid.
     */
    public CloneableDO(ResultSet  rs) throws SQLException , ObjectIdException {
        super(rs);
    }

    /**
     * Creates a clone of the object, but ensures that
     * a new and unique object id is created for the object
     * and that the version number is set to zero.
     * @exception DatabaseManagerException if an error occurs while
     * allocation a new object id from the default logical database.
     * @exception ObjectIdException if a new object id could not be
     * allocated.
     */
    public synchronized Object  cloneUnique()
        throws DatabaseManagerException, ObjectIdException {
        CloneableDO dataObj = (CloneableDO) clone();

        dataObj.set_OId(DODS.getDatabaseManager().allocateObjectId());
        dataObj.set_Version(0);
        dataObj.setPersistent(false);
        return dataObj;
    }

    /**
     * Will clone the existing object keeping a fields
     * the same, including the object id.
     */
    protected Object  clone() {
        Object  obj = this;

        try {
            obj = super.clone();
        } catch (CloneNotSupportedException  ex) {// Should not happen
        }
        return obj;
    }
}
