/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.enhydra.dods.util.SequencedHashMap;

public class LRUMap
extends SequencedHashMap
implements Externalizable {
    private int maximumSize = 0;

    public LRUMap() {
    }

    public LRUMap(int maxSize) {
        this();
        this.maximumSize = maxSize;
    }

    public LRUMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public LRUMap(int initialCapacity, float loadFactor, int maxSize) {
        this(initialCapacity, loadFactor);
        this.maximumSize = maxSize;
    }

    public LRUMap(Map m) {
        this.maximumSize = m.size() + 1;
        this.putAll(m);
    }

    public LRUMap(Map m, int maxSize) {
        this(m);
        if (maxSize < 0 || maxSize > m.size() + 1) {
            this.maximumSize = maxSize;
        }
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.maximumSize == 0) {
            return false;
        }
        return super.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        if (this.maximumSize == 0) {
            return null;
        }
        if (!this.containsKey(key)) {
            return null;
        }
        Object value = this.remove(key);
        super.put(key, value);
        return value;
    }

    @Override
    public Object put(Object key, Object value) {
        if (this.maximumSize == 0) {
            return null;
        }
        int mapSize = this.size();
        Object retval = null;
        if (this.maximumSize > 0 && mapSize >= this.maximumSize && !this.containsKey(key)) {
            this.removeLRU();
        }
        retval = super.put(key, value);
        return retval;
    }

    @Override
    public void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    protected void removeLRU() {
        Object key = this.getFirstKey();
        Object value = super.get(key);
        this.remove(key);
        this.processRemovedLRU(key, value);
    }

    protected void processRemovedLRU(Object key, Object value) {
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.maximumSize = in.readInt();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.put(key, value);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.maximumSize);
        out.writeInt(this.size());
        for (Object key : this.keySet()) {
            out.writeObject(key);
            Object value = super.get(key);
            out.writeObject(value);
        }
    }

    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maxSize) {
        this.maximumSize = maxSize;
        if (maxSize >= 0) {
            while (this.size() > this.maximumSize) {
                this.removeLRU();
            }
        }
    }
}

