/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.cache;

import com.lutris.appserver.server.sql.StandardDatabaseManager;
import com.lutris.appserver.server.sql.standard.DatabaseConfiguration;
import com.lutris.appserver.server.sql.standard.DriverSpecificConstants;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.dods.builder.generator.query.QueryBuilder;
import com.lutris.util.Config;
import org.enhydra.dods.CommonConstants;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.CacheConstants;
import org.enhydra.dods.cache.Wrapper;
import org.enhydra.dods.exceptions.AssertionDataObjectException;

public class TableConfiguration
implements CacheConstants,
DriverSpecificConstants {
    private boolean readOnly = ((StandardDatabaseManager)DODS.getDatabaseManager()).getAllReadOnly();
    private boolean caseSensitive = false;
    private boolean originalAllReadOnly = ((StandardDatabaseManager)DODS.getDatabaseManager()).getAllReadOnly();
    private boolean lazyLoading = false;
    private int maxExecuteTime = 0;
    private int defaultFetchSize = -1;
    private int queryTimeout = 0;
    private int fullCacheCountLimit = -1;
    private String initCachesResultSetType = null;
    private String initCachesResultSetConcurrency = null;
    private Integer queryTimeLimit = CommonConstants.DEFAULT_QUERY_TIME_LIMIT;
    private boolean selectOids = false;
    private boolean incrementVersions = true;

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setReadOnly(boolean newReadOnly) throws AssertionDataObjectException {
        if (!newReadOnly) {
            if (this.originalAllReadOnly) {
                throw new AssertionDataObjectException("Can't set read-only table to false: all tables are read-only");
            }
            Wrapper.getInstance().removeAllComplexQueries();
        }
        this.readOnly = newReadOnly;
    }

    public int getInitCachesResultSetType() {
        String tmpUCrN = this.initCachesResultSetType;
        try {
            if (tmpUCrN == null) {
                return 1003;
            }
            if (tmpUCrN.equalsIgnoreCase("TYPE_SCROLL_SENSITIVE")) {
                return 1005;
            }
            if (tmpUCrN.equalsIgnoreCase("TYPE_SCROLL_INSENSITIVE")) {
                return 1004;
            }
            if (tmpUCrN.equalsIgnoreCase("TYPE_FORWARD_ONLY")) {
                return 1003;
            }
            DODS.getLogChannel().write(7, "Invalid value for InitCachesResultSetType parameter :" + tmpUCrN);
            return 1003;
        }
        catch (Exception ex) {
            DODS.getLogChannel().write(7, "Use default value for InitCachesResultSetType parameter ");
            return 1003;
        }
    }

    public int getInitCachesResultSetConcurrency() {
        String tmpUCrN = this.initCachesResultSetConcurrency;
        try {
            if (tmpUCrN == null) {
                return 1007;
            }
            if (tmpUCrN.equalsIgnoreCase("CONCUR_READ_ONLY")) {
                return 1007;
            }
            if (tmpUCrN.equalsIgnoreCase("CONCUR_UPDATABLE")) {
                return 1008;
            }
            DODS.getLogChannel().write(7, "Invalid value for InitCachesResultSetConcurrency parameter :" + tmpUCrN);
            return 1007;
        }
        catch (Exception ex) {
            DODS.getLogChannel().write(7, "Use default value for InitCachesResultSetConcurrency parameter ");
            return 1007;
        }
    }

    public void setInitCachesResultSetConcurrency(String string) {
        this.initCachesResultSetConcurrency = string;
    }

    public void setInitCachesResultSetType(String string) {
        this.initCachesResultSetType = string;
    }

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    protected void setLazyLoading(boolean newlazyLoading) {
        this.lazyLoading = newlazyLoading;
    }

    public int getMaxExecuteTime() {
        return this.maxExecuteTime;
    }

    protected void setMaxExecuteTime(int newMaxExecuteTime) {
        this.maxExecuteTime = newMaxExecuteTime;
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    private void setDefaultFetchSize(int newValue) {
        this.defaultFetchSize = newValue;
        QueryBuilder.setDefaultFetchSize(this.defaultFetchSize);
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    private void setQueryTimeout(int newValue) {
        this.queryTimeout = newValue;
        QueryBuilder.setDefaultQueryTimeout(this.queryTimeout);
    }

    public boolean getSelectOids() {
        return this.selectOids;
    }

    private void setSelectOids(boolean newValue) {
        this.selectOids = newValue;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean newValue) {
        this.caseSensitive = newValue;
    }

    public boolean getIncrementVersions() {
        return this.incrementVersions;
    }

    private void setIncrementVersions(boolean newValue) {
        this.incrementVersions = newValue;
    }

    public int getFullCacheCountLimit() {
        return this.fullCacheCountLimit;
    }

    public void setFullCacheCountLimit(int i) {
        this.fullCacheCountLimit = i;
    }

    public Integer getQueryTimeLimit() {
        return this.queryTimeLimit;
    }

    public void setQueryTimeLimit(Integer queryTimeLimit) {
        this.queryTimeLimit = queryTimeLimit;
    }

    public void readTableConfiguration(Config tableConfig, String dbName) {
        DatabaseConfiguration defaultDatabaseConfig = null;
        try {
            defaultDatabaseConfig = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(dbName)).getDatabaseConfiguration();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultDatabaseConfig != null) {
            try {
                this.originalAllReadOnly = this.readOnly = defaultDatabaseConfig.isAllReadOnly();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.lazyLoading = defaultDatabaseConfig.isLazyLoading();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.caseSensitive = defaultDatabaseConfig.getCaseSensitive();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxExecuteTime = defaultDatabaseConfig.getMaxExecuteTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.defaultFetchSize = defaultDatabaseConfig.getDefaultFetchSize();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.queryTimeout = defaultDatabaseConfig.getQueryTimeout();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.selectOids = defaultDatabaseConfig.getSelectOids();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.incrementVersions = defaultDatabaseConfig.getIncrementVersions();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fullCacheCountLimit = defaultDatabaseConfig.getFullCacheCountLimit();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initCachesResultSetType = defaultDatabaseConfig.getInitCachesResultSetType();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initCachesResultSetConcurrency = defaultDatabaseConfig.getInitCachesResultSetConcurrency();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.queryTimeLimit = defaultDatabaseConfig.getQueryTimeLimit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tableConfig != null) {
            try {
                if (!this.readOnly) {
                    this.readOnly = tableConfig.getBoolean("readOnly");
                } else if (!tableConfig.getBoolean("readOnly")) {
                    DODS.getLogChannel().write(4, "Single table has readOnly=false property in config file, but AllReadOnly=true ");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.lazyLoading = tableConfig.getBoolean("lazyLoading");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxExecuteTime = tableConfig.getInt("maxExecuteTime");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.defaultFetchSize = tableConfig.getInt("DefaultFetchSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.queryTimeout = tableConfig.getInt("QueryTimeout");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.selectOids = tableConfig.getBoolean("SelectOids");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.incrementVersions = tableConfig.getBoolean("IncrementVersions");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.caseSensitive = tableConfig.getBoolean("CaseSensitive");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fullCacheCountLimit = tableConfig.getInt("FullCacheCountLimit");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initCachesResultSetType = tableConfig.getString("InitCachesResultSetType");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initCachesResultSetConcurrency = tableConfig.getString("InitCachesResultSetConcurrency");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.queryTimeLimit = new Integer(tableConfig.getInt("QueryTimeLimit"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setQueryTimeout(this.queryTimeout);
        this.setDefaultFetchSize(this.defaultFetchSize);
    }
}

