/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.dods.builder.generator.query;

import com.lutris.dods.builder.generator.query.ColumnNullException;
import com.lutris.dods.builder.generator.query.ColumnTypeException;
import com.lutris.dods.builder.generator.query.RDBColumn;
import java.math.BigDecimal;

public class RDBColumnValue
extends RDBColumn {
    private Object value;

    public RDBColumnValue(RDBColumn column, Object val) {
        super(column.table, column.name);
        this.value = val;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object o) {
        this.value = o;
    }

    public String getString() throws ColumnTypeException {
        if (!(this.value instanceof String)) {
            throw new ColumnTypeException(this, "String");
        }
        return (String)this.value;
    }

    public int getInteger(boolean nullOk) throws ColumnTypeException, ColumnNullException {
        if (!(this.value instanceof Integer)) {
            throw new ColumnTypeException(this, "Integer");
        }
        if (null == this.value) {
            if (!nullOk) {
                throw new ColumnNullException(this);
            }
            return 0;
        }
        return (Integer)this.value;
    }

    public Integer getInteger() throws ColumnTypeException {
        if (!(this.value instanceof Integer)) {
            throw new ColumnTypeException(this, "Integer");
        }
        return (Integer)this.value;
    }

    public double getDouble(boolean nullOk) throws ColumnTypeException, ColumnNullException {
        if (null == this.value) {
            if (!nullOk) {
                throw new ColumnNullException(this);
            }
            return 0.0;
        }
        Double d = this.getDouble();
        return d;
    }

    public Double getDouble() throws ColumnTypeException {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)this.value;
            return new Double(b.toString());
        }
        throw new ColumnTypeException(this, "Double/BigDecimal");
    }

    public BigDecimal getBigDecimal() throws ColumnTypeException {
        if (this.value instanceof Long) {
            return new BigDecimal(this.value.toString());
        }
        if (!(this.value instanceof BigDecimal)) {
            throw new ColumnTypeException(this, "BigDecimal");
        }
        return (BigDecimal)this.value;
    }
}

