/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.dods.builder.generator.dataobject;

import com.lutris.appserver.server.sql.CloneableDO;
import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBRowUpdateException;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.dods.builder.generator.query.DataObjectException;
import com.lutris.dods.builder.generator.query.QueryException;
import com.lutris.dods.builder.generator.query.RefAssertionException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.Condition;

public abstract class GenericDO
extends CloneableDO {
    protected boolean dirty = false;
    private boolean notUsingOId = false;
    private static Boolean setNullAsVarchar = null;
    private static Boolean setBytesAsLongvarbinary = null;
    private static Boolean setBytesAsBinaryStream = null;
    private static Boolean setBooleanAsString = null;
    protected boolean colChanged = false;
    private boolean executePartially;

    public static void printMsg(int level, String s) {
        try {
            DODS.getLogChannel().write(level, s);
        }
        catch (Exception e) {
            System.out.println(level + " " + s);
        }
    }

    private static boolean isSetNullAsVarchar() {
        if (setNullAsVarchar == null) {
            setNullAsVarchar = new Boolean(false);
            try {
                String setNullAsVarcharStr = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(DODS.getDatabaseManager().getDefaultDB())).getDriverProperty("SetNullAsVarchar");
                if (setNullAsVarcharStr != null) {
                    if (setNullAsVarcharStr.equalsIgnoreCase("true")) {
                        setNullAsVarchar = new Boolean(true);
                    } else if (setNullAsVarcharStr.equalsIgnoreCase("false")) {
                        setNullAsVarchar = new Boolean(false);
                    } else {
                        DODS.getLogChannel().write(7, "Illegal value for SetNullAsVarchar parameter. Using default");
                    }
                }
            }
            catch (DatabaseManagerException e) {
                DODS.getLogChannel().write(7, " Unable to read configuration for SetNullAsVarchar. Using default. ");
            }
        }
        return setNullAsVarchar;
    }

    private static boolean isSetBooleanAsString() {
        if (setBooleanAsString == null) {
            setBooleanAsString = new Boolean("true");
            try {
                String setBooleanAsStringStr = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(DODS.getDatabaseManager().getDefaultDB())).getDriverProperty("SetBooleanAsString");
                if (setBooleanAsStringStr != null) {
                    if (setBooleanAsStringStr.equalsIgnoreCase("true")) {
                        setBooleanAsString = new Boolean(true);
                    } else if (setBooleanAsStringStr.equalsIgnoreCase("false")) {
                        setBooleanAsString = new Boolean(false);
                    } else {
                        DODS.getLogChannel().write(7, "Illegal value for SetBooleanAsString parameter. Using default ('true').");
                    }
                }
            }
            catch (DatabaseManagerException e) {
                DODS.getLogChannel().write(7, " Unable to read configuration for SetBooleanAsString. Using default ('true'). ");
            }
        }
        return setBooleanAsString;
    }

    private static boolean isSetBytesAsBinaryStream() {
        if (setBytesAsBinaryStream == null) {
            setBytesAsBinaryStream = new Boolean("false");
            try {
                String setBytesAsBinaryStreamStr = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(DODS.getDatabaseManager().getDefaultDB())).getDriverProperty("SetBytesAsBinaryStream");
                if (setBytesAsBinaryStreamStr != null) {
                    if (setBytesAsBinaryStreamStr.equalsIgnoreCase("true")) {
                        setBytesAsBinaryStream = new Boolean(true);
                    } else if (setBytesAsBinaryStreamStr.equalsIgnoreCase("false")) {
                        setBytesAsBinaryStream = new Boolean(false);
                    } else {
                        DODS.getLogChannel().write(7, "Illegal value for SetBytesAsBinaryStream parameter. Using default");
                    }
                }
            }
            catch (DatabaseManagerException e) {
                DODS.getLogChannel().write(7, " Unable to read configuration for SetBytesAsBinaryStream. Using default. ");
            }
        }
        return setBytesAsBinaryStream;
    }

    private static boolean isSetBytesAsLongvarbinary() {
        if (setBytesAsLongvarbinary == null) {
            setBytesAsLongvarbinary = new Boolean(false);
            try {
                String setBytesAsLongvarbinaryStr = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(DODS.getDatabaseManager().getDefaultDB())).getDriverProperty("SetBytesAsLongvarbinary");
                if (setBytesAsLongvarbinaryStr != null) {
                    if (setBytesAsLongvarbinaryStr.equalsIgnoreCase("true")) {
                        setBytesAsLongvarbinary = new Boolean(true);
                    } else if (setBytesAsLongvarbinaryStr.equalsIgnoreCase("false")) {
                        setBytesAsLongvarbinary = new Boolean(false);
                    } else {
                        DODS.getLogChannel().write(7, "Illegal value for SetBytesAsLongvarchar parameter. Using default");
                    }
                }
            }
            catch (DatabaseManagerException e) {
                DODS.getLogChannel().write(7, " Unable to read configuration for SetBytesAsLongvarchar. Using default. ");
            }
        }
        return setBytesAsLongvarbinary;
    }

    public GenericDO() throws ObjectIdException, DatabaseManagerException {
        this.set_OId(DODS.getDatabaseManager().allocateObjectId());
        this.markNewValue();
    }

    public GenericDO(String dbName) throws ObjectIdException, DatabaseManagerException {
        this.set_OId(DODS.getDatabaseManager().allocateObjectId(dbName));
        this.markNewValue();
    }

    public GenericDO(boolean notUsingOId) throws ObjectIdException, DatabaseManagerException {
        this.notUsingOId = notUsingOId;
        if (!notUsingOId) {
            this.set_OId(DODS.getDatabaseManager().allocateObjectId());
        }
        this.markNewValue();
    }

    public GenericDO(String dbName, boolean notUsingOId) throws ObjectIdException, DatabaseManagerException {
        this.notUsingOId = notUsingOId;
        if (!notUsingOId) {
            this.set_OId(DODS.getDatabaseManager().allocateObjectId(dbName));
        }
        this.markNewValue();
    }

    public GenericDO(ObjectId id) throws ObjectIdException, DatabaseManagerException {
        this.set_OId(id);
    }

    public GenericDO(String dbName, ObjectId id) throws ObjectIdException, DatabaseManagerException {
        this.set_OId(id);
    }

    public GenericDO(ResultSet rs) throws SQLException, ObjectIdException, DatabaseManagerException {
        super(rs);
    }

    public GenericDO(String dbName, ResultSet rs) throws SQLException, ObjectIdException, DatabaseManagerException {
        super(rs);
    }

    @Override
    public synchronized Object cloneUnique() throws DatabaseManagerException, ObjectIdException {
        GenericDO dataObj = (GenericDO)super.cloneUnique();
        dataObj.set_Version(0);
        dataObj.markNewValue();
        return dataObj;
    }

    protected void makeIdentical(GenericDO obj) {
    }

    @Override
    public synchronized void executeUpdate(DBConnection conn) throws SQLException, DBRowUpdateException {
        if (this.dirty) {
            if (!this.notUsingOId) {
                GenericDO.printMsg(7, this.getClass().getName() + ".executeUpdate:" + this.persistent + ": " + this.getClass().getName() + ": " + this.get_OId().toString() + ": " + this.get_Version());
            }
            super.executeUpdate(conn);
        }
    }

    @Override
    public synchronized void executeInsert(DBConnection conn) throws SQLException, DBRowUpdateException {
        if (!this.notUsingOId) {
            GenericDO.printMsg(7, this.getClass().getName() + ".executeInsert():" + this.persistent + ": " + this.get_OId().toString() + ": " + this.get_Version() + ": " + this.get_NewVersion());
        }
        super.executeInsert(conn);
    }

    @Override
    public void executeDelete(DBConnection conn) throws SQLException {
        if (this.isPersistent()) {
            if (!this.notUsingOId) {
                GenericDO.printMsg(7, this.getClass().getName() + ".executeDelete(): " + this.persistent + ": " + this.get_OId().toString() + ": " + this.get_Version());
            }
            super.executeDelete(conn);
        }
    }

    @Override
    public void finalizeInsert(boolean success) {
        if (!this.notUsingOId) {
            GenericDO.printMsg(7, this.getClass().getName() + ".finalizeInsert(" + success + ") oid=" + this.get_OId().toString() + " version=" + this.get_Version());
        }
        boolean p = this.persistent;
        super.finalizeInsert(success);
        if (p) {
            this.persistent = true;
        }
        if (success) {
            this.dirty = false;
        }
    }

    @Override
    public void finalizeUpdate(boolean success) {
        if (!this.notUsingOId) {
            GenericDO.printMsg(7, this.getClass().getName() + ".finalizeUpdate:" + success + ": " + this.get_OId().toString() + ": " + this.get_Version());
        }
        super.finalizeUpdate(success);
        if (success) {
            this.dirty = false;
        }
    }

    protected static String get_primaryKeyName() {
        return CoreDO.get_OIdColumnName();
    }

    protected static String getPrimaryKeyName() {
        return GenericDO.get_primaryKeyName();
    }

    @Override
    protected void setOId(ObjectId oId) {
        this.set_OId(oId);
    }

    @Override
    protected void set_OId(ObjectId oId) {
        if (!this.notUsingOId) {
            super.set_OId(this.markNewValue(this.get_OId(), oId));
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    protected void markClean() {
        this.dirty = false;
    }

    protected void markNewValue() {
        this.dirty = true;
    }

    protected String markNewValue(String current_string, String new_string, int max_length, boolean nullOK) {
        return this.markNewValue(current_string, new_string, 0, max_length, nullOK);
    }

    protected String markNewValue(String current_string, String new_string, int min_length, int max_length, boolean nullOK) {
        this.colChanged = false;
        if (!nullOK && current_string == null) {
            current_string = "";
        }
        if (new_string == null) {
            if (!nullOK) {
                return current_string;
            }
            if (current_string != null) {
                this.dirty = true;
                this.colChanged = true;
            }
            return null;
        }
        if (min_length >= 0 && new_string.length() < min_length) {
            new_string = current_string;
        }
        if (max_length > 0 && new_string.length() > max_length) {
            new_string = new_string.substring(0, max_length);
        }
        if (!new_string.equals(current_string)) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_string;
    }

    protected ObjectId markNewValue(ObjectId current_OId, ObjectId new_OId) {
        this.colChanged = false;
        if (current_OId == null) {
            if (new_OId != null) {
                this.dirty = true;
                this.colChanged = true;
            }
        } else if (new_OId == null) {
            this.dirty = true;
            this.colChanged = true;
        } else if (!current_OId.toString().equals(new_OId.toString())) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_OId;
    }

    protected java.util.Date markNewValue(java.util.Date current_date, java.util.Date new_date) {
        this.colChanged = false;
        if (current_date == null) {
            if (new_date != null) {
                this.dirty = true;
                this.colChanged = true;
            }
        } else if (new_date == null) {
            this.dirty = true;
            this.colChanged = true;
        } else if (!current_date.toString().equals(new_date.toString())) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_date;
    }

    protected BigDecimal markNewValue(BigDecimal current_bd, BigDecimal new_bd) {
        this.colChanged = false;
        if (current_bd == null) {
            if (new_bd != null) {
                this.dirty = true;
                this.colChanged = true;
            }
        } else if (new_bd == null) {
            this.dirty = true;
            this.colChanged = true;
        } else if (!current_bd.equals(new_bd)) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_bd;
    }

    protected byte[] markNewValue(byte[] current_val, byte[] new_val) {
        block6: {
            block5: {
                this.colChanged = false;
                if (current_val != null) break block5;
                if (new_val == null) break block6;
                this.dirty = true;
                this.colChanged = true;
                break block6;
            }
            if (new_val == null) {
                this.dirty = true;
                this.colChanged = true;
            } else if (current_val.length != new_val.length) {
                this.dirty = true;
                this.colChanged = true;
            } else {
                for (int i = 0; i < current_val.length; ++i) {
                    if (current_val[i] == new_val[i]) continue;
                    this.dirty = true;
                    this.colChanged = true;
                    break;
                }
            }
        }
        return new_val;
    }

    protected Date markNewValue(Date current_val, Date new_val) {
        this.colChanged = false;
        if (current_val == null) {
            if (new_val != null) {
                this.dirty = true;
                this.colChanged = true;
            }
        } else if (new_val == null) {
            this.dirty = true;
            this.colChanged = true;
        } else if (!current_val.equals(new_val)) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_val;
    }

    protected Time markNewValue(Time current_val, Time new_val) {
        this.colChanged = false;
        if (current_val == null) {
            if (new_val != null) {
                this.dirty = true;
                this.colChanged = true;
            }
        } else if (new_val == null) {
            this.dirty = true;
            this.colChanged = true;
        } else if (!current_val.equals(new_val)) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_val;
    }

    protected Timestamp markNewValue(Timestamp current_val, Timestamp new_val) {
        this.colChanged = false;
        if (current_val == null) {
            if (new_val != null) {
                this.dirty = true;
                this.colChanged = true;
            }
        } else if (new_val == null) {
            this.dirty = true;
            this.colChanged = true;
        } else if (!current_val.equals(new_val)) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_val;
    }

    protected int markNewValue(int current_int, int new_int) {
        this.colChanged = false;
        if (current_int != new_int) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_int;
    }

    protected float markNewValue(float current_float, float new_float) {
        this.colChanged = false;
        if (current_float != new_float) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_float;
    }

    protected double markNewValue(double current_double, double new_double) {
        this.colChanged = false;
        if (current_double != new_double) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_double;
    }

    protected boolean markNewValue(boolean current_boolean, boolean new_boolean) {
        this.colChanged = false;
        if (current_boolean != new_boolean) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_boolean;
    }

    protected char markNewValue(char current_char, char new_char) {
        this.colChanged = false;
        if (current_char != new_char) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_char;
    }

    protected byte markNewValue(byte current_byte, byte new_byte) {
        this.colChanged = false;
        if (current_byte != new_byte) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_byte;
    }

    protected short markNewValue(short current_short, short new_short) {
        this.colChanged = false;
        if (current_short != new_short) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_short;
    }

    protected long markNewValue(long current_long, long new_long) {
        this.colChanged = false;
        if (current_long != new_long) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_long;
    }

    protected GenericDO markNewValue(GenericDO current_DO, GenericDO new_DO) {
        this.colChanged = false;
        if (current_DO != new_DO) {
            this.dirty = true;
            this.colChanged = true;
        }
        return new_DO;
    }

    protected void setPrepStmtParam_DO(PreparedStatement stmt, int[] paramIndex, GenericDO value) throws SQLException {
        if (null == value) {
            if (GenericDO.isSetNullAsVarchar()) {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 12);
            } else {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 3);
            }
        } else {
            ObjectId oid = value.get_OId();
            if (null == oid) {
                if (GenericDO.isSetNullAsVarchar()) {
                    int n = paramIndex[0];
                    paramIndex[0] = n + 1;
                    stmt.setNull(n, 12);
                } else {
                    int n = paramIndex[0];
                    paramIndex[0] = n + 1;
                    stmt.setNull(n, 3);
                }
            } else {
                this.setPrepStmtParam_BigDecimal(stmt, paramIndex, oid.toBigDecimal());
            }
        }
    }

    protected static boolean isNewDataDifferent_DO(GenericDO oldData, GenericDO newData) {
        return null == oldData ? null != newData : (null == newData ? true : GenericDO.isNewDataDifferent_BigDecimal(oldData.get_OId().toBigDecimal(), newData.get_OId().toBigDecimal()));
    }

    protected void setPrepStmtParam_String(PreparedStatement stmt, int[] paramIndex, String value) throws SQLException {
        if (null == value) {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setNull(n, 12);
        } else {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setString(n, value);
        }
    }

    protected static boolean isNewDataDifferent_String(String oldData, String newData) {
        return null == oldData ? null != newData : !oldData.equals(newData);
    }

    protected void setPrepStmtParam_float(PreparedStatement stmt, int[] paramIndex, float value) throws SQLException {
        int n = paramIndex[0];
        paramIndex[0] = n + 1;
        stmt.setFloat(n, value);
    }

    protected static boolean isNewDataDifferent_float(float oldData, float newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_int(PreparedStatement stmt, int[] paramIndex, int value) throws SQLException {
        int n = paramIndex[0];
        paramIndex[0] = n + 1;
        stmt.setInt(n, value);
    }

    protected static boolean isNewDataDifferent_int(int oldData, int newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_java_math_BigDecimal(PreparedStatement stmt, int[] paramIndex, BigDecimal value) throws SQLException {
        if (null == value) {
            if (GenericDO.isSetNullAsVarchar()) {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 12);
            } else {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 3);
            }
        } else {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setBigDecimal(n, value);
        }
    }

    protected static boolean isNewDataDifferent_java_math_BigDecimal(BigDecimal oldData, BigDecimal newData) {
        return null == oldData ? null != newData : (null == newData ? true : !oldData.equals(newData));
    }

    protected void setPrepStmtParam_BigDecimal(PreparedStatement stmt, int[] paramIndex, BigDecimal value) throws SQLException {
        if (null == value) {
            if (GenericDO.isSetNullAsVarchar()) {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 12);
            } else {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 3);
            }
        } else {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setBigDecimal(n, value);
        }
    }

    protected static boolean isNewDataDifferent_BigDecimal(BigDecimal oldData, BigDecimal newData) {
        return GenericDO.isNewDataDifferent_java_math_BigDecimal(oldData, newData);
    }

    protected void setPrepStmtParam_java_sql_Date(PreparedStatement stmt, int[] paramIndex, Date value) throws SQLException {
        if (null == value) {
            if (GenericDO.isSetNullAsVarchar()) {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 12);
            } else {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 91);
            }
        } else {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setDate(n, value);
        }
    }

    protected static boolean isNewDataDifferent_java_sql_Date(Date oldData, Date newData) {
        return null == oldData ? null != newData : !oldData.equals(newData);
    }

    protected void setPrepStmtParam_java_sql_Time(PreparedStatement stmt, int[] paramIndex, Time value) throws SQLException {
        if (null == value) {
            if (GenericDO.isSetNullAsVarchar()) {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 12);
            } else {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 92);
            }
        } else {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setTime(n, value);
        }
    }

    protected static boolean isNewDataDifferent_java_sql_Time(Time oldData, Time newData) {
        return null == oldData ? null != newData : !oldData.equals(newData);
    }

    protected void setPrepStmtParam_java_sql_Timestamp(PreparedStatement stmt, int[] paramIndex, Timestamp value) throws SQLException {
        if (null == value) {
            if (GenericDO.isSetNullAsVarchar()) {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 12);
            } else {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 93);
            }
        } else {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setTimestamp(n, value);
        }
    }

    protected static boolean isNewDataDifferent_java_sql_Timestamp(Timestamp oldData, Timestamp newData) {
        return null == oldData ? null != newData : !oldData.equals(newData);
    }

    protected void setPrepStmtParam_bytes(PreparedStatement stmt, int[] paramIndex, byte[] value) throws SQLException {
        if (null == value) {
            if (GenericDO.isSetNullAsVarchar()) {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, 12);
            } else {
                int n = paramIndex[0];
                paramIndex[0] = n + 1;
                stmt.setNull(n, -3);
            }
        } else if (GenericDO.isSetBytesAsBinaryStream()) {
            ByteArrayInputStream newBAIS = new ByteArrayInputStream(value);
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setBinaryStream(n, (InputStream)newBAIS, value.length);
            try {
                newBAIS.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (GenericDO.isSetBytesAsLongvarbinary()) {
            String psValue = new String(value);
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setObject(n, (Object)psValue, -4);
        } else {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setBytes(n, value);
        }
    }

    protected static boolean isNewDataDifferent_bytes(byte[] oldData, byte[] newData) {
        if (null == oldData) {
            return null != newData;
        }
        if (oldData.length == newData.length) {
            for (int i = 0; i < oldData.length; ++i) {
                if (oldData[i] == newData[i]) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void setPrepStmtParam_double(PreparedStatement stmt, int[] paramIndex, double value) throws SQLException {
        int n = paramIndex[0];
        paramIndex[0] = n + 1;
        stmt.setDouble(n, value);
    }

    protected static boolean isNewDataDifferent_double(double oldData, double newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_long(PreparedStatement stmt, int[] paramIndex, long value) throws SQLException {
        int n = paramIndex[0];
        paramIndex[0] = n + 1;
        stmt.setLong(n, value);
    }

    protected static boolean isNewDataDifferent_long(long oldData, long newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_short(PreparedStatement stmt, int[] paramIndex, short value) throws SQLException {
        int n = paramIndex[0];
        paramIndex[0] = n + 1;
        stmt.setShort(n, value);
    }

    protected static boolean isNewDataDifferent_short(short oldData, short newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_byte(PreparedStatement stmt, int[] paramIndex, byte value) throws SQLException {
        int n = paramIndex[0];
        paramIndex[0] = n + 1;
        stmt.setByte(n, value);
    }

    protected static boolean isNewDataDifferent_byte(byte oldData, byte newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_boolean(PreparedStatement stmt, int[] paramIndex, boolean value) throws SQLException {
        if (GenericDO.isSetBooleanAsString()) {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setString(n, value ? "1" : "0");
        } else {
            int n = paramIndex[0];
            paramIndex[0] = n + 1;
            stmt.setBoolean(n, value);
        }
    }

    protected static boolean isNewDataDifferent_boolean(boolean oldData, boolean newData) {
        return oldData != newData;
    }

    public String toString(int x) {
        return super.toString();
    }

    public void delete() throws SQLException, DatabaseManagerException, DataObjectException, RefAssertionException, DBRowUpdateException, QueryException {
    }

    public static byte[] copyByteArray(byte[] source) {
        if (null == source) {
            return null;
        }
        byte[] dest = new byte[source.length];
        System.arraycopy(source, 0, dest, 0, source.length);
        return dest;
    }

    public static String copyString(String source) {
        if (null == source) {
            return null;
        }
        return source + "";
    }

    public static BigDecimal copyBigDecimal(BigDecimal source) {
        if (null == source) {
            return null;
        }
        return new BigDecimal(source.toString());
    }

    public static Date copyDate(Date source) {
        if (null == source) {
            return null;
        }
        return new Date(source.getTime());
    }

    public static Time copyTime(Time source) {
        if (null == source) {
            return null;
        }
        return new Time(source.getTime());
    }

    public static Timestamp copyTimestamp(Timestamp source) {
        if (null == source) {
            return null;
        }
        return new Timestamp(source.getTime());
    }

    public boolean compareCond(Condition cond) {
        return false;
    }

    public void setData(Object data) {
    }

    public void set_Data(Object data) {
    }

    public void originalData_set(Object data) {
    }

    public Object getData() {
        return this.getData();
    }

    public Object get_Data() {
        return null;
    }

    public String get_Handle() throws DatabaseManagerException {
        return null;
    }

    public String getHandle() throws DatabaseManagerException {
        return null;
    }

    public String get_CacheHandle() throws DatabaseManagerException {
        return null;
    }

    public GenericDO createDO(GenericDO obj) {
        return null;
    }

    public static GenericDO createDO(ObjectId oid) throws SQLException, ObjectIdException, DataObjectException, DatabaseManagerException {
        return null;
    }

    public String getOriginDatabase() {
        return null;
    }

    public String get_OriginDatabase() {
        return null;
    }

    public void setExecutePartially(boolean _ep) {
        this.executePartially = _ep;
    }

    public boolean isExecutePartially() {
        return this.executePartially;
    }
}

