
/**
 * Title:        WebDocWf AccessEvalException<p>
 * Description:  AccessEvalException is thrown if an error accurs during evaluation of rights<p>
 * Copyright:    Copyright (c) Together Teamlösungen EDV-Dienstleistungen GmbH. under LGPL<p>
 * Company:      Together Teamlösungen EDV-Dienstleistungen GmbH.<p>
 * @author Alfred Madl (a.madl@together.at)
 * @version 1.0
 */
package org.webdocwf.dods.access;

import java.io.PrintStream ;
import java.io.PrintWriter ;

/**
 * Exception used as a base for creating an exception that has a chain of
 * exceptions that lead to the derived exception.  Very useful for interfaces
 * where the implementation exception is not known.
 */
public class AccessEvalException extends AccessException {

    /**
     * Construct an exception without a specified cause.
     *
     * @param msg The message associated with the exception.
     */
    public AccessEvalException(String  msg) {
        super(msg);
    }

    /**
     * Construct an exception with an associated causing exception.
     *
     * @param msg The message associated with the exception.
     * @param cause The error or exception that cause this
     *  exception.
     */
    public AccessEvalException(String  msg,
            Throwable  cause) {
        super(msg, cause);
    }

    /**
     * Construct an exception from a causing exception.
     *
     * @param cause The error or exception that cause this
     *  exception. The message will be take be this object's
     *  messasge.
     */
    public AccessEvalException(Throwable  cause) {
        super(cause.getMessage(), cause);
    }

    /**
     * Construct an exception with a cause and detail data.
     *
     * @param cause The error or exception that cause this
     *  exception. The message will be take be this object's
     *  messasge.
     * @param inUsr The user for the access right check
     * @param inOperation The desired operation
     * @param inObj The accessed object
     * @param inClassName The accessed class
     * @param inAttrName The accessed attribute
     * @param inValue The accessed value
     * @param inOldValue The new value in set-operations
     * @param inDatatype The datatype of the value
     * @param inCmp_op The comparison operator for queries
     */
    public AccessEvalException(Throwable  cause, User inUsr, String  inOperation, SecureDO inObj, String  inClassName, String  inAttrName, String  inValue, String  inOldValue, String  inDatatype, String  inCmp_op) {
        super(cause.getMessage(), cause, inUsr, inOperation, inObj, inClassName,
                inAttrName, inValue, inOldValue, inDatatype, inCmp_op);
    }

    /**
     * Construct an exception with a message, a cause and detail data.
     *
     * @param msg The message associated with the exception.
     * @param cause The error or exception that cause this
     *  exception. The message will be take be this object's
     *  messasge.
     * @param inUsr The user for the access right check
     * @param inOperation The desired operation
     * @param inObj The accessed object
     * @param inClassName The accessed class
     * @param inAttrName The accessed attribute
     * @param inValue The accessed value
     * @param inOldValue The new value in set-operations
     * @param inDatatype The datatype of the value
     * @param inCmp_op The comparison operator for queries
     */
    public AccessEvalException(String  msg, Throwable  cause, User inUsr, String  inOperation, SecureDO inObj, String  inClassName, String  inAttrName, String  inValue, String  inOldValue, String  inDatatype, String  inCmp_op) {
        super(msg, cause, inUsr, inOperation, inObj, inClassName, inAttrName,
                inValue, inOldValue, inDatatype, inCmp_op);
    }

    /**
     * Construct an exception with a message and detail data.
     *
     * @param msg The message associated with the exception.
     * @param inUsr The user for the access right check
     * @param inOperation The desired operation
     * @param inObj The accessed object
     * @param inClassName The accessed class
     * @param inAttrName The accessed attribute
     * @param inValue The accessed value
     * @param inOldValue The new value in set-operations
     * @param inDatatype The datatype of the value
     * @param inCmp_op The comparison operator for queries
     */
    public AccessEvalException(String  msg, User inUsr, String  inOperation, SecureDO inObj, String  inClassName, String  inAttrName, String  inValue, String  inOldValue, String  inDatatype, String  inCmp_op) {
        super(msg, inUsr, inOperation, inObj, inClassName, inAttrName, inValue,
                inOldValue, inDatatype, inCmp_op);
    }

    /**
     * Prints this ChainedException and its backtrace, and the causes
     * and their stack traces to the standard error stream. 
     */
    public void printStackTrace() {
        super.printStackTrace();
    }

    /**
     * Prints this ChainedException and its backtrace, and the causes
     * and their stack traces to the e specified print stream. 
     */
    public void printStackTrace(PrintStream  s) {
        super.printStackTrace(s);
    }

    /**
     * Prints this ChainedException and its backtrace, and the causes
     * and their stack traces to the e specified print writer. 
     */
    public void printStackTrace(PrintWriter  s) {
        super.printStackTrace(s);
    }
}
