
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 */
package org.enhydra.dods.cache;

/**
 * This intefrace contains constants needed for data object (or DataStruct
 * object), simple query and complex query caches.
 *
 * @author    Nenad Vico
 * @author    Zorica Suvajdzin
 * @author    Tanja Jovanovic
 * @version   2.0  15.06.2003.
 *
 */
public interface CacheConstants {
// 26.08.2004 tj added multi-join query cache
 /**
     * Methods use this constant for retrieving information about data object or
     * DataStruct object cache.
     */
    public static final int DATA_CACHE = 0;

    /**
     * Methods use this constant for retrieving information about simple query
     * cache.
     */
    public static final int SIMPLE_QUERY_CACHE = 1;

    /**
     * Methods use this constant for retrieving information about complex query
     * cache.
     */
    public static final int COMPLEX_QUERY_CACHE = 2;
    
    /**
     * Methods use this constant for retrieving information about multi-join 
     * query cache.
     */
    public static final int MULTI_JOIN_QUERY_CACHE = 3;

    /**
     * Only data object (or DataStruct object) cache is enabled. Simple and
     * complex query caches are disabled.
     */
    public static final int DATA_CACHING = 1;

    /**
     * Beside data object (or DataStruct object) cache, which is enabled,
     * at least one of simple and complex query caches is enabled.
     */
    public static final int QUERY_CACHING = 2;

    /**
     * Constant for maximal number of data objects (or DataStruct object) in
     * the cache.
     * Used if application's configuration file doesn't contain information
     * about maximal cache size.
     */
    public static final int DEFAULT_MAX_CACHE_SIZE = 0;

    /**
     * Constant for maximal number of Query objects in the simple query cache.
     * Used if application's configuration file doesn't contain information
     * about maximal simple query cache size.
     */
    public final int DEFAULT_MAX_SIMPLE_QUERY_CACHE_SIZE = 0;

    /**
     * Constant for maximal number of Query objects in the complex query cache.
     * Used if application's configuration file doesn't contain information
     * about maximal complex query cache size.
     */
    public final int DEFAULT_MAX_COMPLEX_QUERY_CACHE_SIZE = 0;
    
    /**
     * Constant for maximal number of Query objects in the multi-join query 
     * cache. Used if application's configuration file doesn't contain 
     * information about maximal multi-join query cache size.
     */
    public final int DEFAULT_MAX_MULTI_JOIN_QUERY_CACHE_SIZE = 0;

    /**
     * Constant used in query caching. If is percent of how many more object are
     * taken for evaluation. If <CODE>num</CODE> is number of needed results, then
     * it is used <code>num</code> + DEFAULT_RESERVE_FACTOR * <code>num</code> of
     * objects for estimating what is quicker: go to database for all object that
     * are not in the cache, or run again query on database.
     * This value is given in percents, as number between 0 and 1
     * (0.25 means 25%).
     * For example, if DEFAULT_RESERVE_FACTOR is 0.0, and wanted number of
     * results is 50, the estimation will be done on 75 (50 + 0.5 * 50) objects.
     */
    public final double DEFAULT_RESERVE_FACTOR = 0;
    
    public final boolean DEFAULT_TRANSACTION_CHECK = false;
    
    public final boolean DEFAULT_DELETE_CHECK_VERSION = false;
    
    public final boolean DEFAULT_AUTO_WRITE = false;
    
    public final boolean DEFAULT_TRANSACTION_CACHES = false;
    
    public final boolean DEFAULT_AUTO_SAVE = false;
    
    public final boolean DEFAULT_AUTO_SAVE_CREATE_VIRGIN = false;
    
    public final int DEFAULT_DEFAULT_FETCH_SIZE = -1;
    
    public final int DEFAULT_DEADLOCK_READ_TIME = 0;
    
    public final int DEFAULT_DEADLOCK_RETRY_NUMBER = 0;
    
    public final int DEFAULT_QUERY_TIMEOUT = 0;
    
    public final boolean DEFAULT_LAZY_LOADING = false;
    
    public final int DEFAULT_MAX_EXECUTE_TIME = 0;
    
    public final boolean DEFAULT_INITIAL_ALL_CACHES = false;
    
    public final String  DEFAULT_INITIAL_CONDITION = null; 
    
    public final boolean DEFAULT_All_READONLY = false; 
    
    public final boolean DEFAULT_READONLY = false; 
    
    public final double DEFAULT_CACHE_PERCENTAGE = -1.0;   
    
    public final boolean DEFAULT_CASE_SENSITIVE = false;
    
    public final String  DEFAULT_APP_NAME = null;
    
    public final int DEFAULT_INITIAL_CACHE_FETCH_SIZE = 0;
    
    public final int DEFAULT_INITIAL_DS_CACHE_SIZE = -1;
    
    /**
     * Optional select statement - used with mass Updates and/or deletes .
     */ 
    public final boolean DEFAULT_SELECT_OIDS = false;
    
    /**
     * Increment versions during mass Updates.
     */ 
    public final boolean DEFAULT_INCREMENT_VERSIONS = true;
    public final int  DEFAULT_FULL_CACHE_COUNT_LIMIT = -1;

    /**
     * Names of parameters in configuration file (DatabaseManager section)
     */ 
    public final String  PARAMNAME_TRANSACTION_CHECK = "TransactionCheck";
    
    public final String  PARAMNAME_DELETE_CHECK_VERSION = "DeleteCheckVersion";
    
    public final String  PARAMNAME_AUTO_WRITE = "AutoWrite";
    
    public final String  PARAMNAME_TRANSACTION_CACHES = "TransactionCaches";
    
    public final String  PARAMNAME_AUTO_SAVE = "AutoSave";
    
    public final String  PARAMNAME_AUTO_SAVE_CREATE_VIRGIN = "AutoSaveCreateVirgin";    
    
    public final String  PARAMNAME_DEFAULT_FETCH_SIZE = "DefaultFetchSize";
    
    public final String  PARAMNAME_DEADLOCK_READ_TIME = "CacheLockTimeout";
    
    public final String  PARAMNAME_DEADLOCK_RETRY_NUMBER = "CacheLockRetryCount";
    
    public final String  PARAMNAME_QUERY_TIMEOUT = "QueryTimeout";
    
    public final String  PARAMNAME_ALL_READ_ONLY = "AllReadOnly";
    
    public static final String  PARAMNAME_LAZY_LOADING = "lazyLoading";
    
    public final String  PARAMNAME_MAX_EXECUTE_TIME = "maxExecuteTime"; 
    
    public final String  PARAMNAME_MAX_CACHE_SIZE = "maxCacheSize"; 
    
    public final String  PARAMNAME_MAX_SIMPLE_CACHE_SIZE = "maxSimpleCacheSize"; 
    
    public final String  PARAMNAME_MAX_COMPLEX_CACHE_SIZE = "maxComplexCacheSize"; 
    
    public final String  PARAMNAME_MAX_MULTI_JOIN_CACHE_SIZE = "maxMultiJoinCacheSize"; 
    
    public final String  PARAMNAME_RESERVE_FACTOR = "reserveFactor";                 
    
    public final String  PARAMNAME_INITIAL_ALL_CACHES = "initAllCaches";        
    
    public final String  PARAMNAME_INITIAL_CONDITION = "initialCondition";                 
    
    public final String  PARAMNAME_READ_ONLY = "readOnly";
    
    public final String  PARAMNAME_CACHE_PERCENTAGE = "CachePercentage";    
    
    public final String  PARAMNAME_CASE_SENSITIVE = "CaseSensitive";
    
    public final String  PARAMNAME_APP_NAME = "AppName";
    
    public final String  PARAMNAME_INITIAL_CACHE_FETCH_SIZE = "InitialCacheFetchSize";
    
    public final String  PARAMNAME_INITIAL_DS_CACHE_SIZE = "InitialDSCacheSize";
    
    /**
     * Name of optional select statement parameter - used with mass Updates and/or deletes.
     */ 
    public final String  PARAMNAME_SELECT_OIDS = "SelectOids";    
    
    /**
     * Increment versions during mass Updates.
     */ 
    public final String  PARAMNAME_INCREMENT_VERSIONS = "IncrementVersions";    
    public final String  FULL_CACHE_COUNT_LIMIT = "FullCacheCountLimit";        

    
    public final String  PARAMNAME_DODS_CACHE_FACTORY="DODSCacheFactory";
    public final String  DEFAULT_DODS_CACHE_FACTORY="org.enhydra.dods.cache.lru.DODSLRUCacheFactory";
}

