/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.cache;

import com.lutris.appserver.server.sql.CoreDataStruct;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.dods.builder.generator.dataobject.GenericDO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.enhydra.dods.cache.Condition;
import org.enhydra.dods.cache.QueryCacheItem;

public class QueryCacheItemImpl
implements QueryCacheItem {
    protected String queryId;
    protected HashMap OIds;
    protected int resultNum = 0;
    protected boolean completeRes = false;
    protected ListItem head;
    protected ListItem tail;
    protected boolean modifiedQuery = false;
    protected int time;
    protected ArrayList conds;
    protected String originDatabase;

    public QueryCacheItemImpl(String origDb) {
        this.OIds = new HashMap();
        this.resultNum = 0;
        this.completeRes = false;
        this.modifiedQuery = false;
        this.time = 0;
        this.conds = new ArrayList();
        this.originDatabase = origDb;
    }

    public QueryCacheItemImpl(String qId, HashMap OIds, int time, ArrayList conditions, String origDb) {
        this.queryId = qId;
        this.OIds = OIds;
        this.resultNum = 0;
        this.completeRes = false;
        this.modifiedQuery = false;
        this.time = time;
        this.conds = conditions;
        this.originDatabase = origDb;
    }

    @Override
    public String getQueryId() {
        return this.queryId;
    }

    @Override
    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    @Override
    public Collection getOIds() {
        ArrayList<String> list = new ArrayList<String>();
        ListItem iter = this.head;
        while (iter != null) {
            list.add(iter.handle);
            iter = iter.next;
        }
        return list;
    }

    @Override
    public int getResultNum() {
        return this.resultNum;
    }

    @Override
    public boolean isCompleteResult() {
        return this.completeRes;
    }

    @Override
    public void setCompleteResult(boolean newCompleteRes) {
        this.completeRes = newCompleteRes;
    }

    @Override
    public boolean isModifiedQuery() {
        return this.modifiedQuery;
    }

    @Override
    public void setModifiedQuery(boolean mod) {
        this.modifiedQuery = mod;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int time) {
        this.time = time;
    }

    @Override
    public ArrayList getConds() {
        return this.conds;
    }

    @Override
    public void setConds(ArrayList conds) {
        this.conds = conds;
    }

    @Override
    public void addCond(Condition cond) {
        this.conds.add(cond);
    }

    @Override
    public String getOriginDatabase() {
        return this.get_OriginDatabase();
    }

    @Override
    public String get_OriginDatabase() {
        return this.originDatabase;
    }

    @Override
    public boolean checkConditions(GenericDO obj) {
        for (int i = 0; i < this.conds.size(); ++i) {
            if (obj.compareCond((Condition)this.conds.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean checkConditions(CoreDataStruct obj) {
        for (int i = 0; i < this.conds.size(); ++i) {
            if (obj.compareCond((Condition)this.conds.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void update(GenericDO obj) {
        if (obj.get_OriginDatabase().equals(this.originDatabase)) {
            try {
                String key = obj.get_Handle();
                if (this.checkConditions(obj)) {
                    ListItem tmp = null;
                    tmp = (ListItem)this.OIds.get(key);
                    if (tmp == null) {
                        this.addHandle(key);
                    }
                } else {
                    this.removeHandle(key);
                }
            }
            catch (DatabaseManagerException databaseManagerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void update(CoreDataStruct obj) {
        if (obj.get_Database().equals(this.originDatabase)) {
            try {
                String key = obj.get_Handle();
                if (this.checkConditions(obj)) {
                    ListItem tmp = null;
                    tmp = (ListItem)this.OIds.get(key);
                    if (tmp == null) {
                        this.addHandle(key);
                    }
                } else {
                    this.removeHandle(key);
                }
            }
            catch (DatabaseManagerException databaseManagerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void delete(GenericDO obj) {
        if (obj.get_OriginDatabase().equals(this.originDatabase)) {
            try {
                String key = null;
                key = obj.get_Handle();
                if (key != null) {
                    this.removeHandle(key);
                }
            }
            catch (DatabaseManagerException databaseManagerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void delete(CoreDataStruct obj) {
        if (obj.get_Database().equals(this.originDatabase)) {
            try {
                String key = null;
                key = obj.get_Handle();
                if (key != null) {
                    this.removeHandle(key);
                }
            }
            catch (DatabaseManagerException databaseManagerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void add(GenericDO obj) {
        if (obj.get_OriginDatabase().equals(this.originDatabase)) {
            try {
                String key = null;
                key = obj.get_Handle();
                if (key != null) {
                    this.addHandle(key);
                }
            }
            catch (DatabaseManagerException databaseManagerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void add(CoreDataStruct obj) {
        if (obj != null && obj.get_Database() != null && obj.get_Database().equals(this.originDatabase)) {
            try {
                String key = null;
                key = obj.get_Handle();
                if (key != null) {
                    this.addHandle(key);
                }
            }
            catch (DatabaseManagerException databaseManagerException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        Object DO = null;
        ret.append("\n QueryCacheItemImpl: ");
        ret.append("\n queryId: " + this.queryId);
        ret.append("\n OIds : " + this.OIds);
        if (this.OIds != null) {
            ListItem iter = this.head;
            while (iter != null) {
                ret.append(" " + iter.handle);
                iter = iter.next;
            }
        }
        ret.append("\n time : " + this.time);
        ret.append("\n conds : " + this.conds);
        ret.append("\n originDatabase : " + this.originDatabase);
        return ret.toString();
    }

    protected void addHandle(String handle) {
        ListItem item = new ListItem(handle);
        item.prev = this.tail;
        if (this.tail != null) {
            this.tail.next = item;
        }
        if (this.head == null) {
            this.head = item;
        }
        this.tail = item;
        ListItem value = (ListItem)this.OIds.get(handle);
        if (value == null) {
            this.OIds.put(handle, item);
        } else {
            item.sameNext = value;
            this.OIds.put(handle, item);
        }
        ++this.resultNum;
    }

    protected void removeHandle(String handle) {
        ListItem curr = (ListItem)this.OIds.get(handle);
        if (curr != null) {
            if (this.head == curr) {
                this.head = curr.next;
            }
            if (this.tail == curr) {
                this.tail = curr.prev;
            }
        }
        while (curr != null) {
            ListItem temp = curr;
            curr = curr.unlink().sameNext;
            temp.sameNext = null;
            --this.resultNum;
        }
    }

    static class ListItem {
        public String handle;
        public ListItem prev = null;
        public ListItem next = null;
        public ListItem sameNext = null;

        ListItem() {
        }

        ListItem(String hnd) {
            this.handle = hnd;
        }

        ListItem unlink() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            return this;
        }
    }
}

