/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.dods.builder.generator.query;

import com.lutris.appserver.server.sql.CoreDataStruct;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBQuery;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.ExtendedDBConnection;
import com.lutris.appserver.server.sql.ExtendedQuery;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.appserver.server.sql.Query;
import com.lutris.appserver.server.sql.StandardDatabaseManager;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.dods.builder.generator.dataobject.GenericDO;
import com.lutris.dods.builder.generator.query.QueryException;
import com.lutris.dods.builder.generator.query.RDBColumn;
import com.lutris.dods.builder.generator.query.RDBColumnValue;
import com.lutris.dods.builder.generator.query.RDBRow;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.enhydra.dods.Common;
import org.enhydra.dods.DODS;

public class QueryBuilder
implements ExtendedQuery {
    private static final String OR = " OR ";
    private static final String OPEN_PAREN = " ( ";
    private static final String CLOSE_PAREN = " ) ";
    public static final String EQUAL = "=";
    public static String NOT_EQUAL = "!=";
    public static final String LESS_THAN = "<";
    public static final String LESS_THAN_OR_EQUAL = "<=";
    public static final String GREATER_THAN = ">";
    public static final String GREATER_THAN_OR_EQUAL = ">=";
    public static final String IS_NULL = " IS NULL ";
    public static final String IS_NOT_NULL = " IS NOT NULL ";
    public static final String OPEN_IN = " IN ( ";
    public static final String OPEN_NOT_IN = " NOT IN ( ";
    public static final String OPEN_EXISTS = " EXISTS ( ";
    public static final String OPEN_NOT_EXISTS = " NOT EXISTS ( ";
    public static final String CLOSE_IN = " ) ";
    public static final String CASE_SENSITIVE_CONTAINS = "%X%";
    public static final String CASE_INSENSITIVE_CONTAINS = "%x%";
    public static final String CASE_SENSITIVE_STARTS_WITH = "X%";
    public static final String CASE_INSENSITIVE_STARTS_WITH = "x%";
    public static final String CASE_SENSITIVE_ENDS_WITH = "%X";
    public static final String CASE_INSENSITIVE_ENDS_WITH = "%x";
    public static final String CASE_INSENSITIVE_EQUAL = "%xxxx";
    public static final String CASE_SENSITIVE_MATCH = "X";
    public static final String CASE_INSENSITIVE_MATCH = "x";
    public static final String USER_CASE_SENSITIVE_MATCH = "U";
    public static final String USER_CASE_INSENSITIVE_MATCH = "u";
    public static final boolean NULL_OK = true;
    public static final boolean NOT_NULL = false;
    public static final boolean EXACT_MATCH = true;
    public static final boolean NOT_EXACT = false;
    public static final String DEFAULT_MATCHES_KEYWORD = "MATCHES";
    private String likeKeyword = "MATCHES";
    public static final String DEFAULT_WILDCARD = "*";
    private String wildcard = "*";
    public static final String DEFAULT_SINGLE_WILDCARD = "_";
    public static final String DEFAULT_SINGLE_WILDCARD_ESCAPE = "?";
    public static final String DEFAULT_WILDCARD_ESCAPE = "?";
    public static final String DEFAULT_WILDCARD_ESCAPE_CLAUSE = "ESCAPE '?'";
    public static final String DEFAULT_USER_WILDCARD = "*";
    public static final String DEFAULT_USER_SINGLE_WILDCARD = "?";
    public static final String DEFAULT_USER_SINGLE_WILDCARD_ESCAPE = "?";
    public static final String DEFAULT_USER_WILDCARD_ESCAPE = "?";
    public static final boolean DEFAULT_USER_APPEND_WILDCARD = false;
    public static final boolean DEFAULT_USER_TRIM_STRING = false;
    public String userConfigWildcard = "*";
    public String userConfigSingleWildcard = "?";
    public String userConfigSingleWildcardEscape = "?";
    public String userConfigWildcardEscape = "?";
    private static boolean debugAllSQL = false;
    private boolean debugSQL = false;
    private boolean multiTableJoin = false;
    private boolean unionTableJoin = false;
    private boolean preventPrimaryKeySelect = false;
    private int iCurrentFetchSize = -1;
    private static int iDefaultFetchSize = -1;
    private int iCurrentQueryTimeout = 0;
    private static int iDefaultQueryTimeout = 0;
    private String databaseName = null;
    private int DEFAULT_RS_TYPE = -100;
    private int DEFAULT_RS_CONCURRENCY;
    private int iResultSetConcurrency = this.DEFAULT_RS_CONCURRENCY = -100;
    private int iResultSetType = this.DEFAULT_RS_TYPE;
    private String customNotEqualSqlOperator = null;
    private boolean caseInsensitiveDatabase = false;
    private DBQuery dbQuery = null;
    private ResultSet rs = null;
    private Boolean rsClosed = null;
    private boolean done = false;
    private String distinct = "";
    private String sql = null;
    private int maxRows = -1;
    private String[] breakWords = new String[]{"(", ")", "FROM", "from", "WHERE", "where", "AND", "and", "OR", "or"};
    private String mainTableName;
    private Hashtable tableNames = new Hashtable();
    private Hashtable endClauses = new Hashtable();
    private Vector selectedFields = new Vector();
    private String selectClause = "";
    private Vector whereClauses = new Vector();
    private Vector orderFields = new Vector();
    private Vector orderDirections = new Vector();
    private PreparedStatement stmt;
    private Vector parms;
    private BitSet fuzzies;
    private int param = 0;
    private DBConnection conn = null;
    private Vector updateFields = new Vector();
    public static final int SELECT_QUERY = 0;
    public static final int UPDATE_QUERY = 1;
    public static final int DELETE_QUERY = 2;
    private int iQueryType = 0;
    private Vector doUnionAll = new Vector();
    private Vector unionQuerys = new Vector();
    private int updateFieldPos = 0;
    private String singleWildcard = "_";
    private String singleWildcardEscape = "?";
    private String wildcardEscape = "?";
    private String wildcardEscapeClause = "ESCAPE '?'";
    private String userWildcard = this.userConfigWildcard;
    private String userSingleWildcard = this.userConfigSingleWildcard;
    private String userSingleWildcardEscape = this.userConfigSingleWildcardEscape;
    private String userWildcardEscape = this.userConfigWildcardEscape;
    private boolean userAppendWildcard = false;
    private boolean userTrimString = false;
    private static final int op_EQUAL = 1;
    private static final int op_NOT_EQUAL = 2;
    private static final int op_LESS_THAN = 3;
    private static final int op_LESS_THAN_OR_EQUAL = 4;
    private static final int op_GREATER_THAN = 5;
    private static final int op_GREATER_THAN_OR_EQUAL = 6;
    private static final int op_IS_NULL = 7;
    private static final int op_IS_NOT_NULL = 8;
    private static final int op_CASE_SENSITIVE_CONTAINS = 9;
    private static final int op_CASE_INSENSITIVE_CONTAINS = 10;
    private static final int op_CASE_SENSITIVE_STARTS_WITH = 11;
    private static final int op_CASE_INSENSITIVE_STARTS_WITH = 12;
    private static final int op_CASE_SENSITIVE_ENDS_WITH = 13;
    private static final int op_CASE_INSENSITIVE_ENDS_WITH = 14;
    private static final int op_CASE_INSENSITIVE_EQUAL = 15;
    static Hashtable cmp_ops = new Hashtable();
    public static long countX;

    public QueryBuilder(Vector fields) {
        this.init();
        this.reset();
        if (null != fields) {
            this.selectedFields = (Vector)fields.clone();
        }
    }

    private void init() {
        try {
            String value = ((StandardDatabaseManager)DODS.getDatabaseManager()).getDatabaseManagerConfiguration().getUserConfigWildcard();
            if (value != null) {
                this.userConfigWildcard = value;
            }
            if ((value = ((StandardDatabaseManager)DODS.getDatabaseManager()).getDatabaseManagerConfiguration().getUserConfigSingleWildcard()) != null) {
                this.userConfigSingleWildcard = value;
            }
            if ((value = ((StandardDatabaseManager)DODS.getDatabaseManager()).getDatabaseManagerConfiguration().getUserConfigSingleWildcardEscape()) != null) {
                this.userConfigSingleWildcardEscape = value;
            }
        }
        catch (Exception value) {
            // empty catch block
        }
        this.initDefaultWildCards();
        try {
            this.caseInsensitiveDatabase = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(this.getDatabaseName())).getDatabaseConfiguration().isCaseInsensitiveDatabase();
        }
        catch (Exception e) {
            this.caseInsensitiveDatabase = false;
        }
        this.customNotEqualSqlOperator = null;
        try {
            String customNotEqualSqlOperatorStr = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(this.getDatabaseName())).getDriverProperty("CustomNotEqualSqlOperator");
            this.customNotEqualSqlOperator = customNotEqualSqlOperatorStr != null ? customNotEqualSqlOperatorStr : "!=";
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.customNotEqualSqlOperator != null) {
            NOT_EQUAL = this.customNotEqualSqlOperator;
        }
    }

    public QueryBuilder(RDBColumn[] fields) {
        this.init();
        this.reset();
        for (int i = 0; i < fields.length; ++i) {
            this.select(fields[i]);
        }
    }

    public QueryBuilder() {
        this.init();
        this.reset();
    }

    public void select(RDBColumn field) {
        if (null == field) {
            return;
        }
        for (int i = 0; i < this.selectedFields.size(); ++i) {
            if (!field.equals((RDBColumn)this.selectedFields.elementAt(i))) continue;
            return;
        }
        this.selectedFields.addElement(field);
    }

    public RDBRow[] getRows() throws QueryException {
        RDBRow row;
        Vector<RDBRow> v = new Vector<RDBRow>();
        while (null != (row = this.getNextRow())) {
            v.addElement(row);
        }
        Object[] ret = new RDBRow[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public RDBRow getNextRow() throws QueryException {
        if (this.done) {
            return null;
        }
        if (null == this.rs) {
            try {
                if (null == this.dbQuery) {
                    this.dbQuery = DODS.getDatabaseManager().createQuery();
                }
            }
            catch (Exception e) {
                throw new QueryException("SQL=[" + this.sql + "]: Unable to create query", (Throwable)e);
            }
            try {
                this.dbQuery.query((Query)this);
            }
            catch (Exception e) {
                throw new QueryException("SQL=[" + this.sql + "]: Unable to run query", (Throwable)e);
            }
            if (null == this.rs) {
                throw new QueryException("No ResultSet for Query.");
            }
        }
        try {
            if (!this.rs.next()) {
                this.done = true;
                this.rsClosed = new Boolean(true);
                this.rs.close();
                this.dbQuery.release();
                return null;
            }
        }
        catch (Exception e) {
            throw new QueryException("SQL=[" + this.sql + "]: Unable to get query results", (Throwable)e);
        }
        RDBColumnValue[] vals = new RDBColumnValue[this.selectedFields.size()];
        RDBColumn field = null;
        for (int i = 0; i < this.selectedFields.size(); ++i) {
            try {
                field = (RDBColumn)this.selectedFields.elementAt(i);
                vals[i] = new RDBColumnValue(field, this.rs.getObject(i + 1));
                continue;
            }
            catch (Exception e) {
                throw new QueryException("SQL=[" + this.sql + "]: Unable to get query result for column " + field, (Throwable)e);
            }
        }
        return new RDBRow(vals);
    }

    public Object next(ResultSet rs) throws SQLException, ObjectIdException {
        return null;
    }

    public QueryBuilder(String tableName) {
        this(tableName, tableName + ".*");
    }

    public QueryBuilder(String tableName, String fieldList) {
        this.reset();
        this.init();
        this.mainTableName = tableName;
        this.storeTableName(this.mainTableName);
        this.selectClause = fieldList;
    }

    private String getTableName(String column) {
        boolean offset = false;
        boolean end = false;
        String str = column;
        int index = str.lastIndexOf("(");
        if (-1 != index) {
            str = str.substring(index + 1);
        }
        if (-1 != (index = str.indexOf(")"))) {
            str = str.substring(0, index);
        }
        if (-1 == (index = str.indexOf("."))) {
            return null;
        }
        return str.substring(0, index);
    }

    public boolean isMultiTableJoin() {
        return this.multiTableJoin;
    }

    public boolean isUnionTableJoin() {
        return this.unionTableJoin;
    }

    public boolean getPreventPrimaryKeySelect() {
        return this.preventPrimaryKeySelect;
    }

    public void resetSelectedFields() {
        this.selectedFields = new Vector();
        this.selectClause = "";
    }

    private void storeTableNameForColumn(String column) {
        String table = this.getTableName(column);
        this.storeTableName(table);
    }

    private void storeTableNameForColumn(RDBColumn column) {
        this.storeTableName(column.getTableName());
    }

    private void storeTableName(String table) {
        if (null != table) {
            this.tableNames.put(table, "");
        }
    }

    public void addWhereOr() {
        int n = this.whereClauses.size();
        if (0 == n) {
            return;
        }
        String prev = (String)this.whereClauses.lastElement();
        if (!OR.equals(prev)) {
            this.whereClauses.addElement(OR);
        }
    }

    public void addWhereOpenParen() {
        this.whereClauses.addElement(OPEN_PAREN);
    }

    public void addWhereCloseParen() {
        int n = this.whereClauses.size();
        if (0 == n) {
            return;
        }
        String prev = (String)this.whereClauses.lastElement();
        if (!OR.equals(prev) && !OPEN_PAREN.equals(prev)) {
            this.whereClauses.addElement(" ) ");
        }
    }

    public void addWhere(RDBColumn column, GenericDO value, String cmp_op) {
        BigDecimal id = null;
        if (null != value) {
            id = value.get_OId().toBigDecimal();
        }
        this._addWhereClause(column, (Object)id, cmp_op);
    }

    public void addWhere(RDBColumn column, byte[] value, String cmp_op) {
        String v = null;
        if (null != value) {
            v = new String(value);
        }
        this._addWhereClause(column, (Object)v, cmp_op);
    }

    public void addWhere(RDBColumn column, Time value, String cmp_op) {
        this._addWhereClause(column, (Object)value, cmp_op);
    }

    public void addWhere(RDBColumn column, Timestamp value, String cmp_op) {
        this._addWhereClause(column, (Object)value, cmp_op);
    }

    public void addWhere(RDBColumn column, long value, String cmp_op) {
        this._addWhereClause(column, (Object)new Long(value), cmp_op);
    }

    public void addWhere(RDBColumn column, double value, String cmp_op) {
        this._addWhereClause(column, (Object)new Double(value), cmp_op);
    }

    public void addWhere(RDBColumn column, float value, String cmp_op) {
        this._addWhereClause(column, (Object)new Float(value), cmp_op);
    }

    public void addWhere(RDBColumn column, BigDecimal value, String cmp_op) {
        this._addWhereClause(column, (Object)value, cmp_op);
    }

    public void addWhere(RDBColumn column, int value, String cmp_op) {
        this._addWhereClause(column, (Object)new Integer(value), cmp_op);
    }

    public void addWhere(RDBColumn column, boolean value, String cmp_op) {
        this._addWhereClause(column, (Object)new Boolean(value), cmp_op);
    }

    public void addWhere(RDBColumn column, int value) {
        this.addWhere(column, value, EQUAL);
    }

    public void addWhereLower(RDBColumn column, String value, String cmp_op) {
        if (this.caseInsensitiveDatabase) {
            this._addWhereClause(column.getFullColumnName(), (Object)value, cmp_op);
        } else {
            this._addWhereClause("LOWER(" + column.getFullColumnName() + ")", (Object)value, cmp_op);
        }
    }

    public void addWhere(RDBColumn column, String value, String cmp_op) {
        this._addWhereClause(column, (Object)value, cmp_op);
    }

    public void addWhere(RDBColumn column, String value) {
        this.addWhere(column, value, EQUAL);
    }

    public void addWhere(RDBColumn column, Date value, String cmp_op) {
        this._addWhereClause(column, (Object)value, cmp_op);
    }

    public void addWhere(RDBColumn column1, RDBColumn column2, String cmp_op) {
        String cn1 = column1.getFullColumnName();
        String cn2 = column2.getFullColumnName();
        this.storeTableNameForColumn(cn1);
        this.storeTableNameForColumn(cn2);
        this.whereClauses.addElement(cn1 + " " + cmp_op + " " + cn2);
        if (!column1.getTableName().equals(column2.getTableName())) {
            this.multiTableJoin = true;
        }
    }

    public void addWhere(RDBColumn column1, RDBColumn column2) {
        this.addWhere(column1, column2, EQUAL);
    }

    public void addWhereIsNull(RDBColumn column) {
        this._addWhereClause(column, null, IS_NULL);
    }

    public void addWhereIsNotNull(RDBColumn column) {
        this._addWhereClause(column, null, IS_NOT_NULL);
    }

    public void addWhereIsNull(String column) {
        this._addWhereClause(column, null, IS_NULL);
    }

    public void addWhereIsNotNull(String column) {
        this._addWhereClause(column, null, IS_NOT_NULL);
    }

    public void addWhereRightOuter(RDBColumn column1, RDBColumn column2) {
        String cn1 = column1.getFullColumnName() + "(+)";
        String cn2 = column2.getFullColumnName();
        this.storeTableNameForColumn(column1);
        this.storeTableNameForColumn(column2);
        this.whereClauses.addElement(cn1 + " = " + cn2);
    }

    public void addWhereLeftOuter(RDBColumn column1, RDBColumn column2) {
        String cn1 = column1.getFullColumnName();
        String cn2 = column2.getFullColumnName() + "(+)";
        this.storeTableNameForColumn(column1);
        this.storeTableNameForColumn(column2);
        this.whereClauses.addElement(cn1 + " = " + cn2);
    }

    public void addTwoColumnWhereClause(String column1, String column2, String cmp_op) {
        this.storeTableNameForColumn(column1);
        this.storeTableNameForColumn(column2);
        this.whereClauses.addElement(column1 + " " + cmp_op + " " + column2);
    }

    public void addTwoColumnWhereClause(String column1, String column2) {
        this.addTwoColumnWhereClause(column1, column2, EQUAL);
    }

    public static String stringReplace(String s, String find, String replace) {
        if (null == s || null == find || null == replace) {
            return s;
        }
        int x = s.indexOf(find);
        if (-1 == x) {
            return s;
        }
        String ret = s.substring(0, x);
        ret = ret + replace;
        ret = ret + s.substring(x + find.length());
        return ret;
    }

    private void _addWhereClause(RDBColumn column, Object value, String cmp_op) {
        this.storeTableNameForColumn(column);
        this.buildWhereClause(column.getFullColumnName(), value, cmp_op);
    }

    private void _addWhereClause(String column, Object value, String cmp_op) {
        this.storeTableNameForColumn(column);
        this.buildWhereClause(column, value, cmp_op);
    }

    private void buildWhereClause(String column, Object value, String cmp_op) {
        String escapeString = "";
        if (null == value) {
            if (EQUAL.equals(cmp_op)) {
                cmp_op = IS_NULL;
            } else if (NOT_EQUAL.equals(cmp_op)) {
                cmp_op = IS_NOT_NULL;
            }
            this.whereClauses.addElement(column + cmp_op);
        } else if (IS_NULL.equals(cmp_op) || IS_NOT_NULL.equals(cmp_op)) {
            this.whereClauses.addElement(column + cmp_op);
        } else {
            if (-1 != cmp_op.indexOf(37) || cmp_op.equals(CASE_INSENSITIVE_MATCH) || cmp_op.equals(CASE_SENSITIVE_MATCH) || cmp_op.equals(USER_CASE_INSENSITIVE_MATCH) || cmp_op.equals(USER_CASE_SENSITIVE_MATCH)) {
                String s = (String)value;
                if (-1 != cmp_op.indexOf(117)) {
                    s = this.convertUserSearchValue(s);
                    if (this.userTrimString) {
                        s = s.trim();
                    }
                    if (this.userAppendWildcard) {
                        s = s + this.wildcard;
                    }
                    cmp_op = QueryBuilder.stringReplace(cmp_op, USER_CASE_INSENSITIVE_MATCH, CASE_INSENSITIVE_MATCH);
                }
                if (-1 != cmp_op.indexOf(85)) {
                    s = this.convertUserSearchValue(s);
                    if (this.userTrimString) {
                        s = s.trim();
                    }
                    if (this.userAppendWildcard) {
                        s = s + this.wildcard;
                    }
                    cmp_op = QueryBuilder.stringReplace(cmp_op, USER_CASE_SENSITIVE_MATCH, CASE_SENSITIVE_MATCH);
                }
                if (-1 != cmp_op.indexOf(120)) {
                    s = s.toLowerCase();
                    if (!this.caseInsensitiveDatabase) {
                        column = "LOWER( " + column + ")";
                    }
                }
                if (cmp_op.equals(CASE_INSENSITIVE_EQUAL)) {
                    cmp_op = EQUAL;
                    value = s;
                } else {
                    value = QueryBuilder.stringReplace(cmp_op.toLowerCase(), CASE_INSENSITIVE_MATCH, s);
                    if (this.containsWildcards((String)value)) {
                        if (((String)value).equals(this.wildcard)) {
                            return;
                        }
                        escapeString = " " + this.wildcardEscapeClause;
                        cmp_op = this.likeKeyword;
                    } else {
                        cmp_op = EQUAL;
                    }
                }
            }
            this.whereClauses.addElement(column + " " + cmp_op + " ?" + escapeString);
            this.parms.addElement(value);
        }
    }

    public void addWhereClause(String column, String value, String cmp_op) {
        this._addWhereClause(column, (Object)value, cmp_op);
    }

    public boolean addMatchClause(String column, String value) {
        String append = "";
        String pattern = value;
        boolean added = false;
        if (pattern != null) {
            if (this.userTrimString) {
                pattern = pattern.trim();
            }
            if (this.userAppendWildcard) {
                pattern = pattern + this.wildcard;
            }
            if (!pattern.equals(this.wildcard)) {
                append = " " + column + " " + this.likeKeyword + " ? " + this.wildcardEscapeClause;
                added = true;
                this.parms.addElement(pattern);
            }
        }
        if (added) {
            this.storeTableNameForColumn(column);
            this.whereClauses.addElement(append);
        }
        return added;
    }

    public boolean addUserMatchClause(String column, String value) {
        boolean ret = false;
        String pattern = this.convertUserSearchValue(value);
        if (this.containsWildcards(pattern) || this.userAppendWildcard) {
            ret = this.addMatchClause(column, pattern);
        } else {
            this.addWhereClause(column, value, EQUAL);
            ret = true;
        }
        return ret;
    }

    public boolean addMatchClause(RDBColumn column, String value) {
        return this.addMatchClause(column.getFullColumnName(), value);
    }

    public boolean addUserMatchClause(RDBColumn column, String value) {
        return this.addUserMatchClause(column.getFullColumnName(), value);
    }

    public boolean containsWildcards(String value) {
        boolean ret = false;
        if (-1 != value.indexOf(this.wildcard)) {
            ret = true;
        }
        if (-1 != value.indexOf(this.singleWildcard)) {
            ret = true;
        }
        return ret;
    }

    public String convertUserSearchValue(String value) {
        String ret;
        if (value == null) {
            ret = null;
        } else {
            ret = "";
            for (int x = 0; x < value.length(); ++x) {
                if (value.startsWith(this.userSingleWildcard, x)) {
                    ret = ret + this.singleWildcard;
                    continue;
                }
                if (value.startsWith(this.userWildcard, x)) {
                    ret = ret + this.wildcard;
                    continue;
                }
                if (value.startsWith(this.wildcard, x)) {
                    ret = ret + this.wildcardEscape + this.wildcard;
                    continue;
                }
                if (value.startsWith(this.singleWildcard, x)) {
                    ret = ret + this.singleWildcardEscape + this.singleWildcard;
                    continue;
                }
                if (x + 1 < value.length()) {
                    if (value.startsWith(this.userSingleWildcardEscape + this.userSingleWildcard, x)) {
                        ret = ret + this.userSingleWildcard;
                        ++x;
                        continue;
                    }
                    if (value.startsWith(this.userWildcardEscape + this.userWildcard, x)) {
                        ret = ret + this.userWildcard;
                        ++x;
                        continue;
                    }
                    if (value.startsWith(this.userWildcardEscape + this.userWildcardEscape, x)) {
                        ret = ret + this.userWildcardEscape;
                        if (this.userWildcardEscape == this.wildcardEscape) {
                            ret = ret + this.wildcardEscape;
                        }
                        ++x;
                        continue;
                    }
                    if (value.startsWith(this.userSingleWildcardEscape + this.userSingleWildcardEscape, x)) {
                        ret = ret + this.userSingleWildcardEscape;
                        if (this.userSingleWildcardEscape == this.singleWildcardEscape) {
                            ret = ret + this.singleWildcardEscape;
                        }
                        ++x;
                        continue;
                    }
                    ret = ret + value.substring(x, x + 1);
                    if (value.startsWith(this.singleWildcardEscape, x)) {
                        ret = ret + this.singleWildcardEscape;
                        continue;
                    }
                    if (!value.startsWith(this.wildcardEscape, x)) continue;
                    ret = ret + this.wildcardEscape;
                    continue;
                }
                ret = ret + value.substring(x, x + 1);
                if (value.startsWith(this.singleWildcardEscape, x)) {
                    ret = ret + this.singleWildcardEscape;
                    continue;
                }
                if (!value.startsWith(this.wildcardEscape, x)) continue;
                ret = ret + this.wildcardEscape;
            }
        }
        return ret;
    }

    public boolean addWhereClause(String column, BigDecimal value, boolean nullOk) {
        this.storeTableNameForColumn(column);
        String append = "";
        boolean added = false;
        if (value == null) {
            if (nullOk) {
                append = " " + column + " is null";
                added = true;
            }
        } else {
            append = " " + column + " = ?";
            added = true;
            this.parms.addElement(value);
        }
        if (added) {
            this.whereClauses.addElement(append);
        }
        return added;
    }

    public void addWhereClause(String column, int value) {
        this._addWhereClause(column, (Object)new Integer(value), EQUAL);
    }

    public void addWhereClause(String column, int value, String cmp_op) {
        this._addWhereClause(column, (Object)new Integer(value), cmp_op);
    }

    public void addWhereClause(String column, long value) {
        this._addWhereClause(column, (Object)new Long(value), EQUAL);
    }

    public void addWhereClause(String column, long value, String cmp_op) {
        this._addWhereClause(column, (Object)new Long(value), cmp_op);
    }

    public void addWhereClause(String column, float value) {
        this._addWhereClause(column, (Object)new Float(value), EQUAL);
    }

    public void addWhereClause(String column, float value, String cmp_op) {
        this._addWhereClause(column, (Object)new Float(value), cmp_op);
    }

    public void addWhereClause(String column, double value) {
        this._addWhereClause(column, (Object)new Double(value), EQUAL);
    }

    public void addWhereClause(String column, double value, String cmp_op) {
        this._addWhereClause(column, (Object)new Double(value), cmp_op);
    }

    public void addWhereClause(String column, boolean value) {
        this._addWhereClause(column, (Object)new Integer(value ? 1 : 0), EQUAL);
    }

    public void addWhereClause(String column, boolean value, String cmp_op) {
        this._addWhereClause(column, (Object)new Integer(value ? 1 : 0), cmp_op);
    }

    public void addEndClause(String clause) {
        this.endClauses.put(clause, "");
        this.preventPrimaryKeySelect = true;
    }

    public void add(String str) {
        this.addEndClause(str);
    }

    public void debug() {
        this.debugSQL = true;
    }

    public static void debugAll() {
        debugAllSQL = true;
    }

    public void distinct() {
        this.distinct = "distinct ";
    }

    public void addWhere(String fullClause) {
        this.whereClauses.addElement(fullClause);
        this.multiTableJoin = true;
        this.preventPrimaryKeySelect = true;
    }

    public void addWhereIn(RDBColumn val, String[] values) throws QueryException {
        if (null == values || 0 == values.length) {
            throw new QueryException("IN clause must have at least one value.");
        }
        if (null == val) {
            throw new QueryException("IN clause left value cannot be null");
        }
        String comma = "";
        String qmarks = "";
        for (int i = 0; i < values.length; ++i) {
            String v = values[i];
            this.parms.addElement(values[i]);
            qmarks = qmarks + comma + "?";
            comma = ", ";
        }
        this.storeTableName(val.getTableName());
        this.addWhere(val.getFullColumnName() + OPEN_IN + qmarks + " ) ");
    }

    public void addWhereIn(RDBColumn val, BigDecimal[] values) throws QueryException {
        if (null == values || 0 == values.length) {
            throw new QueryException("IN clause must have at least one value.");
        }
        if (null == val) {
            throw new QueryException("IN clause left value cannot be null");
        }
        String comma = "";
        String qmarks = "";
        for (int i = 0; i < values.length; ++i) {
            BigDecimal v = values[i];
            if (v == null) continue;
            qmarks = qmarks + comma + v.toString();
            comma = ", ";
        }
        this.storeTableName(val.getTableName());
        this.addWhere(val.getFullColumnName() + OPEN_IN + qmarks + " ) ");
    }

    public void addWhereIn(RDBColumn val, ObjectId[] values) throws QueryException {
        if (null == values || 0 == values.length) {
            throw new QueryException("IN clause must have at least one value.");
        }
        if (null == val) {
            throw new QueryException("IN clause left value cannot be null");
        }
        String comma = "";
        String qmarks = "";
        for (int i = 0; i < values.length; ++i) {
            ObjectId v = values[i];
            if (v == null) continue;
            qmarks = qmarks + comma + v.toString();
            comma = ", ";
        }
        this.storeTableName(val.getTableName());
        this.addWhere(val.getFullColumnName() + OPEN_IN + qmarks + " ) ");
    }

    public void addWhereIn(RDBColumn val, GenericDO[] values) throws QueryException {
        if (null == values || 0 == values.length) {
            throw new QueryException("IN clause must have at least one value.");
        }
        if (null == val) {
            throw new QueryException("IN clause left value cannot be null");
        }
        String comma = "";
        String qmarks = "";
        for (int i = 0; i < values.length; ++i) {
            GenericDO v = values[i];
            if (v == null) continue;
            try {
                qmarks = qmarks + comma + v.getHandle();
                comma = ", ";
                continue;
            }
            catch (DatabaseManagerException e) {
                throw new QueryException("Error during preparing where clause in SQL statement");
            }
        }
        this.storeTableName(val.getTableName());
        this.addWhere(val.getFullColumnName() + OPEN_IN + qmarks + " ) ");
    }

    public void addWhereIn(RDBColumn field, QueryBuilder qb) throws QueryException {
        if (this == qb) {
            throw new QueryException("Recursion detection: subquery cannot be the same object as the main query.");
        }
        this.storeTableName(field.getTableName());
        this.addWhere(field.getFullColumnName() + OPEN_IN + qb.getSQL() + " ) ");
        this.parms.addElement(qb);
        this.multiTableJoin = true;
    }

    public void resetUnion() {
        this.doUnionAll = new Vector();
        this.unionQuerys = new Vector();
        this.unionTableJoin = false;
    }

    public void addUnion(QueryBuilder qb, boolean all) throws QueryException {
        if (this == qb) {
            throw new QueryException("Recursion detection: union query cannot be the same object as the main query.");
        }
        this.doUnionAll.add(new Boolean(all));
        this.unionQuerys.add(qb);
        this.unionTableJoin = true;
    }

    public void addWhereExists(QueryBuilder qb) throws QueryException {
        if (this == qb) {
            throw new QueryException("Recursion detection: subquery cannot be the same object as the main query.");
        }
        this.addWhere(OPEN_EXISTS + qb.getSQL() + " ) ");
        this.parms.addElement(qb);
        this.multiTableJoin = true;
    }

    public void addWhereNotExists(QueryBuilder qb) throws QueryException {
        if (this == qb) {
            throw new QueryException("Recursion detection: subquery cannot be the same object as the main query.");
        }
        this.addWhere(OPEN_NOT_EXISTS + qb.getSQL() + " ) ");
        this.parms.addElement(qb);
        this.multiTableJoin = true;
    }

    public void addWhereNotIn(RDBColumn field, QueryBuilder qb) throws QueryException {
        if (this == qb) {
            throw new QueryException("Recursion detection: subquery cannot be the same object as the main query.");
        }
        this.storeTableName(field.getTableName());
        this.addWhere(field.getFullColumnName() + OPEN_NOT_IN + qb.getSQL() + " ) ");
        this.parms.addElement(qb);
        this.multiTableJoin = true;
    }

    public void addWhereIn(Object val, Object[] values) throws QueryException {
        if (null == values || 0 == values.length) {
            throw new QueryException("IN clause must have at least one value.");
        }
        if (null == val) {
            throw new QueryException("IN clause left value cannot be null");
        }
        String comma = "";
        String qmarks = "";
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (v instanceof RDBColumn) {
                RDBColumn f = (RDBColumn)v;
                this.storeTableName(f.getTableName());
                qmarks = qmarks + comma + f.getFullColumnName();
            } else {
                this.parms.addElement(values[i]);
                qmarks = qmarks + comma + "?";
            }
            comma = ", ";
        }
        if (val instanceof RDBColumn) {
            RDBColumn f = (RDBColumn)val;
            this.storeTableName(f.getTableName());
            this.addWhere(f.getFullColumnName() + OPEN_IN + qmarks + " ) ");
        } else {
            this.parms.addElement(val);
            this.addWhere("? IN ( " + qmarks + " ) ");
        }
    }

    public void addWhereNotIn(Object val, Object[] values) throws QueryException {
        if (null == values || 0 == values.length) {
            throw new QueryException("NOT IN clause must have at least one value.");
        }
        if (null == val) {
            throw new QueryException("NOT IN clause left value cannot be null");
        }
        String comma = "";
        String qmarks = "";
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            if (v instanceof RDBColumn) {
                RDBColumn f = (RDBColumn)v;
                this.storeTableName(f.getTableName());
                qmarks = qmarks + comma + f.getFullColumnName();
            } else {
                this.parms.addElement(values[i]);
                qmarks = qmarks + comma + "?";
            }
            comma = ", ";
        }
        if (val instanceof RDBColumn) {
            RDBColumn f = (RDBColumn)val;
            this.storeTableName(f.getTableName());
            this.addWhere(f.getFullColumnName() + OPEN_NOT_IN + qmarks + " ) ");
        } else {
            this.parms.addElement(val);
            this.addWhere("? NOT IN ( " + qmarks + " ) ");
        }
    }

    public String getSQLwithParms() {
        return this.recurseSQLwithParms(this.getSQL());
    }

    private String recurseSQLwithParms(String sSQL) {
        try {
            for (int iParm = 0; iParm < this.parms.size(); ++iParm) {
                Object o = this.parms.get(iParm);
                int iIndex = sSQL.indexOf("?");
                if (o instanceof QueryBuilder) {
                    sSQL = ((QueryBuilder)o).recurseSQLwithParms(sSQL);
                    continue;
                }
                StringBuffer sbSQL = new StringBuffer(sSQL);
                String s = o.toString();
                sbSQL.replace(iIndex, iIndex + 1, s);
                sSQL = sbSQL.toString();
            }
        }
        catch (Exception ex) {
            sSQL = sSQL + " : error occured during getting SQL command : " + ex;
        }
        return sSQL;
    }

    public String getSQL() {
        int i;
        int nr_OrderFields;
        int numWhereClauses;
        int i2;
        if (this.iQueryType == 1) {
            this.sql = "update ";
        } else if (this.iQueryType == 2) {
            this.sql = "delete from ";
        } else {
            if (this.selectClause != null) {
                boolean withPrefix = this.selectClause.startsWith("@T@_");
                boolean withNoPrefix = this.selectClause.startsWith("@F@_");
                String tableName = "";
                if (withPrefix || withNoPrefix) {
                    tableName = this.selectClause.substring(this.selectClause.indexOf(DEFAULT_SINGLE_WILDCARD) + 1, this.selectClause.indexOf("_@@."));
                    String fakeTableName = withPrefix ? "@T@_" + tableName + "_@@." : "@F@_" + tableName + "_@@.";
                    tableName = tableName + ".";
                    this.selectClause = withPrefix || this.isMultiTableJoin() ? Common.replaceAll(this.selectClause, fakeTableName, tableName) : Common.replaceAll(this.selectClause, fakeTableName, "");
                }
            }
            String glue = 0 == this.selectClause.length() ? "" : ", ";
            for (i2 = 0; i2 < this.selectedFields.size(); ++i2) {
                RDBColumn field = (RDBColumn)this.selectedFields.elementAt(i2);
                this.selectClause = this.selectClause + glue + field.getFullColumnName();
                this.mainTableName = field.getTableName();
                this.storeTableName(this.mainTableName);
                glue = ", ";
            }
            this.sql = "select " + this.distinct + this.selectClause + " from ";
        }
        Enumeration tables = this.tableNames.keys();
        i2 = 0;
        while (tables.hasMoreElements()) {
            if (i2 > 0) {
                this.sql = this.sql + ", ";
            }
            this.sql = this.sql + tables.nextElement();
            ++i2;
        }
        if (this.iQueryType == 1) {
            this.sql = this.sql + " set ";
            int nr_updateFields = this.updateFields.size();
            for (int i3 = 0; i3 < nr_updateFields; ++i3) {
                if (i3 > 0) {
                    this.sql = this.sql + ", ";
                }
                this.sql = this.sql + this.updateFields.elementAt(i3);
            }
        }
        String chunk = null;
        for (numWhereClauses = this.whereClauses.size(); numWhereClauses > 0 && ((chunk = (String)this.whereClauses.elementAt(numWhereClauses - 1)).equals(OR) || chunk.equals(OPEN_PAREN)); --numWhereClauses) {
        }
        int parenDepth = 0;
        boolean prevWas_OpenParen_or_OR = true;
        for (int i4 = 0; i4 < numWhereClauses; ++i4) {
            chunk = (String)this.whereClauses.elementAt(i4);
            if (0 == i4) {
                this.sql = this.sql + " WHERE ";
            }
            if (chunk.equals(OR)) {
                prevWas_OpenParen_or_OR = true;
            } else if (chunk.equals(OPEN_PAREN)) {
                if (!prevWas_OpenParen_or_OR) {
                    this.sql = this.sql + " AND ";
                }
                prevWas_OpenParen_or_OR = true;
                ++parenDepth;
            } else if (chunk.equals(" ) ")) {
                if (parenDepth > 0) {
                    prevWas_OpenParen_or_OR = false;
                    --parenDepth;
                } else {
                    chunk = "";
                }
            } else {
                if (!prevWas_OpenParen_or_OR) {
                    this.sql = this.sql + " AND ";
                }
                prevWas_OpenParen_or_OR = false;
            }
            this.sql = this.sql + chunk;
        }
        while (parenDepth-- > 0) {
            this.sql = this.sql + " ) ";
        }
        if (this.iQueryType == 0 && (nr_OrderFields = this.orderFields.size()) > 0) {
            this.sql = this.sql + " ORDER BY ";
            for (i = 0; i < nr_OrderFields; ++i) {
                if (i > 0) {
                    this.sql = this.sql + ", ";
                }
                this.sql = this.sql + this.orderFields.elementAt(i) + " " + this.orderDirections.elementAt(i);
            }
        }
        Enumeration endings = this.endClauses.keys();
        while (endings.hasMoreElements()) {
            this.sql = this.sql + endings.nextElement();
        }
        if (this.isUnionTableJoin()) {
            for (i = 0; i < this.unionQuerys.size(); ++i) {
                QueryBuilder tmpQB = (QueryBuilder)this.unionQuerys.elementAt(i);
                this.sql = (Boolean)this.doUnionAll.elementAt(i) != false ? this.sql + "  UNION  ALL  " + tmpQB.getSQL() : this.sql + "  UNION  " + tmpQB.getSQL();
                this.parms.addElement(tmpQB);
            }
        }
        return this.sql;
    }

    public int applyParameters(PreparedStatement ps, int paramCount) throws SQLException {
        for (int i = 0; i < this.parms.size(); ++i) {
            int n = ++paramCount;
            Object o = this.parms.elementAt(i);
            if (this.debugSQL || debugAllSQL) {
                System.out.print("Param: " + i + ", paramCount=" + paramCount);
                System.out.println(", Value: " + o);
            }
            if (o instanceof String) {
                ps.setString(n, (String)o);
                continue;
            }
            if (o instanceof Date) {
                ps.setDate(n, (Date)o);
                continue;
            }
            if (o instanceof Timestamp) {
                ps.setTimestamp(n, (Timestamp)o);
                continue;
            }
            if (o instanceof BigDecimal) {
                ps.setBigDecimal(n, (BigDecimal)o);
                continue;
            }
            if (o instanceof Integer) {
                ps.setInt(n, (Integer)o);
                continue;
            }
            if (o instanceof Long) {
                ps.setLong(n, (Long)o);
                continue;
            }
            if (o instanceof Float) {
                ps.setFloat(n, ((Float)o).floatValue());
                continue;
            }
            if (o instanceof Double) {
                ps.setDouble(n, (Double)o);
                continue;
            }
            if (o instanceof Boolean) {
                ps.setBoolean(n, (Boolean)o);
                continue;
            }
            if (o instanceof GenericDO) {
                ps.setBigDecimal(n, ((GenericDO)o).get_OId().toBigDecimal());
                continue;
            }
            if (!(o instanceof QueryBuilder)) continue;
            QueryBuilder subQuery = (QueryBuilder)o;
            --paramCount;
            paramCount = subQuery.applyParameters(ps, paramCount);
        }
        return paramCount;
    }

    private void prepareStatement(DBConnection conn) throws SQLException {
        this.getSQL();
        if (this.debugSQL || debugAllSQL) {
            System.out.println("\nQueryBuilder.prepareStatement sql=\n" + this.prettySQL(this.sql) + "\n");
        }
        try {
            int ifs;
            int qto;
            this.stmt = this.iResultSetConcurrency == this.DEFAULT_RS_CONCURRENCY && this.iResultSetType == this.DEFAULT_RS_TYPE ? conn.prepareStatement(this.sql) : ((ExtendedDBConnection)conn).prepareStatement(this.sql, this.iResultSetType, this.iResultSetConcurrency);
            int n = qto = 0 < this.iCurrentQueryTimeout ? this.iCurrentQueryTimeout : iDefaultQueryTimeout;
            if (qto > 0) {
                this.stmt.setQueryTimeout(qto);
            }
            int n2 = ifs = this.iCurrentFetchSize < 0 ? iDefaultFetchSize : this.iCurrentFetchSize;
            if (ifs > 0) {
                if (this.doCursorName(conn)) {
                    this.stmt.setCursorName(QueryBuilder.getCountX());
                }
                if (this.doSetFetchSize(conn)) {
                    this.stmt.setFetchSize(ifs);
                }
            }
            this.stmt.setMaxRows(this.maxRows);
        }
        catch (SQLException se) {
            System.err.println("\n\nSQLException: " + se.getMessage() + "," + se.getErrorCode() + "," + se.getSQLState());
            throw se;
        }
        this.applyParameters(this.stmt, 0);
    }

    public void setMaxRows(int x) {
        if (0 > x) {
            x = 0;
        }
        this.maxRows = x;
    }

    private String indent(int level) {
        String ret = "";
        for (int i = 0; i < level; ++i) {
            ret = ret + "    ";
        }
        return ret;
    }

    private String prettySQL(String sql) {
        int next = 0;
        boolean sp = false;
        int level = 0;
        int word = 0;
        String out = "";
        int pastend = 9999999;
        sql = sql + " ";
        int offset = 0;
        while (offset < sql.length()) {
            int i;
            int nearest = pastend;
            for (i = 0; i < this.breakWords.length; ++i) {
                next = sql.indexOf(this.breakWords[i], offset);
                if (-1 == next || next >= nearest) continue;
                nearest = next;
                word = i;
            }
            next = nearest;
            i = word;
            if (i < this.breakWords.length && pastend != nearest) {
                int wordlen = this.breakWords[i].length();
                if (0 == i) {
                    ++level;
                }
                out = out + sql.substring(offset, next);
                out = out + "\n";
                out = out + this.indent(level);
                out = out + sql.substring(next, next + wordlen) + " ";
                next += wordlen;
                if (1 == i) {
                    --level;
                }
                offset = next;
                continue;
            }
            out = out + this.indent(level) + sql.substring(offset);
            break;
        }
        return out;
    }

    @Override
    public PreparedStatement getStatement() {
        return this.stmt;
    }

    public PreparedStatement getStatement(DBConnection conn) throws SQLException {
        this.prepareStatement(conn);
        return this.stmt;
    }

    public ResultSet executeQuery(DBConnection conn) throws SQLException {
        boolean overrun;
        this.prepareStatement(conn);
        int maxExecuteTime = ((StandardDatabaseManager)DODS.getDatabaseManager()).getDatabaseManagerConfiguration().getMaxExecuteTime();
        boolean throwException = false;
        String errMsg = "<no-defined>";
        java.util.Date startQueryT = new java.util.Date();
        try {
            this.rs = this.stmt.executeQuery();
        }
        catch (SQLException esql) {
            throwException = true;
            errMsg = "<Replicated>:" + esql.getMessage();
            DODS.getLogChannel().write(3, " <SqlQueryExecute><SqlQueryException>(" + errMsg + ")");
        }
        java.util.Date stopQueryT = new java.util.Date();
        int qTime = new Long(stopQueryT.getTime() - startQueryT.getTime()).intValue();
        int qto = 0 < this.iCurrentQueryTimeout ? this.iCurrentQueryTimeout : iDefaultQueryTimeout;
        int queryTimeOutValue = qto * 1000;
        boolean bl = overrun = queryTimeOutValue > 0 && qTime >= queryTimeOutValue;
        if (qTime >= maxExecuteTime) {
            DODS.getLogChannel().write(7, " <SqlQueryTime> :ExecuteTime=" + qTime + " [MaxExecuteTime(ms)=" + maxExecuteTime + "] :sql=" + this.getSQLwithParms() + " :execute time =" + qTime + " :max execute time = " + maxExecuteTime);
        }
        if (overrun) {
            DODS.getLogChannel().write(7, " <SqlQueryTimeOut> :ExecuteTime=" + qTime + " [QueryTimeOut(ms)=" + queryTimeOutValue + "] :sql=" + this.getSQLwithParms() + " :execute time =" + qTime + " :QueryTimeOut =" + queryTimeOutValue);
        }
        if (throwException) {
            throw new SQLException("<SqlQueryExecute><SqlQueryException>(" + errMsg + ")");
        }
        if (overrun) {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
            }
            catch (SQLException esql) {
                DODS.getLogChannel().write(7, " <SqlQueryTimeOut> Forced ResultSet close error.");
            }
            throw new SQLException(" <SqlQueryTimeOut> Query timeout, forced close of ResultSet");
        }
        this.rsClosed = new Boolean(false);
        return this.rs;
    }

    public void reset() {
        this.setMaxRows(0);
        this.whereClauses = new Vector();
        this.parms = new Vector();
        this.fuzzies = new BitSet();
        this.multiTableJoin = false;
        this.orderFields = new Vector();
        this.orderDirections = new Vector();
        try {
            if (null != this.rs && null != this.rsClosed && !this.rsClosed.booleanValue()) {
                this.rsClosed = new Boolean(true);
                this.rs.close();
            }
            this.rs = null;
            this.rsClosed = new Boolean(true);
        }
        catch (SQLException e) {
            DODS.getLogChannel().write(7, "QueryBuilder unable to close ResultSet: SQLException=" + e.getMessage());
        }
        if (null != this.conn) {
            this.conn.close();
        }
        this.conn = null;
    }

    public void close() {
        try {
            if (null != this.dbQuery) {
                this.dbQuery.release();
            }
            if (null != this.rs && null != this.rsClosed && !this.rsClosed.booleanValue()) {
                this.rsClosed = new Boolean(true);
                this.rs.close();
            }
            this.rsClosed = new Boolean(true);
            this.rs = null;
        }
        catch (SQLException e) {
            DODS.getLogChannel().write(7, "QueryBuilder unable to close ResultSet: SQLException=" + e.getMessage());
        }
    }

    private String getRegExpMatch(String base) {
        int len = base.length();
        char[] baseChars = new char[len];
        base.getChars(0, len, baseChars, 0);
        char[] result = new char[len * 5];
        int resultIdx = 0;
        for (int idx = 0; idx < baseChars.length; ++idx) {
            if (Character.isSpaceChar(baseChars[idx])) {
                if (resultIdx <= 0 || result[resultIdx - 1] == '*') continue;
                result[resultIdx++] = 32;
                result[resultIdx++] = 37;
                continue;
            }
            if (Character.isLetter(baseChars[idx])) {
                result[resultIdx++] = 91;
                result[resultIdx++] = Character.toUpperCase(baseChars[idx]);
                result[resultIdx++] = Character.toLowerCase(baseChars[idx]);
                result[resultIdx++] = 93;
                continue;
            }
            result[resultIdx++] = baseChars[idx];
        }
        result[resultIdx++] = 42;
        return new String(result);
    }

    public void setDeleteQuery() {
        this.iQueryType = 2;
    }

    public void addUpdateColumn(RDBColumn column, Object value) {
        this._addUpdateColumn(column.getFullColumnName(), value);
    }

    public void addUpdateColumn(String column, Object value) {
        this._addUpdateColumn(column, value);
    }

    private void _addUpdateColumn(RDBColumn column, Object value) {
        this._addUpdateColumn(column.getFullColumnName(), value);
    }

    private void _addUpdateColumn(String column, Object value) {
        this.iQueryType = 1;
        this.storeTableNameForColumn(column);
        if (value != null) {
            this.updateFields.addElement(column + " = ?");
            this.parms.add(this.updateFieldPos++, value);
        } else {
            this.updateFields.addElement(column + " = null");
        }
    }

    public void addUpdateSQL(RDBColumn column, String sqlValue) {
        this.addUpdateSQL(column.getFullColumnName(), sqlValue);
    }

    public void addUpdateSQL(String column, String sqlValue) {
        this.iQueryType = 1;
        this.storeTableNameForColumn(column);
        this.updateFields.addElement(column + " = " + sqlValue);
    }

    public int executeUpdate() throws SQLException {
        return this.executeUpdate(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(DBConnection dbConn) throws SQLException {
        int rc = 0;
        if (this.tableNames.size() > 1) {
            throw new SQLException("Too many tables specified for update/delete statement.");
        }
        try {
            if (null == dbConn) {
                if (this.conn == null) {
                    this.conn = DODS.getDatabaseManager().allocateConnection();
                }
                dbConn = this.conn;
            }
            this.prepareStatement(dbConn);
            rc = this.stmt.executeUpdate();
            return rc;
        }
        catch (SQLException sqlExcept) {
            if (this.conn == null) throw sqlExcept;
            try {
                this.conn.rollback();
            }
            catch (SQLException rollbackExcept) {
                System.out.println("Failed to rollback transaction.\n    SQLState = " + rollbackExcept.getSQLState() + "\n    SQLError = " + rollbackExcept.getErrorCode() + "\n    SQLMsg   = " + rollbackExcept.getMessage());
            }
            if (!this.conn.handleException(sqlExcept)) {
                this.conn = null;
            }
            System.out.println("ERR870: Exception in executeSQL " + sqlExcept);
            return rc;
        }
        catch (Exception ex) {
            System.out.println("ERR871: Exception in executeSQL " + ex);
            return rc;
        }
        finally {
            if (this.conn != null) {
                try {
                    this.conn.reset();
                }
                catch (SQLException sqlExcept) {
                    System.out.println("ObjectIdAllocator: \n  Failed to reset connection.\n    SQLState = " + sqlExcept.getSQLState() + "\n    SQLError = " + sqlExcept.getErrorCode() + "\n    SQLMsg   = " + sqlExcept.getMessage());
                }
                finally {
                    this.conn.release();
                    this.conn = null;
                }
            }
        }
    }

    public void setStringMatchDetails(String match_keyword, String wildcard) {
        this.likeKeyword = match_keyword;
        this.wildcard = wildcard;
    }

    public void setStringMatchDetails(String match_keyword, String multi_wildcard, String single_wildcard, String single_wildcard_escape, String multi_wildcard_escape, String wildcard_escape_clause) {
        this.likeKeyword = match_keyword;
        this.wildcard = multi_wildcard;
        this.singleWildcard = single_wildcard;
        this.singleWildcardEscape = single_wildcard_escape;
        this.wildcardEscape = multi_wildcard_escape;
        this.wildcardEscapeClause = wildcard_escape_clause;
    }

    private void initDefaultWildCards() {
        this.userWildcard = this.userConfigWildcard;
        this.userSingleWildcard = this.userConfigSingleWildcard;
        this.userSingleWildcardEscape = this.userConfigSingleWildcardEscape;
        this.userWildcardEscape = this.userConfigWildcardEscape;
    }

    public void setUserStringWildcard(String user_wildcard) {
        this.userWildcard = user_wildcard;
    }

    public void setUserStringSingleWildcard(String user_single_wildcard) {
        this.userSingleWildcard = user_single_wildcard;
    }

    public void setUserStringSingleWildcardEscape(String user_single_wildcard_escape) {
        this.userSingleWildcardEscape = user_single_wildcard_escape;
    }

    public void setUserStringWildcardEscape(String user_wildcard_escape) {
        this.userWildcardEscape = user_wildcard_escape;
    }

    public String getUserStringWildcard() {
        return this.userWildcard;
    }

    public String getUserStringSingleWildcard() {
        return this.userSingleWildcard;
    }

    public String getUserStringSingleWildcardEscape() {
        return this.userSingleWildcardEscape;
    }

    public String getUserStringWildcardEscape() {
        return this.userWildcardEscape;
    }

    public void setUserStringAppendWildcard(boolean user_append_wildcard) {
        this.userAppendWildcard = user_append_wildcard;
    }

    public void setUserStringTrim(boolean user_trim_string) {
        this.userTrimString = user_trim_string;
    }

    public boolean getUserStringAppendWildcard() {
        return this.userAppendWildcard;
    }

    public boolean getUserStringTrim() {
        return this.userTrimString;
    }

    public void addWhereClause(String column, Date date, String cmp_op) {
        this._addWhereClause(column, (Object)date, cmp_op);
    }

    public void addWhereClause(String column, Timestamp date, String cmp_op) {
        this._addWhereClause(column, (Object)date, cmp_op);
    }

    public void addWhereClause(String column, Time date, String cmp_op) {
        this._addWhereClause(column, (Object)date, cmp_op);
    }

    public void addOrderByColumn(String column, String direction) {
        this.orderFields.addElement(column);
        this.orderDirections.addElement(direction);
        this.preventPrimaryKeySelect = true;
    }

    public void addOrderByColumn(RDBColumn column, String direction) {
        this.orderFields.addElement(column.getFullColumnName());
        this.orderDirections.addElement(direction);
        this.preventPrimaryKeySelect = true;
    }

    public void setDatabaseVendor(String vendor) throws DatabaseManagerException {
        String str = Common.getDodsConfProperty("LikeKeyword", vendor);
        if (str != null) {
            this.likeKeyword = str;
        }
        if ((str = Common.getDodsConfProperty("Wildcard", vendor)) != null) {
            this.wildcard = str;
        }
        if ((str = Common.getDodsConfProperty("SingleWildcard", vendor)) != null) {
            this.singleWildcard = str;
        }
        if ((str = Common.getDodsConfProperty("SingleWildcardEscape", vendor)) != null) {
            this.singleWildcardEscape = str;
        }
        if ((str = Common.getDodsConfProperty("WildcardEscape", vendor)) != null) {
            this.wildcardEscape = str;
        }
        if ((str = Common.getDodsConfProperty("WildcardEscapeClause", vendor)) != null) {
            this.wildcardEscapeClause = str.equalsIgnoreCase("none") ? "" : str;
        }
    }

    public void setDatabaseVendor() {
        try {
            String vendor = DODS.getDatabaseManager().logicalDatabaseType();
            this.setDatabaseVendor(vendor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setDatabaseName(String dbName) {
        this.databaseName = dbName;
    }

    public String getDatabaseName() {
        if (this.databaseName == null) {
            try {
                this.databaseName = DODS.getDatabaseManager().getDefaultDB();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.databaseName;
    }

    public static boolean compare(double a, double b, String cmp_op) throws QueryException {
        return QueryBuilder.compare(new Double(a), (Object)new Double(b), cmp_op);
    }

    public static boolean compare(boolean a, boolean b, String cmp_op) throws QueryException {
        return QueryBuilder.compare(new Double(a ? 1.0 : 0.0), (Object)new Double(b ? 1.0 : 0.0), cmp_op);
    }

    public static boolean compare(double a, Object b, String cmp_op) throws QueryException {
        return QueryBuilder.compare(new Double(a), b, cmp_op);
    }

    public static boolean compare(boolean a, Object b, String cmp_op) throws QueryException {
        return QueryBuilder.compare(new Double(a ? 1.0 : 0.0), b, cmp_op);
    }

    public static boolean compare(Object a, Object b, String cmp_op) throws QueryException {
        Integer cmp = (Integer)cmp_ops.get(cmp_op);
        if (null == cmp) {
            throw new QueryException("Unrecognized comparison operator: " + cmp_op);
        }
        int op = cmp;
        switch (op) {
            case 7: {
                return null == b;
            }
            case 8: {
                return null != b;
            }
            case 1: {
                if (null == a && null == b) {
                    return true;
                }
                if (null == a || null == b) {
                    return false;
                }
                byte[] z = new byte[]{};
                if (a.getClass() == z.getClass()) {
                    byte[] ab = (byte[])a;
                    byte[] bb = (byte[])b;
                    if (ab.length != bb.length) {
                        return false;
                    }
                    for (int i = 0; i < ab.length; ++i) {
                        if (ab[i] == bb[i]) continue;
                        return false;
                    }
                    return true;
                }
                if (a instanceof GenericDO) {
                    String aoid = ((GenericDO)a).get_OId().toString();
                    String boid = ((GenericDO)b).get_OId().toString();
                    boolean equals = aoid.equals(boid);
                    return equals;
                }
                if (a instanceof BigDecimal && b instanceof GenericDO) {
                    return ((GenericDO)b).get_OId().toString().equals(a.toString());
                }
                if (a instanceof CoreDataStruct) {
                    String aoid = ((CoreDataStruct)a).get_OId().toString();
                    String boid = ((CoreDataStruct)b).get_OId().toString();
                    boolean equals = aoid.equals(boid);
                    return equals;
                }
                if (a instanceof BigDecimal && b instanceof CoreDataStruct) {
                    return ((CoreDataStruct)b).get_OId().toString().equals(a.toString());
                }
                return a.equals(b);
            }
            case 2: {
                return !QueryBuilder.compare(a, b, EQUAL);
            }
            case 5: {
                return !QueryBuilder.compare(a, b, LESS_THAN_OR_EQUAL);
            }
            case 6: {
                return !QueryBuilder.compare(a, b, LESS_THAN);
            }
            case 3: 
            case 4: {
                if (null == a || null == b) {
                    return false;
                }
                if (a instanceof String) {
                    int x;
                    String aStr = (String)a;
                    String bStr = null;
                    if (!(b instanceof String)) {
                        bStr = b.toString();
                    }
                    return -1 == (x = aStr.compareTo(bStr)) || 0 == x && 4 == op;
                }
                if (a instanceof java.util.Date) {
                    if (!(b instanceof java.util.Date)) {
                        throw new QueryException("Second arg for " + cmp_op + " is not a Date");
                    }
                    java.util.Date ad = (java.util.Date)a;
                    java.util.Date bd = (java.util.Date)b;
                    return ad.before(bd) || ad.equals(bd) && 4 == op;
                }
                if (a instanceof BigDecimal) {
                    if (!(b instanceof BigDecimal)) {
                        throw new QueryException("First arg for " + cmp_op + " is BigDecimal, but second arg is not.");
                    }
                    int x = ((BigDecimal)a).compareTo((BigDecimal)b);
                    return -1 == x || 0 == x && 4 == op;
                }
                if (a instanceof Number) {
                    double bd;
                    if (!(b instanceof Number)) {
                        throw new QueryException("First arg for " + cmp_op + " is Number, but second arg is not.");
                    }
                    double ad = ((Number)a).doubleValue();
                    return ad < (bd = ((Number)b).doubleValue()) || ad == bd && 4 == op;
                }
                throw new QueryException("Comparison operator " + cmp_op + " not supported for objects of type " + a.getClass().getName());
            }
            case 15: {
                if (null == a && null == b) {
                    return true;
                }
                if (null == a || null == b) {
                    return false;
                }
                String aStr = (String)a;
                String bStr = (String)b;
                return aStr.equalsIgnoreCase(bStr);
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                if (!(a instanceof String)) {
                    throw new QueryException("First arg for " + cmp_op + " is not a string.");
                }
                if (!(b instanceof String)) {
                    throw new QueryException("Second arg for " + cmp_op + " is not a string.");
                }
                String as = (String)a;
                String bs = (String)b;
                if (-1 != cmp_op.indexOf(120)) {
                    as = as.toLowerCase();
                    bs = bs.toLowerCase();
                }
                switch (op) {
                    case 9: 
                    case 10: {
                        return -1 != as.indexOf(bs);
                    }
                    case 11: 
                    case 12: {
                        return as.startsWith(bs);
                    }
                    case 13: 
                    case 14: {
                        return as.endsWith(bs);
                    }
                }
                throw new QueryException("QueryBuilder.compare bug in CASE_ processing");
            }
        }
        throw new QueryException("Unchecked comparison operator: " + cmp_op);
    }

    public void setSelectClause(String newClause) {
        this.selectClause = newClause;
    }

    public String getSelectClause() {
        return this.selectClause;
    }

    public void setCurrentFetchSize(int iCurrentFetchSizeIn) {
        this.iCurrentFetchSize = iCurrentFetchSizeIn;
    }

    public int getCurrentFetchSize() {
        return this.iCurrentFetchSize;
    }

    public static void setDefaultFetchSize(int iDefaultFetchSizeIn) {
        iDefaultFetchSize = iDefaultFetchSizeIn;
    }

    public static int getDefaultFetchSize() {
        return iDefaultFetchSize;
    }

    public static void setDefaultQueryTimeout(int iQueryTimeout) {
        iDefaultQueryTimeout = iQueryTimeout;
    }

    public static int getDefaultQueryTimeout() {
        return iDefaultQueryTimeout;
    }

    public int getCurrentQueryTimeout() {
        return this.iCurrentQueryTimeout;
    }

    public void setCurrentQueryTimeout(int iQueryTimeoutIn) {
        this.iCurrentQueryTimeout = iQueryTimeoutIn;
    }

    public static synchronized String getCountX() {
        countX = countX < Long.MAX_VALUE ? ++countX : 0L;
        return "cursorID" + Long.toString(countX);
    }

    private boolean doSetFetchSize(DBConnection conn) {
        boolean disableFetchSizeWithMaxRows;
        try {
            disableFetchSizeWithMaxRows = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(conn.getDatabaseName())).getDisableFetchSizeWithMaxRows();
        }
        catch (DatabaseManagerException e) {
            DODS.getLogChannel().write(7, "Error unknown logical database. Using default value for 'DisableFetchSizeWithMaxRows' parameter");
            disableFetchSizeWithMaxRows = false;
        }
        return !(disableFetchSizeWithMaxRows & this.maxRows > 0);
    }

    private boolean doCursorName(DBConnection conn) {
        boolean cursorName;
        if (!this.doSetFetchSize(conn)) {
            return false;
        }
        try {
            cursorName = ((StandardLogicalDatabase)DODS.getDatabaseManager().findLogicalDatabase(conn.getDatabaseName())).getUseCursorName();
        }
        catch (DatabaseManagerException e) {
            DODS.getLogChannel().write(7, "Error unknown logical database. Using default value for 'UseCursorName' parameter");
            cursorName = true;
        }
        return cursorName;
    }

    public void setCursorType(int resultSetType, int resultSetConcurrency) {
        this.iResultSetConcurrency = resultSetConcurrency;
        this.iResultSetType = resultSetType;
    }

    static {
        cmp_ops.put(EQUAL, new Integer(1));
        cmp_ops.put(NOT_EQUAL, new Integer(2));
        cmp_ops.put(LESS_THAN, new Integer(3));
        cmp_ops.put(LESS_THAN_OR_EQUAL, new Integer(4));
        cmp_ops.put(GREATER_THAN, new Integer(5));
        cmp_ops.put(GREATER_THAN_OR_EQUAL, new Integer(6));
        cmp_ops.put(IS_NULL, new Integer(7));
        cmp_ops.put(IS_NOT_NULL, new Integer(8));
        cmp_ops.put(CASE_SENSITIVE_CONTAINS, new Integer(9));
        cmp_ops.put(CASE_INSENSITIVE_CONTAINS, new Integer(10));
        cmp_ops.put(CASE_SENSITIVE_STARTS_WITH, new Integer(11));
        cmp_ops.put(CASE_INSENSITIVE_STARTS_WITH, new Integer(12));
        cmp_ops.put(CASE_SENSITIVE_ENDS_WITH, new Integer(13));
        cmp_ops.put(CASE_INSENSITIVE_ENDS_WITH, new Integer(14));
        cmp_ops.put(CASE_INSENSITIVE_EQUAL, new Integer(15));
        countX = 0L;
    }
}

