/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql.standard;

import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.LogicalDatabase;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdAllocationError;
import com.lutris.appserver.server.sql.ObjectIdAllocator;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.KeywordValueException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.enhydra.dods.DODS;

public class StandardObjectIdAllocator
implements ObjectIdAllocator {
    private ObjectId max = null;
    private ObjectId current = null;
    private ObjectId next = null;
    private long cacheSize = 1024L;
    private boolean columnWithPrefix = false;
    private String oidTableName = "objectid";
    private String nextColumnName = "next";
    private String oidMinValue = "0";
    private LogicalDatabase logicalDatabase = null;
    private String primaryLogicalDatabaseName = null;
    private static final int LOG_THRESHOLD = 100;

    protected StandardObjectIdAllocator(LogicalDatabase lDb, Config objIdConfig) throws ConfigException {
        try {
            this.primaryLogicalDatabaseName = objIdConfig.getString("PrimaryLogicalDatabase", lDb.getName());
            this.cacheSize = objIdConfig.getInt("CacheSize", 1024);
            this.oidMinValue = objIdConfig.getString("MinValue", "10000000000000000");
            this.columnWithPrefix = objIdConfig.getBoolean("NextWithPrefix", false);
            this.oidTableName = objIdConfig.getString("OidTableName", "objectid");
            this.nextColumnName = objIdConfig.getString("NextColumnName", "next");
        }
        catch (KeywordValueException except) {
            throw new ConfigException("Bad DatabaseManager.DB." + this.primaryLogicalDatabaseName + ".ObjectId section defined in config file.");
        }
    }

    @Override
    public synchronized void checkOId(ObjectId oid) throws ObjectIdException {
        BigDecimal bdNext;
        if (oid == null) {
            throw new ObjectIdException("Object id is null");
        }
        BigDecimal min = new BigDecimal(new BigInteger(this.oidMinValue));
        BigDecimal id = new BigDecimal(oid.toString());
        if (id.compareTo(min) == -1) {
            throw new ObjectIdException("Object id out of range");
        }
        if (this.next == null || this.max == null) {
            this.updateCache();
        }
        if (id.compareTo(bdNext = new BigDecimal(this.next.toString())) == 0 || id.compareTo(bdNext) == 1) {
            throw new ObjectIdException("Object id out of range");
        }
    }

    @Override
    public synchronized ObjectId allocate() {
        try {
            if (this.next == null || this.max == null || this.next.equals(this.max)) {
                this.updateCache();
            }
            this.current = this.next;
            this.next = this.next.increment();
            return this.current;
        }
        catch (Exception e) {
            throw new ObjectIdAllocationError("ObjectIdAllocator: \nFailed to allocate object id.  Caused by: \n" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateCache() {
        String OID_TABLE = this.oidTableName;
        DBConnection conn = null;
        try {
            boolean tryAgain = false;
            int tryCount = 0;
            conn = this.allocateConnection();
            conn.setAutoCommit(false);
            do {
                BigDecimal dbNext;
                ResultSet rs;
                if (!(rs = conn.executeQuery("select * from " + OID_TABLE)).next()) {
                    conn.executeUpdate("insert into " + OID_TABLE + " values(" + this.oidMinValue + ")");
                    dbNext = new BigDecimal(this.oidMinValue);
                } else {
                    dbNext = rs.getBigDecimal(this.nextColumnName);
                }
                rs.close();
                this.next = new ObjectId(dbNext);
                BigDecimal dbLast = dbNext;
                dbNext = dbNext.add(BigDecimal.valueOf(this.cacheSize));
                String sql = "update " + OID_TABLE + " ";
                sql = !this.columnWithPrefix ? sql + "set " + this.nextColumnName + " = ? where " + this.nextColumnName + "= ?" : sql + "set " + OID_TABLE + "." + this.nextColumnName + " = ? where " + OID_TABLE + "." + this.nextColumnName + " = ?";
                PreparedStatement stmt = conn.prepareStatement(sql);
                stmt.setBigDecimal(1, dbNext);
                stmt.setBigDecimal(2, dbLast);
                if (conn.executeUpdate(stmt, sql) < 1) {
                    tryAgain = true;
                    if (++tryCount >= 100) {
                        DODS.getLogChannel().write(0, "ObjectIdAllocator: \n  Failed to allocate object ids.\n  Trying again....");
                    }
                    conn.rollback();
                    conn.reset();
                    conn.setAutoCommit(false);
                    if (tryCount < 50) continue;
                    DODS.getLogChannel().write(0, "ObjectIdAllocator: \n  Failed to allocate object ids.\n  Tried 50 times.  Giving up.");
                    throw new ObjectIdAllocationError("Failed to allocate object id.\nTried 50 times.  Giving up.");
                }
                tryAgain = false;
                this.max = new ObjectId(dbNext);
                conn.commit();
                if (tryCount < 100) continue;
                DODS.getLogChannel().write(0, "ObjectIdAllocator: \n  Succeeded in allocating object ids.\n  Continuing...");
            } while (tryAgain);
            return;
        }
        catch (SQLException sqlExcept) {
            this.max = this.next;
            DODS.getLogChannel().write(0, "ObjectIdAllocator: \n  Failed to allocate object ids.  Giving up!\n    SQLState = " + sqlExcept.getSQLState() + "\n    SQLError = " + sqlExcept.getErrorCode() + "\n    SQLMsg   = " + sqlExcept.getMessage());
            if (conn == null) throw new ObjectIdAllocationError("ObjectIdAllocator: \n  Failed to allocate object id.  Caused by SQLException:\n    SQLState = " + sqlExcept.getSQLState() + "\n    SQLError = " + sqlExcept.getErrorCode() + "\n    SQLMsg   = " + sqlExcept.getMessage());
            try {
                conn.rollback();
            }
            catch (SQLException rollbackExcept) {
                DODS.getLogChannel().write(0, "ObjectIdAllocator: \n  Failed to rollback transaction.\n    SQLState = " + rollbackExcept.getSQLState() + "\n    SQLError = " + rollbackExcept.getErrorCode() + "\n    SQLMsg   = " + rollbackExcept.getMessage());
            }
            if (conn.handleException(sqlExcept)) throw new ObjectIdAllocationError("ObjectIdAllocator: \n  Failed to allocate object id.  Caused by SQLException:\n    SQLState = " + sqlExcept.getSQLState() + "\n    SQLError = " + sqlExcept.getErrorCode() + "\n    SQLMsg   = " + sqlExcept.getMessage());
            conn = null;
            throw new ObjectIdAllocationError("ObjectIdAllocator: \n  Failed to allocate object id.  Caused by SQLException:\n    SQLState = " + sqlExcept.getSQLState() + "\n    SQLError = " + sqlExcept.getErrorCode() + "\n    SQLMsg   = " + sqlExcept.getMessage());
        }
        catch (ObjectIdException oidEx) {
            throw new ObjectIdAllocationError("ObjectIdAllocator: \nFailed to allocate object id.  Caused by: \n" + oidEx.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.reset();
                }
                catch (SQLException sqlExcept) {
                    DODS.getLogChannel().write(0, "ObjectIdAllocator: \n  Failed to reset connection.\n    SQLState = " + sqlExcept.getSQLState() + "\n    SQLError = " + sqlExcept.getErrorCode() + "\n    SQLMsg   = " + sqlExcept.getMessage());
                }
                finally {
                    conn.release();
                }
            }
        }
    }

    private DBConnection allocateConnection() throws SQLException {
        if (this.logicalDatabase == null) {
            try {
                this.logicalDatabase = DODS.getDatabaseManager().findLogicalDatabase(this.primaryLogicalDatabaseName);
            }
            catch (DatabaseManagerException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
        return this.logicalDatabase.allocateConnection();
    }
}

