/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql.standard;

import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBQuery;
import com.lutris.appserver.server.sql.ExtendedQuery;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.appserver.server.sql.Query;
import com.lutris.util.FatalExceptionError;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.enhydra.dods.DODS;

public class StandardDBQuery
implements DBQuery {
    private int id = nextId++;
    private static int nextId;
    private DBConnection conn;
    private ResultSet resultSet = null;
    private Query queryInterface = null;
    private boolean released = false;
    private boolean releaseConnection = true;

    protected StandardDBQuery(DBConnection dbConnection) throws SQLException {
        this.logDebug("new instance");
        this.conn = dbConnection;
    }

    public synchronized void query(Query q) throws SQLException {
        this.logDebug("execute query");
        this.validate();
        this.conn.incrRequestCount();
        this.queryInterface = q;
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
            this.resultSet = this.queryInterface.executeQuery(this.conn);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    public Object next() throws SQLException, ObjectIdException {
        this.logDebug("get next result");
        this.validate();
        try {
            return this.queryInterface.next(this.resultSet);
        }
        catch (SQLException e) {
            this.handleException(e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void release() {
        this.logDebug("release");
        try {
            this.validate();
        }
        catch (SQLException except) {
            throw new FatalExceptionError((Exception)except);
        }
        try {
            Object sqlEx = null;
            try {
                PreparedStatement stmt = null;
                try {
                    if (this.resultSet != null) {
                        this.resultSet.close();
                    }
                }
                catch (SQLException sqle) {
                    this.logDebug(sqle.toString());
                }
                stmt = ((ExtendedQuery)this.queryInterface).getStatement();
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                this.conn.handleException(e);
            }
            try {
                if (this.releaseConnection) {
                    this.conn.reset();
                }
            }
            catch (SQLException e) {
                this.conn.handleException(e);
            }
            if (this.releaseConnection) {
                this.conn.release();
            }
        }
        finally {
            this.released = true;
            this.resultSet = null;
            this.queryInterface = null;
            this.conn = null;
        }
    }

    public synchronized boolean handleException(SQLException e) {
        this.logDebug("handle exception");
        return this.conn.handleException(e);
    }

    public void validate() throws SQLException {
        if (this.released) {
            throw new SQLException("Cannot access this object once it has been released.");
        }
    }

    protected void finalize() {
        if (!this.released) {
            this.release();
        }
    }

    protected void logDebug(String str) {
        DODS.getDatabaseManager();
    }

    protected void setReleaseConnection(boolean rc) {
        this.releaseConnection = rc;
    }
}

