/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql;

import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBQuery;
import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManager;
import com.lutris.appserver.server.sql.DatabaseManagerConfiguration;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.LogicalDatabase;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.appserver.server.sql.standard.DriverSpecificConstants;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.classloader.MultiClassLoader;
import com.lutris.dods.builder.generator.query.QueryBuilder;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.ConfigFile;
import com.lutris.util.KeywordValueException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.enhydra.dods.Common;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.CacheConstants;
import org.enhydra.dods.cache.Wrapper;
import org.enhydra.util.ConfigFileInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StandardDatabaseManager
implements DatabaseManager,
CacheConstants,
DriverSpecificConstants {
    private Hashtable logicalDatabases = new Hashtable();
    private LogicalDatabase defaultLogicalDatabase = null;
    protected boolean debug = false;
    protected String defaultDB = null;
    protected Config config = null;
    protected String confDir = null;
    private String appName = CacheConstants.DEFAULT_APP_NAME;
    private DatabaseManagerConfiguration dbmConf = new DatabaseManagerConfiguration();
    private Config mainConfig = null;
    boolean isDODSConfigured = false;
    boolean mustConfigureDODS = false;

    public StandardDatabaseManager(Config config) throws ConfigException, DatabaseManagerException, SQLException {
        String versionColumnName;
        Config defaultsConfig;
        this.config = config;
        String[] databases = config.getStrings("Databases");
        if (databases == null) {
            return;
        }
        try {
            this.confDir = config.getString("ConfigurationDir", null);
        }
        catch (KeywordValueException except) {
            this.confDir = null;
        }
        try {
            this.appName = config.getString("AppName", DEFAULT_APP_NAME);
        }
        catch (KeywordValueException except) {
            this.appName = DEFAULT_APP_NAME;
        }
        Common.setConfigDir(this.confDir);
        try {
            Config userConfig = (Config)config.getSection("DB.User");
            if (userConfig != null) {
                String value = userConfig.getString("userWildcard");
                if (value != null) {
                    this.dbmConf.setUserConfigWildcard(value);
                }
                if ((value = userConfig.getString("userSingleWildcard")) != null) {
                    this.dbmConf.setUserConfigSingleWildcard(value);
                }
                if ((value = userConfig.getString("userSingleWildcardEscape")) != null) {
                    this.dbmConf.setUserConfigSingleWildcardEscape(value);
                }
                if ((value = userConfig.getString("userWildcardEscape")) != null) {
                    this.dbmConf.setUserConfigWildcardEscape(value);
                }
            }
        }
        catch (Exception userConfig) {
            // empty catch block
        }
        try {
            defaultsConfig = (Config)config.getSection("defaults");
        }
        catch (KeywordValueException except) {
            throw new ConfigException("No DatabaseManager.defaults defined in config file.");
        }
        if (defaultsConfig != null) {
            this.dbmConf.setAllReadOnly(defaultsConfig.getBoolean("AllReadOnly", false));
            this.dbmConf.setLazyLoading(defaultsConfig.getBoolean("lazyLoading", false));
            this.dbmConf.setCaseSensitive(defaultsConfig.getBoolean("CaseSensitive", false));
            this.dbmConf.setMaxExecuteTime(defaultsConfig.getInt("maxExecuteTime", 0));
            this.dbmConf.setTransactionCheck(defaultsConfig.getBoolean("TransactionCheck", false));
            this.dbmConf.setDeleteCheckVersion(defaultsConfig.getBoolean("DeleteCheckVersion", false));
            this.dbmConf.setAutoSave(defaultsConfig.getBoolean("AutoSave", false));
            this.dbmConf.setAutoSaveCreateVirgin(defaultsConfig.getBoolean("AutoSaveCreateVirgin", false));
            this.dbmConf.setAutoWrite(defaultsConfig.getBoolean("AutoWrite", false));
            this.dbmConf.setTransactionCaches(defaultsConfig.getBoolean("TransactionCaches", false));
            this.dbmConf.setDeadlockWaitTime(defaultsConfig.getInt("CacheLockTimeout", 0));
            this.dbmConf.setDeadlockRetryCount(defaultsConfig.getInt("CacheLockRetryCount", 0));
            QueryBuilder.setDefaultQueryTimeout(config.getInt("QueryTimeout", 0));
            this.dbmConf.setQueryTimeout(defaultsConfig.getInt("QueryTimeout", 0));
            this.dbmConf.setSelectOids(defaultsConfig.getBoolean("SelectOids", false));
            this.dbmConf.setIncrementVersions(defaultsConfig.getBoolean("IncrementVersions", true));
            QueryBuilder.setDefaultFetchSize(config.getInt("DefaultFetchSize", -1));
            this.dbmConf.setDefaultFetchSize(defaultsConfig.getInt("DefaultFetchSize", -1));
            this.dbmConf.setDBTransactionFactoryName(defaultsConfig.getString("TransactionFactory", null));
            this.dbmConf.setConnectionAllocatorName(defaultsConfig.getString("ConnectionAllocator", null));
            this.dbmConf.setDBConnectionFactoryName(defaultsConfig.getString("ConnectionFactory", null));
            this.dbmConf.setQueryCacheImplClass(defaultsConfig.getString("QueryCacheImplClass", null));
            this.dbmConf.setFullCacheCountLimit(defaultsConfig.getInt("FullCacheCountLimit", -1));
            this.dbmConf.setCaseInsensitiveDatabase(defaultsConfig.getBoolean("CaseInsensitiveDatabase", false));
            this.dbmConf.setXaDefaultTimeout(defaultsConfig.getInt("XADefaultTimeout", 120));
            this.dbmConf.setXaTransactonManagerLookupName(defaultsConfig.getString("XATransactonManagerLookupName", "java:comp/UserTransaction"));
            this.dbmConf.setXaUsageCase(defaultsConfig.getInt("XAUsageCase", 0));
            this.dbmConf.setXaWrappedTransImplFactory(defaultsConfig.getString("XAWrappedTransImplFactory", "com.lutris.appserver.server.sql.standard.StandardDBTransactionFactory"));
            this.dbmConf.setXaUserTransactonLookupName(defaultsConfig.getString("XaUserTransactonLookupName", "java:comp/UserTransaction"));
            this.dbmConf.setXaJtaSupport(defaultsConfig.getString("JTASupport", "REQUIRED"));
            try {
                this.dbmConf.setUseCursorName(defaultsConfig.getBoolean("UseCursorName"));
            }
            catch (ConfigException e) {
                this.dbmConf.setUseCursorName(null);
            }
            this.dbmConf.setInitCachesResultSetType(defaultsConfig.getString("InitCachesResultSetType", null));
            this.dbmConf.setInitCachesResultSetConcurrency(defaultsConfig.getString("InitCachesResultSetConcurrency", null));
            this.dbmConf.setSqlBatch(defaultsConfig.getBoolean("SQLBatch", false));
            try {
                this.dbmConf.setQueryTimeLimit(new Integer(defaultsConfig.getInt("QueryTimeLimit")));
            }
            catch (ConfigException e) {
                this.dbmConf.setQueryTimeLimit(null);
            }
        }
        try {
            defaultsConfig = (Config)config.getSection("defaults.cache");
        }
        catch (KeywordValueException except) {
            throw new ConfigException("No DatabaseManager.defaults defined in config file.");
        }
        if (defaultsConfig != null) {
            this.dbmConf.setReserveFactor(defaultsConfig.getDouble("reserveFactor", 0.0));
            this.dbmConf.setCachePercentage(defaultsConfig.getDouble("CachePercentage", -1.0));
            this.dbmConf.setMaxCacheSize(defaultsConfig.getInt("maxCacheSize", 0));
            this.dbmConf.setMaxSimpleCacheSize(defaultsConfig.getInt("maxSimpleCacheSize", 0));
            this.dbmConf.setMaxComplexCacheSize(defaultsConfig.getInt("maxComplexCacheSize", 0));
            this.dbmConf.setMaxMultiJoinCacheSize(defaultsConfig.getInt("maxMultiJoinCacheSize", 0));
            this.dbmConf.setInitAllCaches(defaultsConfig.getBoolean("initAllCaches", false));
            this.dbmConf.setInitialCacheFetchSize(defaultsConfig.getInt("InitialCacheFetchSize", 0));
            this.dbmConf.setInitialDSCacheSize(defaultsConfig.getInt("InitialDSCacheSize", -1));
            this.dbmConf.setDodsCacheFactory(defaultsConfig.getString("DODSCacheFactory", "org.enhydra.dods.cache.lru.DODSLRUCacheFactory"));
        }
        this.isDODSConfigured = null != System.getProperty("DODS_HOME", null) || null != config.getString("ConfigurationDir", null);
        this.mustConfigureDODS = false;
        for (int idx = 0; idx < databases.length; ++idx) {
            Config dbConfig;
            String dbName = databases[idx];
            try {
                dbConfig = (Config)config.getSection("DB." + dbName);
            }
            catch (KeywordValueException except) {
                throw new ConfigException("No DatabaseManager.DB." + dbName + " defined in config file.");
            }
            if (this.logicalDatabases.get(dbName) != null) {
                throw new DatabaseManagerException("duplicate logical database name: \"" + dbName + "\"");
            }
            LogicalDatabase logicalDatabase = this.loadLogicalDatabase(dbName, dbConfig);
            this.logicalDatabases.put(dbName, logicalDatabase);
        }
        this.defaultDB = config.getString("DefaultDatabase", databases[0]);
        this.setDefaultDatabase(this.defaultDB);
        boolean debugLogging = config.getBoolean("Debug", false);
        this.setDebugLogging(debugLogging);
        Wrapper.getInstance().setTimeout(config.getLong("MainCacheLockTimeout", 100L));
        String oidColumnName = config.getString("ObjectIdColumnName", null);
        if (oidColumnName != null) {
            CoreDO.set_OIdColumnName(oidColumnName);
        }
        if ((versionColumnName = config.getString("VersionColumnName", null)) != null) {
            CoreDO.set_versionColumnName(versionColumnName);
        }
        if (this.mainConfig == null) {
            ConfigFileInterface mainConfigFile = null;
            if (config != null) {
                mainConfigFile = config.getConfigFile();
            }
            if (mainConfigFile != null) {
                this.mainConfig = mainConfigFile.getConfig();
            }
        }
    }

    public void initChaches(ClassLoader clsLoader) {
        try {
            this.initAllDodsCaches(this.config, clsLoader);
        }
        catch (Exception e) {
            DODS.getLogChannel().write(7, "Unable to load caches at startup");
        }
    }

    public static DatabaseManager newInstance(URL confURL, String confFile) throws ConfigException, DatabaseManagerException, SQLException {
        try {
            InputStream configIS = Common.getConfFileFromURL(confURL, confFile);
            ConfigFile configFile = new ConfigFile(configIS);
            Config config = configFile.getConfig();
            configIS.close();
            Config dbConfig = new Config(config.getSection("DatabaseManager"), (ConfigFileInterface)configFile);
            return new StandardDatabaseManager(dbConfig);
        }
        catch (Exception e) {
            throw new ConfigException((Throwable)e);
        }
    }

    public static DatabaseManager newInstance(String fileName) throws ConfigException, DatabaseManagerException, SQLException {
        try {
            Config config = null;
            ConfigFile configFile = null;
            if (fileName != null) {
                try {
                    File inputFile = new File(fileName);
                    if (inputFile != null && inputFile.isFile()) {
                        configFile = new ConfigFile(inputFile);
                        config = configFile.getConfig();
                    }
                }
                catch (Exception e) {
                    System.out.println("Error during configuration file reading: '" + fileName + "'");
                }
            }
            if (config == null) {
                InputStream configIS = Common.getConfFileFromURL(null, null);
                configFile = new ConfigFile(configIS);
                config = configFile.getConfig();
                configIS.close();
            }
            if (config == null) {
                throw new Exception("Can't create configuration object from file:'" + fileName + "'");
            }
            Config dbConfig = new Config(config.getSection("DatabaseManager"), (ConfigFileInterface)configFile);
            return new StandardDatabaseManager(dbConfig);
        }
        catch (Exception e) {
            throw new ConfigException((Throwable)e);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public Config getParentConfig() {
        return this.mainConfig;
    }

    public LogicalDatabase loadLogicalDatabase(String dbName, Config dbConfig) throws DatabaseManagerException {
        StandardLogicalDatabase lDB = null;
        try {
            if (this.mustConfigureDODS && !this.isDODSConfigured) {
                throw new DatabaseManagerException("DODS is not configured properly.");
            }
            if (this.isDODSConfigured) {
                String dbClassName = dbConfig.getString("ClassType", "Standard");
                String classPath = Common.getDodsConfProperty("ClassPath", dbClassName);
                String className = Common.getDodsConfProperty("ClassName", dbClassName);
                if (classPath != null && className != null) {
                    MultiClassLoader loader = new MultiClassLoader(null);
                    loader.setClassPath(classPath);
                    Class dbClass = loader.loadClass(className);
                    lDB = (LogicalDatabase)dbClass.newInstance();
                    lDB.init(dbName, dbConfig);
                }
            }
            if (lDB == null) {
                lDB = new StandardLogicalDatabase(dbName, dbConfig, this.dbmConf);
            }
        }
        catch (Exception except) {
            throw new DatabaseManagerException("Could not create logical database " + dbName, (Throwable)except);
        }
        return lDB;
    }

    public String getDefaultDB() {
        return this.defaultDB;
    }

    public DBConnection allocateConnection(String dbName) throws DatabaseManagerException, SQLException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        return logicalDatabase.allocateConnection();
    }

    public DBConnection allocateConnection() throws DatabaseManagerException, SQLException {
        if (this.defaultLogicalDatabase == null) {
            throw new DatabaseManagerException("Default logical database has not been specified.");
        }
        return this.defaultLogicalDatabase.allocateConnection();
    }

    public ObjectId allocateObjectId(String dbName) throws DatabaseManagerException, ObjectIdException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        return logicalDatabase.allocateObjectId();
    }

    public ObjectId allocateObjectId() throws DatabaseManagerException, ObjectIdException {
        if (this.defaultLogicalDatabase == null) {
            throw new DatabaseManagerException("Default logical database has not been specified.");
        }
        return this.defaultLogicalDatabase.allocateObjectId();
    }

    public void checkOId(String dbName, ObjectId oid) throws DatabaseManagerException, ObjectIdException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        logicalDatabase.checkOId(oid);
    }

    public void checkOId(ObjectId oid) throws DatabaseManagerException, ObjectIdException {
        if (this.defaultLogicalDatabase == null) {
            throw new DatabaseManagerException("Default logical database has not been specified.");
        }
        this.defaultLogicalDatabase.checkOId(oid);
    }

    public DBTransaction createTransaction(String dbName) throws DatabaseManagerException, SQLException {
        if (dbName == null) {
            return this.createTransaction();
        }
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        DBTransaction ret = logicalDatabase.createTransaction();
        ret.setDatabaseName(dbName);
        return ret;
    }

    public DBTransaction createTransaction() throws DatabaseManagerException, SQLException {
        if (this.defaultLogicalDatabase == null) {
            throw new DatabaseManagerException("Default logical database has not been specified.");
        }
        DBTransaction ret = this.defaultLogicalDatabase.createTransaction();
        ret.setDatabaseName(this.defaultDB);
        return ret;
    }

    public DBQuery createQuery(String dbName) throws DatabaseManagerException, SQLException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        return logicalDatabase.createQuery();
    }

    public DBQuery createQuery() throws DatabaseManagerException, SQLException {
        if (this.defaultLogicalDatabase == null) {
            throw new DatabaseManagerException("Default logical database has not been specified.");
        }
        return this.defaultLogicalDatabase.createQuery();
    }

    public String logicalDatabaseType(String dbName) throws DatabaseManagerException, SQLException {
        LogicalDatabase logicalDatabase = null;
        if (dbName != null) {
            logicalDatabase = this.findLogicalDatabase(dbName);
            return logicalDatabase.getType();
        }
        return this.logicalDatabaseType();
    }

    public String logicalDatabaseType() throws DatabaseManagerException, SQLException {
        if (this.defaultLogicalDatabase == null) {
            throw new DatabaseManagerException("Default logical database has not been specified.");
        }
        return this.defaultLogicalDatabase.getType();
    }

    public LogicalDatabase findLogicalDatabase(String dbName) throws DatabaseManagerException {
        LogicalDatabase logicalDatabase = (LogicalDatabase)this.logicalDatabases.get(dbName);
        if (logicalDatabase == null) {
            throw new DatabaseManagerException("unknown logical database name: \"" + dbName + "\"");
        }
        return logicalDatabase;
    }

    public void setDefaultDatabase(String dbName) throws DatabaseManagerException {
        this.defaultLogicalDatabase = this.findLogicalDatabase(dbName);
    }

    public void shutdown() {
        Enumeration keys = this.logicalDatabases.keys();
        while (keys.hasMoreElements()) {
            LogicalDatabase logicalDatabase = (LogicalDatabase)this.logicalDatabases.get((String)keys.nextElement());
            logicalDatabase.shutdown();
        }
    }

    public String[] getLogicalDatabaseNames() {
        String[] names = new String[this.logicalDatabases.size()];
        int idx = 0;
        Enumeration keys = this.logicalDatabases.keys();
        while (keys.hasMoreElements()) {
            names[idx++] = (String)keys.nextElement();
        }
        return names;
    }

    public String getType(String dbName) throws DatabaseManagerException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        return logicalDatabase.getType();
    }

    public long getRequestCount(String dbName) throws DatabaseManagerException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        return logicalDatabase.getRequestCount();
    }

    public int getActiveConnectionCount(String dbName) throws DatabaseManagerException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        return logicalDatabase.getActiveConnectionCount();
    }

    public int getMaxConnectionCount(String dbName) throws DatabaseManagerException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        return logicalDatabase.getMaxConnectionCount();
    }

    public Date getMaxConnectionCountDate(String dbName) throws DatabaseManagerException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        return logicalDatabase.getMaxConnectionCountDate();
    }

    public void resetMaxConnectionCount(String dbName) throws DatabaseManagerException {
        LogicalDatabase logicalDatabase = this.findLogicalDatabase(dbName);
        logicalDatabase.resetMaxConnectionCount();
    }

    public void setDebugLogging(boolean condition) {
        this.debug = condition;
    }

    public boolean getAllReadOnly() {
        return this.dbmConf.isAllReadOnly();
    }

    public String getAppName() {
        return this.appName;
    }

    public DatabaseManagerConfiguration getDatabaseManagerConfiguration() {
        return this.dbmConf;
    }

    private void initDatabaseCaches(Config dbConfig, String fileName, ClassLoader cls) {
        String tablesXmlFile = null;
        try {
            tablesXmlFile = dbConfig.getString("ClassList", fileName);
        }
        catch (ConfigException configException) {
            // empty catch block
        }
        InputStream tablesList = null;
        tablesList = tablesXmlFile != null ? this.getTablesXML(tablesXmlFile, cls) : this.getTablesXML(null, cls);
        if (tablesList != null) {
            this.initCaches(tablesList, cls);
        }
    }

    public void initAllDodsCaches(Config config, ClassLoader cls) {
        Config dbConfig = null;
        String[] databases = null;
        String tablesXmlFile = null;
        try {
            databases = config.getStrings("Databases");
            tablesXmlFile = config.getString("ClassList", (String)null);
        }
        catch (ConfigException e) {
            DODS.getLogChannel().write(7, "Unable to init caches: Error reading application configuation file");
        }
        if (databases != null) {
            for (int idx = 0; idx < databases.length; ++idx) {
                String dbName = databases[idx];
                try {
                    dbConfig = (Config)config.getSection("DB." + dbName);
                    this.initDatabaseCaches(dbConfig, tablesXmlFile, cls);
                    continue;
                }
                catch (Exception except) {
                    DODS.getLogChannel().write(7, "Unable to init caches for database: " + dbName);
                }
            }
        }
    }

    private InputStream getTablesXML(String fileName, ClassLoader cls) {
        InputStream res = null;
        if (fileName != null) {
            try {
                File tablesFile = new File(fileName);
                if (tablesFile.isFile()) {
                    res = new FileInputStream(fileName);
                }
            }
            catch (Exception e) {
                DODS.getLogChannel().write(7, "Unable to read table names from file: " + fileName);
            }
        } else {
            try {
                res = cls.getResourceAsStream("org/enhydra/dods/DODSClassList.xml");
            }
            catch (Exception e) {
                DODS.getLogChannel().write(7, "Unable to read table names from resources: org.enhydra.dods.DODSClassList.xml");
            }
        }
        return res;
    }

    private void initCaches(InputStream tablesList, ClassLoader cls) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(tablesList);
        }
        catch (Exception e) {
            DODS.getLogChannel().write(7, "Unable to parse xml file with cache initialisation tables list.");
        }
        if (doc != null) {
            NodeList classNodes = doc.getElementsByTagName("CLASS");
            for (int i = 0; i < classNodes.getLength(); ++i) {
                String className = ((Element)classNodes.item(i)).getAttribute("name");
                try {
                    Class<?> ce = cls.loadClass(className);
                    Method mth = ce.getMethod("getCacheDodsTableName", new Class[0]);
                    mth.invoke(null, new Object[0]);
                    continue;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    DODS.getLogChannel().write(7, "Unable to invoke caches for class: " + className);
                }
            }
        }
    }
}

