/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql;

import com.lutris.appserver.server.sql.CoreDataStruct;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBRowUpdateException;
import com.lutris.appserver.server.sql.ExtendedDBConnection;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.appserver.server.sql.Transaction;
import com.lutris.dods.builder.generator.query.DataObjectException;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class CoreDO
implements Transaction,
Serializable {
    private static boolean transactionCheck = false;
    private static boolean deleteCheckVersion = false;
    private static boolean autoSave = false;
    public static boolean versioning = true;
    protected boolean persistent = false;
    protected CoreDataStruct originalData = null;

    public static void disableVersioning() {
        versioning = false;
    }

    public CoreDO() {
        this.persistent = false;
    }

    public CoreDO(ResultSet rs) throws SQLException, ObjectIdException {
        this.persistent = true;
        this.set_OId(new ObjectId(rs.getBigDecimal(CoreDO.get_OIdColumnName())));
        if (versioning) {
            this.set_Version(rs.getInt(CoreDO.get_versionColumnName()));
        }
    }

    public static String get_OIdColumnName() {
        return CoreDataStruct.get_OIdColumnName();
    }

    public static String getOIdColumnName() {
        return CoreDO.get_OIdColumnName();
    }

    public static void set_OIdColumnName(String _oidColumnName) {
        CoreDataStruct.set_OIdColumnName(_oidColumnName);
    }

    public static void setOIdColumnName(String _oidColumnName) {
        CoreDO.set_OIdColumnName(_oidColumnName);
    }

    public static String get_versionColumnName() {
        return CoreDataStruct.get_versionColumnName();
    }

    public static String getVersionColumnName() {
        return CoreDO.get_versionColumnName();
    }

    public static void set_versionColumnName(String _versionColumnName) {
        CoreDataStruct.set_versionColumnName(_versionColumnName);
    }

    public static void setVersionColumnName(String _versionColumnName) {
        CoreDO.set_versionColumnName(_versionColumnName);
    }

    public ObjectId getOId() {
        return this.get_OId();
    }

    public ObjectId get_OId() {
        if (this.originalData != null) {
            return this.originalData.get_OId();
        }
        return null;
    }

    protected void setOId(ObjectId oId) {
        this.set_OId(oId);
    }

    protected void set_OId(ObjectId oId) {
        if (this.originalData != null) {
            this.originalData.set_OId(oId);
        }
    }

    protected void setVersion(int version) {
        this.set_Version(version);
    }

    protected void set_Version(int version) {
        if (this.originalData != null) {
            this.originalData.set_Version(version);
        }
    }

    protected int getVersion() {
        return this.get_Version();
    }

    protected int get_Version() {
        if (this.originalData != null) {
            return this.originalData.get_Version();
        }
        return 0;
    }

    protected void setNewVersion(int newVersion) {
        if (this.originalData != null) {
            this.originalData.newVersion = newVersion;
        }
    }

    protected void set_NewVersion(int newVersion) {
        if (this.originalData != null) {
            this.originalData.newVersion = newVersion;
        }
    }

    protected int getNewVersion() {
        if (this.originalData != null) {
            return this.originalData.newVersion;
        }
        return 0;
    }

    protected int get_NewVersion() {
        if (this.originalData != null) {
            return this.originalData.newVersion;
        }
        return 0;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public abstract PreparedStatement getInsertStatement(DBConnection var1) throws SQLException;

    public abstract PreparedStatement getUpdateStatement(DBConnection var1) throws SQLException;

    public abstract PreparedStatement getDeleteStatement(DBConnection var1) throws SQLException;

    public synchronized void executeInsert(DBConnection conn) throws SQLException, DBRowUpdateException {
        if (this.persistent) {
            this.executeUpdate(conn);
        } else {
            PreparedStatement stmt = this.getInsertStatement(conn);
            if (stmt != null) {
                try {
                    conn.executeUpdate(stmt, "executeInsert");
                }
                catch (SQLException e) {
                    throw e;
                }
                finally {
                    if (((ExtendedDBConnection)conn).getMaxPreparedStmts() == 0) {
                        stmt.close();
                    }
                }
            }
            this.persistent = true;
        }
    }

    public void finalizeInsert(boolean success) {
        this.persistent = success;
    }

    public synchronized void executeUpdate(DBConnection conn) throws SQLException, DBRowUpdateException {
        boolean mustUpdate = this.get_NewVersion() == this.get_Version();
        PreparedStatement stmt = this.getUpdateStatement(conn);
        if (stmt != null) {
            try {
                if (conn.executeUpdate(stmt, "execute update") == 0 && mustUpdate) {
                    stmt.close();
                    stmt = null;
                    this.seeWhatHappened(conn, "Update");
                }
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                if (((ExtendedDBConnection)conn).getMaxPreparedStmts() == 0 && stmt != null) {
                    stmt.close();
                }
            }
        }
    }

    private void seeWhatHappened(DBConnection conn, String action) throws SQLException, DBRowUpdateException {
        ResultSet rs = null;
        Statement stmt = null;
        try {
            try {
                String table = this.getTableName();
                stmt = conn.prepareStatement("select " + CoreDO.get_versionColumnName() + " from " + table + " where " + CoreDO.get_OIdColumnName() + " = " + this.get_OId());
                rs = stmt.executeQuery();
                if (!rs.next()) {
                    throw new DBRowUpdateException(action + " failed: Table " + table + " contains no row with id=" + this.get_OId());
                }
                int v = rs.getInt(1);
                if (this.get_Version() != v) {
                    throw new DBRowUpdateException(action + " failed: Table " + table + " id=" + this.get_OId() + " has version " + v + " where object has version " + this.get_Version() + (versioning ? "." : ", and versioning is disabled!"));
                }
                throw new SQLException(action + " failed, but Table " + table + " id=" + this.get_OId() + " does exist with version=" + v);
            }
            catch (DBRowUpdateException re) {
                throw re;
            }
            catch (SQLException se) {
                throw se;
            }
            catch (Exception e) {
                throw new SQLException("Error determining cause of update failure.", e.getMessage());
            }
        }
        catch (Throwable throwable) {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            throw throwable;
        }
    }

    protected String getTableName() throws SQLException {
        throw new SQLException("getTableName() not implemented. DO classes need to be regenerated");
    }

    public void finalizeUpdate(boolean success) {
    }

    public void executeDelete(DBConnection conn) throws SQLException {
        block9: {
            PreparedStatement stmt = this.getDeleteStatement(conn);
            if (stmt != null) {
                try {
                    if (conn.executeUpdate(stmt, "execute delete") != 0) break block9;
                    try {
                        stmt.close();
                        stmt = null;
                        this.seeWhatHappened(conn, "Delete");
                    }
                    catch (DBRowUpdateException de) {
                        SQLException sqle = new SQLException(de.toString());
                        throw sqle;
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                finally {
                    if (((ExtendedDBConnection)conn).getMaxPreparedStmts() == 0 && stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
    }

    public void finalizeDelete(boolean success) {
        if (this.persistent) {
            this.persistent = !success;
        }
    }

    public Object originalData_get() {
        return null;
    }

    public void updateCache() {
    }

    public void deleteFromCache() {
    }

    public void addToCache() {
    }

    public void evict() {
    }

    public void refresh() throws DataObjectException {
    }

    public int getOriginalVersion() {
        if (this.originalData != null) {
            return this.originalData.get_Version();
        }
        return 0;
    }

    public void makeVisible() {
    }

    public void makeInvisible() {
    }

    public void executeLockingStatement(DBConnection conn) throws SQLException {
    }

    public abstract void dumpData(boolean var1);
}

