
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 */
package org.enhydra.dods.cache;

import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.dods.builder.generator.dataobject.GenericDO;

/**
 * DOShell class maintains data for result (data objects and data handles). 
 *
 * @author    Tanja Jovanovic
 * @version   2.0  15.06.2003.
 */
public class DOShell {
    
    /**
     * Data object's handle.
     */
    public String  handle;
    
    /**
     * Data object.
     */
    public GenericDO dataObject = null;
    
    /**
     * Constructor (String).
     *
     * @param handle Data object's handle.
     */
    public DOShell(String  handle) {
        this.handle = handle;
    }
    
    /**
     * Constructor (GenericDO).
     *
     * @param object Data object.
     */
    public DOShell(GenericDO object) {
        try {
            this.handle = object.get_Handle();
            this.dataObject = object;
        } catch (DatabaseManagerException e) {}
    }
}
