
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 */
package org.enhydra.dods.cache;

/**
 * 
 * This class stores one condition declared in WHERE part of SELECT clause. 
 *
 * @author    Tanja Jovanovic
 * @version   2.0  15.06.2003.
 *
 */
public class Condition {

    /**
     * Column index in the table.
     */
    protected int columnIndex;
    
    /**
     * Value to which the column DO is compared against. 
     */
    protected Object  value;
    
    /**
     * Operator (relation) of the condition.
     */
     
    protected String  operator;
    
    /**
     * Constructor (int, Object, String).
     *
     * @param  colIndex Index of the column whose value will be compared.  
     * @param  value The value to compare against.
     * @param  oper Operator.
     */
    public Condition(int colIndex, Object  value, String  oper) {
        columnIndex = colIndex;
        this.value = value;
        operator = oper;
    }
    
    /**
     * Constructor (int, boolean, String).
     *
     * @param  colIndex Index of the column whose value will be compared.  
     * @param  value The boolean value to compare against.
     * @param  oper Operator.
     */
    public Condition(int colIndex, boolean value, String  oper) {
        columnIndex = colIndex;
        this.value = new Double (value ? 1 : 0);
        operator = oper;
    }
    
    /**
     * Constructor (int, double, String).
     *
     * @param  colIndex Index of the column whose value will be compared.  
     * @param  value The double value to compare against.
     * @param  oper Operator.
     */
    public Condition(int colIndex, double value, String  oper) {
        columnIndex = colIndex;
        this.value = new Double (value);
        operator = oper;
    }
 
    /**
     * Returns column index.
     *
     * @return Column index.
     */
    public int getColumnIndex() {
        return columnIndex;
    }

    /**
     * Returns column value.
     *
     * @return Column value.
     */
    public Object  getValue() {
        return value;
    }

    /**
     * Returns operator.
     *
     * @return Operator.
     */
    public String  getOperator() {
        return operator;
    }
}
