
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: ColumnTypeException.java,v 1.1 2004/09/03 13:42:38 sinisa Exp $
 */
package com.lutris.dods.builder.generator.query;

/**
 * ColumnTypeException is thrown by RDBColumnValue.get methods
 * when a column value is of an unexpected type.
 *
 * Application developers should treat ColumnTypeException like 
 * other ChainedException objects.
 * ColumnTypeExceptions usually indicate programming errors caused by a 
 * misunderstanding of the database schema.
 * 
 * @see QueryBuilder 
 * @author Jay Gunter
 */
public class ColumnTypeException extends Exception  {
    ColumnTypeException(RDBColumnValue v, String  attemptedType) {
        super("Column " + v.getFullColumnName() + " is of type "
                + v.getValue().getClass().getName() + " not " + attemptedType
                + ".");
    }
}
