
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: GenericDO.java,v 1.4 2005/03/14 12:23:25 predrag Exp $
 */

/*
 * GenericDO.java
 *
 * This class is the parent of all the generated DO classes produced
 * by the SourceGenerator_DO.  The template file
 *           SourceGenerator_DO/templates/writeFileHeader.template
 * contains the line
 *           class <CLASS_NAME> <EXTENDS> {
 * and the EXTENDS tag is replaced by either
 *           extends GenericDO
 * or, if the DataObject is derived from another DataOBject, the replacement is
 *           extends ThatOtherDO
 */
package com.lutris.dods.builder.generator.dataobject;

import java.io.ByteArrayInputStream ;
import java.io.IOException ;
import java.math.BigDecimal ;
import java.sql.PreparedStatement ;
import java.sql.ResultSet ;
import java.sql.SQLException ;
import java.sql.Types ;
import com.lutris.logging.Logger;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.Condition;
import com.lutris.appserver.server.sql.CloneableDO;
import com.lutris.appserver.server.sql.CoreDO;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBRowUpdateException;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.appserver.server.sql.standard.DriverSpecificConstants;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.dods.builder.generator.query.DataObjectException;
import com.lutris.dods.builder.generator.query.QueryException;
import com.lutris.dods.builder.generator.query.RefAssertionException;

abstract public class GenericDO extends CloneableDO {
    static public void printMsg(int level, String  s) {
        try {
            DODS.getLogChannel().write(level, s);
        } catch (Exception  e) {
            System.out.println(level + " " + s);
        }
    }
    // True if this object has been changed with respect to
 // its persistent representation in the database.
 protected boolean dirty = false;
    // private boolean updateInProgress = false;
 private boolean notUsingOId = false;

    private static Boolean  setNullAsVarchar = null;
    
    private static Boolean  setBytesAsLongvarbinary = null;
    
    private static Boolean  setBytesAsBinaryStream = null;
    
    private static Boolean  setBooleanAsString = null;
    
    
    
    private static boolean isSetNullAsVarchar() {
        if (setNullAsVarchar==null) {
            setNullAsVarchar = new Boolean (DriverSpecificConstants.DEFAULT_SET_NULL_AS_VARCHAR);
            try {
                String  setNullAsVarcharStr = ((StandardLogicalDatabase)DODS.getDatabaseManager()
                                                .findLogicalDatabase(DODS.getDatabaseManager().getDefaultDB()))
                                                .getDriverProperty(DriverSpecificConstants.PARAMNAME_SET_NULL_AS_VARCHAR);
                if(setNullAsVarcharStr!=null){
                    if(setNullAsVarcharStr.equalsIgnoreCase("true")){
                        setNullAsVarchar=new Boolean (true);
                    }else if(setNullAsVarcharStr.equalsIgnoreCase("false")){
                        setNullAsVarchar=new Boolean (false);
                    }else{
                        DODS.getLogChannel().write(Logger.DEBUG,"Illegal value for SetNullAsVarchar parameter. Using default");
                    }
                }
            } catch (DatabaseManagerException e){
                DODS.getLogChannel().write(Logger.DEBUG," Unable to read configuration for SetNullAsVarchar. Using default. ");
            }           
        }
        return setNullAsVarchar.booleanValue();
    }
   
    private static boolean isSetBooleanAsString() {
        if (setBooleanAsString == null) {
            setBooleanAsString = new Boolean (DriverSpecificConstants.DEFAULT_SET_BOOLEAN_AS_STRING);
            try {
                String  setBooleanAsStringStr = ((StandardLogicalDatabase)DODS.getDatabaseManager()
                                                .findLogicalDatabase(DODS.getDatabaseManager().getDefaultDB()))
                                                .getDriverProperty(DriverSpecificConstants.PARAMNAME_SET_BOOLEAN_AS_STRING);
                if(setBooleanAsStringStr!=null){
                    if(setBooleanAsStringStr.equalsIgnoreCase("true")){
                        setBooleanAsString=new Boolean (true);
                    }else if(setBooleanAsStringStr.equalsIgnoreCase("false")){
                        setBooleanAsString=new Boolean (false);
                    }else{
                        DODS.getLogChannel().write(Logger.DEBUG,"Illegal value for SetBooleanAsString parameter. Using default ('true').");
                    }
                }
            } catch (DatabaseManagerException e){
                DODS.getLogChannel().write(Logger.DEBUG," Unable to read configuration for SetBooleanAsString. Using default ('true'). ");
            }           
        }
        return setBooleanAsString.booleanValue();
    }
    
    
    private static boolean isSetBytesAsBinaryStream() {
        if (setBytesAsBinaryStream == null) {
            setBytesAsBinaryStream = new Boolean (DriverSpecificConstants.DEFAULT_SET_BYTES_AS_BINARY_STREAM);
            try {
                String  setBytesAsBinaryStreamStr = ((StandardLogicalDatabase)DODS.getDatabaseManager()
                                                .findLogicalDatabase(DODS.getDatabaseManager().getDefaultDB()))
                                                .getDriverProperty(DriverSpecificConstants.PARAMNAME_SET_BYTES_AS_BINARY_STREAM);
                if(setBytesAsBinaryStreamStr!=null){
                    if(setBytesAsBinaryStreamStr.equalsIgnoreCase("true")){
                        setBytesAsBinaryStream=new Boolean (true);
                    }else if(setBytesAsBinaryStreamStr.equalsIgnoreCase("false")){
                        setBytesAsBinaryStream=new Boolean (false);
                    }else{
                        DODS.getLogChannel().write(Logger.DEBUG,"Illegal value for SetBytesAsBinaryStream parameter. Using default");
                    }
                }
            } catch (DatabaseManagerException e){
                DODS.getLogChannel().write(Logger.DEBUG," Unable to read configuration for SetBytesAsBinaryStream. Using default. ");
            }           
        }
        return setBytesAsBinaryStream.booleanValue();
    }
    
    private static boolean isSetBytesAsLongvarbinary() {
        if (setBytesAsLongvarbinary == null) {
            setBytesAsLongvarbinary = new Boolean (DriverSpecificConstants.DEFAULT_SET_BYTES_AS_LONGVARBINARY);
            try {
                String  setBytesAsLongvarbinaryStr = ((StandardLogicalDatabase)DODS.getDatabaseManager()
                                                .findLogicalDatabase(DODS.getDatabaseManager().getDefaultDB()))
                                                .getDriverProperty(DriverSpecificConstants.PARAMNAME_SET_BYTES_AS_LONGVARBINARY);
                if(setBytesAsLongvarbinaryStr!=null){
                    if(setBytesAsLongvarbinaryStr.equalsIgnoreCase("true")){
                        setBytesAsLongvarbinary=new Boolean (true);
                    }else if(setBytesAsLongvarbinaryStr.equalsIgnoreCase("false")){
                        setBytesAsLongvarbinary=new Boolean (false);
                    }else{
                        DODS.getLogChannel().write(Logger.DEBUG,"Illegal value for SetBytesAsLongvarchar parameter. Using default");
                    }
                }
            } catch (DatabaseManagerException e){
                DODS.getLogChannel().write(Logger.DEBUG," Unable to read configuration for SetBytesAsLongvarchar. Using default. ");
            }           
        }
        return setBytesAsLongvarbinary.booleanValue();
    }


    
    /**
     * Public constructor.
     */
    public GenericDO()
          throws ObjectIdException, DatabaseManagerException {
        super();
        set_OId(DODS.getDatabaseManager().allocateObjectId());
        markNewValue();
    }

    /**
     * Public constructor.
     */
    public GenericDO(String  dbName)
          throws ObjectIdException, DatabaseManagerException {
        super();
        set_OId(DODS.getDatabaseManager().allocateObjectId(dbName));
        markNewValue();
    }

    /**
     * Public constructor.
     */
    public GenericDO(boolean notUsingOId)
          throws ObjectIdException, DatabaseManagerException {
        super();
        this.notUsingOId = notUsingOId;
        if (!notUsingOId) {
            set_OId(DODS.getDatabaseManager().allocateObjectId());
        }
        markNewValue();
    }

    /**
     * Public constructor.
     */
    public GenericDO(String  dbName, boolean notUsingOId)
          throws ObjectIdException, DatabaseManagerException {
        super();
        this.notUsingOId = notUsingOId;
        if (!notUsingOId) {
            set_OId(DODS.getDatabaseManager().allocateObjectId(dbName));
        }
        markNewValue();
    }

    /**
     * Public constructor.
     */
    public GenericDO(ObjectId id)
          throws ObjectIdException, DatabaseManagerException {
        super();
        set_OId(id);
    }

    /**
     * Public constructor.
     */
    public GenericDO(String  dbName, ObjectId id)
          throws ObjectIdException, DatabaseManagerException {
        super();
        set_OId(id);
    }

    /**
     * Public constructor.
     * @param rs a result set.
     * @exception SQLException if an error occurs while instantiating this
     * object from the result set.
     * @exception ObjectIdException if the object id for this object is
     * invalid.
     * @exception DatabaseManagerException
     *   If a nonexistent default logical database has been set.
     */
    public GenericDO(ResultSet  rs)
          throws SQLException , ObjectIdException, DatabaseManagerException {
        super(rs);
        //set_NewVersion(get_Version());
    }

    /**
     * Public constructor.
     * @param rs a result set.
     * @exception SQLException if an error occurs while instantiating this
     * object from the result set.
     * @exception ObjectIdException if the object id for this object is
     * invalid.
     * @exception DatabaseManagerException
     *   If a nonexistent logical database name is supplied.
     */
    public GenericDO(String  dbName, ResultSet  rs)
          throws SQLException , ObjectIdException, DatabaseManagerException {
        super(rs);
        //set_NewVersion(get_Version());
    }

    /**
     * Creates a clone of the object, but ensures that
     * a new and unique object id is created for the object
     * and that the version number is set to zero.
     * @exception DatabaseManagerException if an error occurs while
     * allocation a new object id from the default logical database.
     * @exception ObjectIdException if a new object id could not be
     * allocated.
     */
    public synchronized Object  cloneUnique()
          throws DatabaseManagerException, ObjectIdException {
        GenericDO dataObj = (GenericDO) super.cloneUnique();

        // It's important to do the following.  Otherwise two
 // commits in a row on a cloned object will fail.
 //dataObj.set_NewVersion(0);
        dataObj.set_Version(0);
        dataObj.markNewValue(); // make sure it gets commited.
 return dataObj;
    }

    /**
     * makeIdentical()
     *
     * Used by subclasses to assign any data members to this data object.
     * Does not duplicate data. Just assigns references.
     *
     * @param obj The original DO.
     *
     */
    protected void makeIdentical(GenericDO obj) {}

    /**
     * Updates the contents of this object in the database
     * but only if the datab object is dirty.  This requires
     * that all set methods in the data objects keep track
     * if a value has changed.
     *
     * @param conn the database connection.
     * @exception java.sql.SQLException If a database access error occurs.
     * @exception DBRowUpdateException If a version error occurs.
     */
    public synchronized void executeUpdate(DBConnection conn)
        throws SQLException , DBRowUpdateException {
        if (dirty/* && !updateInProgress*/) {
            if (!notUsingOId) {
                printMsg(Logger.DEBUG,
                        getClass().getName() + ".executeUpdate:" + persistent
                        + ": " + getClass().getName() + ": "
                        + get_OId().toString() + ": " + get_Version());
            }
            super.executeUpdate(conn);
        }
    }

    /**
     * Updates the contents of this object in the database
     * but only if the datab object is dirty.  This requires
     * that all set methods in the data objects keep track
     * if a value has changed.
     *
     * @param conn the database connection.
     * @exception java.sql.SQLException If a database access error occurs.
     * @exception DBRowUpdateException If a version error occurs.
     */
    public synchronized void executeInsert(DBConnection conn)
        throws SQLException , DBRowUpdateException {

        /* if (!updateInProgress) {*/
        if (!notUsingOId) {
            printMsg(Logger.DEBUG,
                    getClass().getName() + ".executeInsert():" + persistent
                    + ": " + get_OId().toString() + ": " + get_Version() + ": "
                    + get_NewVersion());
        }
        super.executeInsert(conn);

        /* updateInProgress = !getAutoSave();
         } */
    }

    /**
     * Deletes this object from the database.
     *
     * @param conn Database connection.
     * @exception java.sql.SQLException If a database access error
     *  occurs.
     */
    public void executeDelete(DBConnection conn)
        throws SQLException  {
        //PreparedStatement stmt = getDeleteStatement(conn); -dp

        if (isPersistent()) {
            if (!notUsingOId) {
                printMsg(Logger.DEBUG,
                        getClass().getName() + ".executeDelete(): " + persistent
                        + ": " + get_OId().toString() + ": " + get_Version());
            }
            super.executeDelete(conn);
        }
    }

    /**
     * If transaction succeeded marks this object as clean.
     * @param success true if the transaction succeeded
     *   and this object was successfully inserted into the database.
     */
    public void finalizeInsert(boolean success) {
        if (!notUsingOId) {
            printMsg(Logger.DEBUG,
                    getClass().getName() + ".finalizeInsert(" + success + ") "
                    + "oid=" + get_OId().toString() + " " + "version="
                    + get_Version());
        }
        boolean p = persistent;

        super.finalizeInsert(success);
        if (p == true) {
            persistent = true; // fix bug in CoreDO.
        }
        if (success) {
            dirty = false;
        }
    }

    /**
     * If transaction succeeded marks this object as clean.
     * @param success true if the transaction succeeded
     *   and this object was successfully updated in the database.
     */
    public void finalizeUpdate(boolean success) {
        if (!notUsingOId) {
            printMsg(Logger.DEBUG,
                    getClass().getName() + ".finalizeUpdate:" + success + ": "
                    + get_OId().toString() + ": " + get_Version());
        }
        super.finalizeUpdate(success);
        if (success) {
            dirty = false;
        }
        // updateInProgress = false;
    }

    /**
     * Return the name of the primary key column.
     * FIX to get name from conf file (or via CoreDO?)
     *
     * @return the name of the primary key column.
     * @see CoreDO
     * author Jay Gunter
     */
    static protected String  get_primaryKeyName() {
        return CoreDO.get_OIdColumnName();
    }

    /**
     * Return the name of the primary key column.
     * FIX to get name from conf file (or via CoreDO?)
     *
     * @return the name of the primary key column.
     * @see CoreDO
     * author Jay Gunter
     * @deprecated use get_primaryKeyName()
     */
    static protected String  getPrimaryKeyName() {
        return get_primaryKeyName();
    }

    /**
     * @deprecated Use set_OId()
     * @param oId this object's identifier.
     */
    protected void setOId(ObjectId oId) {
        set_OId(oId);
    }

    /**
     * Sets this object's identifier.
     * @param oId this object's identifier.
     */
    protected void set_OId(ObjectId oId) {
        if (!notUsingOId) {
            super.set_OId(markNewValue(get_OId(), oId));
        }
    }

    /**
     * <CODE>isDirty()</CODE> returns true if this object has been
     * modified (needs to be updated to the database).<p>
     */
    public boolean isDirty() {
        return dirty;
    }

    /**
     * <CODE>markClean()</CODE> with no arguments is used to indicate that
     * this object is marked as "clean"
     * (it does not need to be updated to the database).<p>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     */
    protected void markClean() {
        dirty = false;
    }

    /**
     * <CODE>markNewValue()</CODE> with no arguments is used to indicate that
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     */
    protected void markNewValue() {
        dirty = true;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value,
     *                                  max_length, nullOK )</CODE>
     *
     * If <CODE>nullOK</CODE> is false and <CODE>new_field_value</CODE>
     * is null, <CODE>this.field</CODE> is set to <CODE>""</CODE>.
     *
     * @param current_string The current value of the String data member.
     * @param new_string The new value of the String data member.
     * @param max_length The maximum allowed length of the String value.
     * If the new_string is longer than max_length, new_string is truncated.
     * If max_length is less than 1, no maximum is imposed.
     * @return new_string if it is not null, otherwise "".
     */
    protected String  markNewValue(String  current_string, String  new_string,
            int max_length,
            boolean nullOK) {

        /*
         if ( new_string == null )
         if ( ! nullOK )
         return current_string;
         else
         new_string = "";
         if ((max_length > 00) && (new_string.length() > max_length)) {
         new_string = new_string.substring( 0, max_length );
         }
         if (!new_string.equals(current_string)) {
         dirty = true;
         }
         return new_string;
         */
        // FIX delete stuff above after testing line below
 return markNewValue(current_string, new_string, 0, max_length, nullOK);
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value,
     *                                  min_length, max_length, nullOK )</CODE>
     *
     * If <CODE>min_length > 0</CODE> and
     * <CODE>nullOK</CODE> is false and
     * <CODE>new_field_value</CODE> is null,
     * <CODE>this.field</CODE> is returned
     * (the <CODE>new_field_value</CODE> is ignored.)
     *
     * @param current_string The current value of the String data member.
     * @param new_string The new value of the String data member.
     * @param min_length The minimum allowed length of the String value.
     * If the new_string is shorter than min_length, new_string is ignored.
     * If min_length is less than 0, no minimum is imposed.
     * @param max_length The maximum allowed length of the String value.
     * If the new_string is longer than max_length, new_string is truncated.
     * If max_length is less than 1, no maximum is imposed.
     * @return new_string if it is not null, otherwise "".
     */
    protected String  markNewValue(String  current_string, String  new_string,
            int min_length, int max_length,
            boolean nullOK) {
        colChanged = false;
        if (!nullOK && current_string == null) {  // fix bogus current value
            current_string = "";
        }
        if (new_string == null) {
            if (!nullOK) {  // reject new value
 return current_string;
            } else {
                if (current_string != null) {
                    colChanged = dirty = true;
                }
                return null;
            }
        }
        if (min_length >= 0 && new_string.length() < min_length) {
            new_string = current_string;
        } // reject new_string
 if (max_length > 00 && new_string.length() > max_length) {
            new_string = new_string.substring(0, max_length);
        }
        if (!new_string.equals(current_string)) {
            colChanged = dirty = true;
        }
        return new_string;
    }
    protected boolean colChanged = false;
    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_OId The current value of the ObjectId data member.
     * @param new_OId The new value of the ObjectId data member.
     * @return new_OId
     */
    protected ObjectId markNewValue(ObjectId current_OId, ObjectId new_OId) {
        colChanged = false;
        if (current_OId == null) {
            if (new_OId != null) {
                colChanged = dirty = true;
            }
        } else {
            if (new_OId == null) {
                colChanged = dirty = true;
            } else if (!current_OId.toString().equals(new_OId.toString())) {
                colChanged = dirty = true;
            }
        }
        return new_OId;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_date The current value of the Date data member.
     * @param new_date The new value of the Date data member.
     * @return new_date
     */
    protected java.util.Date  markNewValue(
            java.util.Date  current_date, java.util.Date  new_date) {
        colChanged = false;
        if (current_date == null) {
            if (new_date != null) {
                colChanged = dirty = true;
            }
        } else {
            if (new_date == null) {
                colChanged = dirty = true;
            } else if (!current_date.toString().equals(new_date.toString())) {
                colChanged = dirty = true;
            }
        }
        return new_date;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_bd The current value of the BigDecimal data member.
     * @param new_bd The new value of the BigDecimal data member.
     * @return new_bd
     */
    protected BigDecimal  markNewValue(BigDecimal  current_bd, BigDecimal  new_bd) {
        colChanged = false;
        if (current_bd == null) {
            if (new_bd != null) {
                colChanged = dirty = true;
            }
        } else {
            if (new_bd == null) {
                colChanged = dirty = true;
            } else if (!current_bd.equals(new_bd)) {
                colChanged = dirty = true;
            }
        }
        return new_bd;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_val The current value of the byte array data member.
     * @param new_val The new value of the byte array data member.
     * @return new_val
     */
    protected byte[] markNewValue(byte[] current_val, byte[] new_val) {
        colChanged = false;
        if (current_val == null) {
            if (new_val != null) {
                colChanged = dirty = true;
            }
        } else {
            if (new_val == null) {
                colChanged = dirty = true;
            } else {
                if (current_val.length != new_val.length) {// FIX what to do?
                    colChanged = dirty = true;
                } else {
                    for (int i = 0; i < current_val.length; i++) {
                        if (current_val[i] != new_val[i]) {
                            colChanged = dirty = true;
                            break;
                        }
                    }
                }
            }
        }
        return new_val;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_val The current value of the java.sql.Date data member.
     * @param new_val The new value of the java.sql.Date data member.
     * @return new_val
     */
    protected java.sql.Date  markNewValue(
            java.sql.Date  current_val, java.sql.Date  new_val) {
        colChanged = false;
        if (current_val == null) {
            if (new_val != null) {
                colChanged = dirty = true;
            }
        } else {
            if (new_val == null) {
                colChanged = dirty = true;
            } else if (!current_val.equals(new_val)) {
                colChanged = dirty = true;
            }
        }
        return new_val;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_val The current value of the java.sql.Time data member.
     * @param new_val The new value of the java.sql.Time data member.
     * @return new_val
     */
    protected java.sql.Time  markNewValue(
            java.sql.Time  current_val, java.sql.Time  new_val) {
        colChanged = false;
        if (current_val == null) {
            if (new_val != null) {
                colChanged = dirty = true;
            }
        } else {
            if (new_val == null) {
                colChanged = dirty = true;
            } else if (!current_val.equals(new_val)) {
                colChanged = dirty = true;
            }
        }
        return new_val;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_val The current value of the java.sql.Timestamp data member.
     * @param new_val The new value of the java.sql.Timestamp data member.
     * @return new_val
     */
    protected java.sql.Timestamp  markNewValue(
            java.sql.Timestamp  current_val, java.sql.Timestamp  new_val) {
        colChanged = false;
        if (current_val == null) {
            if (new_val != null) {
                colChanged = dirty = true;
            }
        } else {
            if (new_val == null) {
                colChanged = dirty = true;
            } else if (!current_val.equals(new_val)) {
                colChanged = dirty = true;
            }
        }
        return new_val;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_int The current value of the int data member.
     * @param new_int The new value of the int data member.
     * @return new_int
     */
    protected int markNewValue(int current_int, int new_int) {
        colChanged = false;
        if (current_int != new_int) {
            colChanged = dirty = true;
        }
        return new_int;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_float The current value of the float data member.
     * @param new_float The new value of the float data member.
     * @return new_float
     */
    protected float markNewValue(float current_float, float new_float) {
        colChanged = false;
        if (current_float != new_float) {
            colChanged = dirty = true;
        }
        return new_float;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_double The current value of the double data member.
     * @param new_double The new value of the double data member.
     * @return new_double
     */
    protected double markNewValue(double current_double, double new_double) {
        colChanged = false;
        if (current_double != new_double) {
            colChanged = dirty = true;
        }
        return new_double;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_boolean The current value of the boolean data member.
     * @param new_boolean The new value of the boolean data member.
     * @return new_boolean
     */
    protected boolean markNewValue(boolean current_boolean, boolean new_boolean) {
        colChanged = false;
        if (current_boolean != new_boolean) {
            colChanged = dirty = true;
        }
        return new_boolean;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_char The current value of the char data member.
     * @param new_char The new value of the char data member.
     * @return new_char
     */
    protected char markNewValue(char current_char, char new_char) {
        colChanged = false;
        if (current_char != new_char) {
            colChanged = dirty = true;
        }
        return new_char;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_byte The current value of the byte data member.
     * @param new_byte The new value of the byte data member.
     * @return new_byte
     */
    protected byte markNewValue(byte current_byte, byte new_byte) {
        colChanged = false;
        if (current_byte != new_byte) {
            colChanged = dirty = true;
        }
        return new_byte;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_short The current value of the short data member.
     * @param new_short The new value of the short data member.
     * @return new_short
     */
    protected short markNewValue(short current_short, short new_short) {
        colChanged = false;
        if (current_short != new_short) {
            colChanged = dirty = true;
        }
        return new_short;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_long The current value of the long data member.
     * @param new_long The new value of the long data member.
     * @return new_long
     */
    protected long markNewValue(long current_long, long new_long) {
        colChanged = false;
        if (current_long != new_long) {
            colChanged = dirty = true;
        }
        return new_long;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @param current_DO Curent data object.
     * @param new_DO New data object.
     * @return new_long
     */
    protected GenericDO markNewValue(GenericDO current_DO, GenericDO new_DO) {
        colChanged = false;
        if (current_DO != new_DO) {
            colChanged = dirty = true;
        }
        return new_DO;
    }

    /**
     * If the current data member value differs from the new value,
     * this object is marked as "dirty" (in need of an update to the database).
     * There is no way to mark this object as "clean";<BR> only the
     * <CODE>executeInsert()</CODE> and <CODE>executeUpdate()</CODE>
     * methods can make that so.<P>
     *
     * This method is protected since only derived Data Objects (DO's)
     * "<CODE>set</CODE>" methods will be calling it.<P>
     *
     * This method returns the new value as a convenience to the calling
     * "<CODE>set</CODE>" method.  The usage is:
     * <CODE>this.field = markNewValue( this.field, new_field_value )</CODE>
     *
     * @return new_ts
     */

    /*
     protected Timestamp markNewValue(Timestamp current_ts, Timestamp new_ts)
     {
     if ( ! current_ts.equals( new_ts ) )
     dirty = true;
     return new_ts;
     }
     */
    protected void setPrepStmtParam_DO(
            PreparedStatement  stmt, int[] paramIndex, GenericDO value)
        throws java.sql.SQLException  {
        if (null == value) {
            if (isSetNullAsVarchar()) {
                stmt.setNull(paramIndex[0]++, Types.VARCHAR);
            }else {
                stmt.setNull(paramIndex[0]++, Types.DECIMAL);
            }           
        } else {
            ObjectId oid = value.get_OId();

            if (null == oid) {
                 if (isSetNullAsVarchar()) {
                     stmt.setNull(paramIndex[0]++, Types.VARCHAR);
                 }else {
                     stmt.setNull(paramIndex[0]++, Types.DECIMAL);
                 }          
            } else {
                setPrepStmtParam_BigDecimal(stmt, paramIndex, oid.toBigDecimal());
            }
        }
    }

    static protected boolean isNewDataDifferent_DO(GenericDO oldData, GenericDO newData) {
        return (null == oldData)
                ? (null != newData)
                : (null == newData)
                        ? true
                        : isNewDataDifferent_BigDecimal(oldData.get_OId().toBigDecimal(),
                                newData.get_OId().toBigDecimal());
    }

    protected void setPrepStmtParam_String(
            PreparedStatement  stmt, int[] paramIndex, String  value)
        throws java.sql.SQLException  {
        if (null == value) {
            stmt.setNull(paramIndex[0]++, Types.VARCHAR);
        } else {
            // WebDocWf fix for JTurbo Problem
            stmt.setString(paramIndex[0]++, value);
        }
        // end of WebDocWf fix for JTurbo Problem
    }

    static protected boolean isNewDataDifferent_String(String  oldData, String  newData) {
        return (null == oldData) ? (null != newData) : !oldData.equals(newData);
    }

    protected void setPrepStmtParam_float(
            PreparedStatement  stmt, int[] paramIndex, float value)
        throws java.sql.SQLException  {
        stmt.setFloat(paramIndex[0]++, value);
    }

    static protected boolean isNewDataDifferent_float(float oldData, float newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_int(
            PreparedStatement  stmt, int[] paramIndex, int value)
        throws java.sql.SQLException  {
        stmt.setInt(paramIndex[0]++, value);
    }

    static protected boolean isNewDataDifferent_int(int oldData, int newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_java_math_BigDecimal(
            PreparedStatement  stmt, int[] paramIndex, BigDecimal  value)
        throws java.sql.SQLException  {
        if (null == value) {
            if (isSetNullAsVarchar()) {
                stmt.setNull(paramIndex[0]++, Types.VARCHAR);
             }else {
                stmt.setNull(paramIndex[0]++, Types.DECIMAL);
             }
        } else {
            stmt.setBigDecimal(paramIndex[0]++, value);
        }
    }

    static protected boolean isNewDataDifferent_java_math_BigDecimal(BigDecimal  oldData, BigDecimal  newData) {
        return (null == oldData)
                ? (null != newData)
                : (null == newData) ? true : !oldData.equals(newData);
    }

    protected void setPrepStmtParam_BigDecimal(
            PreparedStatement  stmt, int[] paramIndex, BigDecimal  value)
        throws java.sql.SQLException  {
        if (null == value) {
             if (isSetNullAsVarchar()) {
                 stmt.setNull(paramIndex[0]++, Types.VARCHAR);
             }else {
                 stmt.setNull(paramIndex[0]++, Types.DECIMAL);
             }
        } else {
            stmt.setBigDecimal(paramIndex[0]++, value);
        }
    }

    static protected boolean isNewDataDifferent_BigDecimal(BigDecimal  oldData, BigDecimal  newData) {
        return isNewDataDifferent_java_math_BigDecimal(oldData, newData);
    }

    protected void setPrepStmtParam_java_sql_Date(
            PreparedStatement  stmt, int[] paramIndex, java.sql.Date  value)
        throws java.sql.SQLException  {
        if (null == value) {
             if (isSetNullAsVarchar()) {
                 stmt.setNull(paramIndex[0]++, Types.VARCHAR);
             }else {
                 stmt.setNull(paramIndex[0]++, Types.DATE);
             }
        } else {
            stmt.setDate(paramIndex[0]++, value);
        }
    }

    static protected boolean isNewDataDifferent_java_sql_Date(java.sql.Date  oldData, java.sql.Date  newData) {
        return (null == oldData) ? (null != newData) : !oldData.equals(newData);
    }

    protected void setPrepStmtParam_java_sql_Time(
            PreparedStatement  stmt, int[] paramIndex, java.sql.Time  value)
        throws java.sql.SQLException  {
        if (null == value) {
             if (isSetNullAsVarchar()) {
                 stmt.setNull(paramIndex[0]++, Types.VARCHAR);
             }else {
                 stmt.setNull(paramIndex[0]++, Types.TIME);
             }
        } else {
            stmt.setTime(paramIndex[0]++, value);
        }
    }

    static protected boolean isNewDataDifferent_java_sql_Time(java.sql.Time  oldData, java.sql.Time  newData) {
        return (null == oldData) ? (null != newData) : !oldData.equals(newData);
    }

    protected void setPrepStmtParam_java_sql_Timestamp(
            PreparedStatement  stmt, int[] paramIndex, java.sql.Timestamp  value)
        throws java.sql.SQLException  {
        if (null == value) {
            if (isSetNullAsVarchar()) {
                stmt.setNull(paramIndex[0]++, Types.VARCHAR);
             }else {
                stmt.setNull(paramIndex[0]++, Types.TIMESTAMP);
             }
        } else {
            stmt.setTimestamp(paramIndex[0]++, value);
        }
    }

    static protected boolean isNewDataDifferent_java_sql_Timestamp(java.sql.Timestamp  oldData, java.sql.Timestamp  newData) {
        return (null == oldData) ? (null != newData) : !oldData.equals(newData);
    }

    protected void setPrepStmtParam_bytes(
            PreparedStatement  stmt, int[] paramIndex, byte[] value)
        throws java.sql.SQLException  {
        if (null == value) {
            if (isSetNullAsVarchar()) {
                stmt.setNull(paramIndex[0]++, Types.VARCHAR);
            }else {
                stmt.setNull(paramIndex[0]++, Types.VARBINARY);
            }
        } else {        
            if(isSetBytesAsBinaryStream()) {
                ByteArrayInputStream  newBAIS = new ByteArrayInputStream (value); 
                stmt.setBinaryStream(paramIndex[0]++,newBAIS,value.length);
                try {
                    newBAIS.close();
                } catch (IOException  e) {
                    e.printStackTrace();
                }
            }else if(isSetBytesAsLongvarbinary()) {
                String  psValue = new String (value); 
                stmt.setObject(paramIndex[0]++, psValue, Types.LONGVARBINARY); 
            }else {
                // WebDocWf fix for JTurbo Problem
                stmt.setBytes(paramIndex[0]++, value);         
                // end of WebDocWf fix for JTurbo Problem
            }
        }
        
    }

    static protected boolean isNewDataDifferent_bytes(byte[] oldData, byte[] newData) {
        if (null == oldData) {
            return null != newData;
        } else if (oldData.length == newData.length) {
            for (int i = 0; i < oldData.length; ++i) {
                if (oldData[i] != newData[i]) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected void setPrepStmtParam_double(
            PreparedStatement  stmt, int[] paramIndex, double value)
        throws java.sql.SQLException  {
        stmt.setDouble(paramIndex[0]++, value);
    }

    static protected boolean isNewDataDifferent_double(double oldData, double newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_long(
            PreparedStatement  stmt, int[] paramIndex, long value)
        throws java.sql.SQLException  {
        stmt.setLong(paramIndex[0]++, value);
    }

    static protected boolean isNewDataDifferent_long(long oldData, long newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_short(
            PreparedStatement  stmt, int[] paramIndex, short value)
        throws java.sql.SQLException  {
        stmt.setShort(paramIndex[0]++, value);
    }

    static protected boolean isNewDataDifferent_short(short oldData, short newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_byte(
            PreparedStatement  stmt, int[] paramIndex, byte value)
        throws java.sql.SQLException  {
        stmt.setByte(paramIndex[0]++, value);
    }

    static protected boolean isNewDataDifferent_byte(byte oldData, byte newData) {
        return oldData != newData;
    }

    protected void setPrepStmtParam_boolean(PreparedStatement  stmt, int[] paramIndex, boolean value)
    throws java.sql.SQLException  {
        if(isSetBooleanAsString()) {
            stmt.setString(paramIndex[0]++, value ? "1" : "0");
        }else {
            stmt.setBoolean(paramIndex[0]++, value); 
        }
    }

    static protected boolean isNewDataDifferent_boolean(boolean oldData, boolean newData) {
        return oldData != newData;
    }

    public String  toString(int x) {
        return super.toString();
    }

    public void delete()
        throws SQLException , DatabaseManagerException,
                DataObjectException, RefAssertionException,
                DBRowUpdateException, QueryException {
        if (false) {
            throw new SQLException ("");
        }
        if (false) {
            throw new DatabaseManagerException("");
        }
        if (false) {
            throw new DataObjectException("");
        }
        if (false) {
            throw new RefAssertionException("");
        }
        if (false) {
            throw new DBRowUpdateException("");
        }
        if (false) {
            throw new QueryException("");
        }
    }

    // Copy routines used by the duplicate() method in generated DataStruct classes.
 // If a null is passed, a null is returned.
 static public byte[] copyByteArray(byte[] source) {
        if (null == source) {
            return null;
        }
        byte[] dest = new byte[ source.length ];

        System.arraycopy(source, 0, dest, 0, source.length);
        return dest;
    }

    static public String  copyString(String  source) {
        if (null == source) {
            return null;
        }
        return source + "";
    }

    static public BigDecimal  copyBigDecimal(BigDecimal  source) {
        if (null == source) {
            return null;
        }
        return new java.math.BigDecimal (source.toString());
    }

    static public java.sql.Date  copyDate(java.sql.Date  source) {
        if (null == source) {
            return null;
        }
        return new java.sql.Date (source.getTime());
    }

    static public java.sql.Time  copyTime(java.sql.Time  source) {
        if (null == source) {
            return null;
        }
        return new java.sql.Time (source.getTime());
    }

    static public java.sql.Timestamp  copyTimestamp(java.sql.Timestamp  source) {
        if (null == source) {
            return null;
        }
        return new java.sql.Timestamp (source.getTime());
    }

    /**
     * Subclass should override this method if wants to use it.
     * This method checks if this data object satisfies query conditions
     * cond.
     *
     * @param  cond conditions of the query.
     * @return true if this data object satisfies conditions of this query,
     * otherwise false.
     */
    public boolean compareCond(Condition cond) {
        return false;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Sets DO's data.
     *
     * @deprecated Use set_Data()
     * @param data DO's data.
     */
    public void setData(Object  data) {}

    /**
     * Subclass should override this method if wants to use it.
     * Sets DO's data.
     *
     * @param data DO's data.
     */
    public void set_Data(Object  data) {}

    /**
     * Subclass should override this method if wants to use it.
     * Sets original DO's data.
     */
    public void originalData_set(Object  data) {}

    /**
     * @deprecated Use get_Data()
     * @return DO's data.
     */
    public Object  getData() {
        return getData();
    }

    /**
     * Subclass should override this method if wants to use it.
     * Returns DO's data.
     *
     * @return DO's data.
     */
    public Object  get_Data() {
        return null;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Returns DO's handle.
     *
     * @return DO's handle.
     */
    public String  get_Handle() throws DatabaseManagerException {
        return null;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Returns DO's handle.
     *
     * @return DO's handle.
     * @deprecated Use get_Handle() instead.
     */
    public String  getHandle() throws DatabaseManagerException {
        return null;
    }
     
    /**
     * Subclass should override this method if wants to use it.
     * Returns DO's cache handle.
     *
     * @return DO's cache handle.
     */
    public String  get_CacheHandle() throws DatabaseManagerException {
        return null;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Returns copy of DO (with the same id).
     *
     * @param obj DO which will be copied.
     * @return copy of DO (with the same id).
     */
    public GenericDO createDO(GenericDO obj) {
        return null;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Created DO with specified OID.
     *
     * @param oid DO(by oid) which will be copied.
     * @return copy of DO (with the same id).
     */
    public static GenericDO createDO(ObjectId oid) throws java.sql.SQLException , com.lutris.appserver.server.sql.ObjectIdException, com.lutris.dods.builder.generator.query.DataObjectException, com.lutris.appserver.server.sql.DatabaseManagerException {
        return null;
    }

    /**
     * @deprecated Use get_OriginDatabase()
     * @return origin logical database name.
     */
    public String  getOriginDatabase() {
        return null;
    }

    /**
     * Subclass should override this method if wants to use it.
     * Returns the name of the logical database for which DO was created.
     *
     * @return origin logical database name.
     */
    public String  get_OriginDatabase() {
        return null;
    }

    private boolean executePartially;

    public void setExecutePartially(boolean _ep) {
        executePartially = _ep;
    }

    public boolean isExecutePartially() {
        return executePartially;
    }
}
