
/*
 * Created on May 24, 2004
 *
 */
package com.lutris.appserver.server.sql;

import java.util.Set;
import org.enhydra.dods.cache.DOCache;

/**
 * @author P.Djojic
 *
 */
public interface CachedDBTransaction extends DBTransaction {

    /**
     * Method to ensure this object is still valid.
     * Once this object has been released it cannot be
     * used any more.
     *
     * @return boolean True if the transaction is released, otherwise false
     */
    public boolean isReleased();


    /**
     * Gets an array of DOs.
     *
     * @return array of DOs from this transaction
     */
    public CoreDO[] getDOs() ;


    /**
     *
     */
    public void saveDirtyDOs();


    /**
     * Method return transaction Cache
     *
     * @return implementation of DOCache
     */
    public DOCache getTransactionCache();


    /**
     *
     */
    public Set<String> getDeletedDOs();


    /**
     *
     */
    public void addDeletedDO(CoreDO DO);


    /**
     *
     */
    public void resetDeletedDOs();

    /**
     *
     */
    public void dontAggregateDOModifications();


    /**
     * Method returns value of a data member.
     *
     * @return value of config parameter AutoWrite
     *         true means all DOs are writen into database, as they come in
     *         false - no writes are done implicitly
     */
    public boolean getAutoWrite();
    /**
     *
     */
    public boolean isFirstWrite();
    
    
    /**
     *
     */
    public void setFirstWrite(boolean newfw);


   /**
    * Although it's internally used to skip uneccessary commits against 
    * the database, this information is made publicly accessible through 
    * this method. 
    * Application may decide would it call a commit method or not thus
    * improving performance a bit more.
    * 
    * @return true if no writes happened
    */
   public boolean wasReadOnly();

}