/*
 * Decompiled with CFR 0.152.
 */
package org.webdocwf.dods.access;

import java.io.PrintStream;
import java.io.PrintWriter;
import org.enhydra.dods.exceptions.DodsBaseException;
import org.webdocwf.dods.access.SecureDO;
import org.webdocwf.dods.access.User;

public abstract class AccessException
extends DodsBaseException {
    public User usr = null;
    public String operation = null;
    public SecureDO obj = null;
    public String className = null;
    public String attrName = null;
    public String value = null;
    public String oldValue = null;
    public String datatype = null;
    public String cmp_op = null;

    public AccessException(String msg, User inUsr, String inOperation, SecureDO inObj, String inClassName, String inAttrName, String inValue, String inOldValue, String inDatatype, String inCmp_op) {
        super(msg);
        this.usr = inUsr;
        this.operation = inOperation;
        this.obj = inObj;
        this.className = inClassName;
        this.attrName = inAttrName;
        this.value = inValue;
        this.oldValue = inOldValue;
        this.datatype = inDatatype;
        this.cmp_op = inCmp_op;
    }

    public AccessException(String msg, Throwable cause, User inUsr, String inOperation, SecureDO inObj, String inClassName, String inAttrName, String inValue, String inOldValue, String inDatatype, String inCmp_op) {
        super(msg, cause);
        this.usr = inUsr;
        this.operation = inOperation;
        this.obj = inObj;
        this.className = inClassName;
        this.attrName = inAttrName;
        this.value = inValue;
        this.oldValue = inOldValue;
        this.datatype = inDatatype;
        this.cmp_op = inCmp_op;
    }

    public AccessException(String msg) {
        super(msg);
    }

    public AccessException(String msg, Throwable cause) {
        super(msg, cause);
    }

    private void printDetails(PrintWriter out) {
        if (this.usr != null) {
            out.println("User : " + this.usr.getName());
        }
        if (this.operation != null) {
            out.println("Operation : " + this.operation);
        }
        if (this.obj != null) {
            out.println("Object OID: " + this.obj.get_OId());
        }
        if (this.obj != null) {
            out.println("Object class: " + this.obj.getClass().getName());
        }
        if (this.className != null) {
            out.println("Class name : " + this.className);
        }
        if (this.attrName != null) {
            out.println("Attribute name : " + this.attrName);
        }
        if (this.value != null) {
            out.println("Value : " + this.value);
        }
        if (this.oldValue != null) {
            out.println("Old value : " + this.oldValue);
        }
        if (this.datatype != null) {
            out.println("Datatype : " + this.datatype);
        }
        if (this.cmp_op != null) {
            out.println("Comparison operator : " + this.cmp_op);
        }
    }

    public void printStackTrace() {
        super.printStackTrace();
        this.printTrace();
    }

    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        this.printTrace(s);
    }

    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        this.printTrace(s);
    }

    protected void printTrace() {
        PrintWriter pw = new PrintWriter(System.err);
        this.printDetails(pw);
        pw.flush();
    }

    protected void printTrace(PrintStream s) {
        PrintWriter pw = new PrintWriter(s);
        this.printDetails(pw);
        pw.flush();
    }

    public void printTrace(PrintWriter out) {
        this.printDetails(out);
        out.flush();
    }
}

