/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql.standard;

import com.lutris.appserver.server.sql.AbstractDBTransactionFactory;
import com.lutris.appserver.server.sql.ConnectionAllocator;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBQuery;
import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DBTransactionFactoryCreator;
import com.lutris.appserver.server.sql.DatabaseManagerConfiguration;
import com.lutris.appserver.server.sql.ExtendedDBConnection;
import com.lutris.appserver.server.sql.LogicalDatabase;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdAllocator;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.appserver.server.sql.standard.DatabaseConfiguration;
import com.lutris.appserver.server.sql.standard.DriverSpecificConstants;
import com.lutris.appserver.server.sql.standard.StandardDBQuery;
import com.lutris.appserver.server.sql.standard.StandardObjectIdAllocator;
import com.lutris.dods.builder.generator.query.RDBColumn;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import com.lutris.util.KeywordValueException;
import java.lang.reflect.Constructor;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.enhydra.dods.Common;
import org.enhydra.dods.DODS;
import org.enhydra.dods.DriverDependencies;
import org.enhydra.dods.cache.CacheConstants;

public class StandardLogicalDatabase
implements LogicalDatabase,
CacheConstants,
DriverSpecificConstants {
    public static final String PARAMNAME_DRIV_DEP_CLASS = "DriverDependenciesClass";
    protected AbstractDBTransactionFactory transactionFactory;
    protected ConnectionAllocator connectionAllocator;
    protected ObjectIdAllocator objectIdAllocator;
    protected Driver driver;
    protected String driverClassName;
    protected String dbName;
    protected String dbType;
    private DatabaseConfiguration dbConf;
    private DriverDependencies drivDepsInstance;

    public StandardLogicalDatabase() {
    }

    public StandardLogicalDatabase(String dbName, Config dbConfig) throws ConfigException, SQLException {
        this.init(dbName, dbConfig);
    }

    public StandardLogicalDatabase(String dbName, Config dbConfig, DatabaseManagerConfiguration DbManagerConf) throws ConfigException, SQLException {
        this.init(dbName, dbConfig, DbManagerConf);
    }

    public void init(String dbName, Config dbConfig) throws ConfigException, SQLException {
        this.dbConf = new DatabaseConfiguration(dbName);
        this.initConf(dbName, dbConfig);
    }

    public void init(String dbName, Config dbConfig, DatabaseManagerConfiguration DbManagerConf) throws ConfigException, SQLException {
        this.dbConf = new DatabaseConfiguration(dbName, DbManagerConf);
        this.initConf(dbName, dbConfig);
    }

    private void initConf(String dbName, Config dbConfig) throws ConfigException, SQLException {
        Object dataSource;
        Config connectionConfig;
        Config objIdConfig;
        block106: {
            this.dbName = dbName;
            try {
                String changeAutocommit = dbConfig.getString("ChangeAutocommit", "true");
                if (changeAutocommit.equalsIgnoreCase("false")) {
                    Common.setChangeAutocommit(dbName, false);
                    break block106;
                }
                if (changeAutocommit.equalsIgnoreCase("true")) {
                    Common.setChangeAutocommit(dbName, true);
                    break block106;
                }
                throw new ConfigException("invalid value for ChangeAutocommit parameter");
            }
            catch (ConfigException e) {
                throw new ConfigException("Error reading ChangeAutocommit : " + e.getMessage());
            }
        }
        try {
            objIdConfig = (Config)dbConfig.getSection("ObjectId");
            connectionConfig = (Config)dbConfig.getSection("Connection");
        }
        catch (KeywordValueException except) {
            throw new ConfigException("Invalid ObjectId or Connection sections in config file.");
        }
        try {
            dataSource = connectionConfig.getDataSource("DataSourceName");
        }
        catch (Exception ex) {
            dataSource = null;
        }
        if (dataSource == null) {
            String jdbcDriver = this.driverClassName = dbConfig.getString("JdbcDriver");
            try {
                Class<?> driverClass = Class.forName(jdbcDriver);
                this.driver = (Driver)driverClass.newInstance();
            }
            catch (ClassNotFoundException except) {
                throw new SQLException("can't load JDBC driver class: " + except.getMessage());
            }
            catch (InstantiationException except) {
                throw new SQLException("can't instantiate JDBC driver class: " + except.getMessage());
            }
            catch (IllegalAccessException except) {
                throw new SQLException("can't instantiate JDBC driver class: " + except.getMessage());
            }
            try {
                this.dbType = dbConfig.getString("ClassType");
            }
            catch (Exception e1) {
                this.dbType = Common.getDatabaseVendor(jdbcDriver);
            }
        }
        try {
            this.dbConf.setDBConnectionFactoryName(dbConfig.getString("ConnectionFactory"));
        }
        catch (Exception jdbcDriver) {
            // empty catch block
        }
        try {
            this.dbConf.setConnectionAllocatorName(dbConfig.getString("ConnectionAllocator"));
        }
        catch (Exception jdbcDriver) {
            // empty catch block
        }
        ConnectionAllocator connectionAllocator = this.loadConnectionAllocator(connectionConfig);
        ObjectIdAllocator objectIdAllocator = this.loadObjectIdAllocator(objIdConfig);
        this.connectionAllocator = connectionAllocator;
        this.objectIdAllocator = objectIdAllocator;
        if (dataSource != null) {
            String databaseType = null;
            String fullDriverClassName = null;
            try {
                ExtendedDBConnection tempConnection = (ExtendedDBConnection)connectionAllocator.allocate();
                String driverName = tempConnection.getConnection().getMetaData().getDriverName();
                tempConnection.release();
                databaseType = Common.getDatabaseVendorFromDriverName(driverName);
                fullDriverClassName = Common.getDatabaseDriverClassFromDriverName(driverName);
            }
            catch (Exception e) {
                try {
                    databaseType = dbConfig.getString("ClassType");
                    fullDriverClassName = dbConfig.getString("JdbcDriver", null);
                }
                catch (Exception e1) {
                    databaseType = Common.getDatabaseVendor(dbConfig.getString("JdbcDriver", null));
                }
            }
            this.dbType = databaseType;
            this.driverClassName = fullDriverClassName;
        }
        this.initDisableFetchSizeWithMaxRows();
        this.initResultSetConcurrency();
        this.initResultSetType();
        try {
            this.dbConf.setDBTransactionFactoryName(dbConfig.getString("TransactionFactory"));
        }
        catch (Exception databaseType) {
            // empty catch block
        }
        this.transactionFactory = DBTransactionFactoryCreator.getDBTransactionFactory(this.dbConf.getDBTransactionFactoryName(), this);
        Config defaultsConfig = dbConfig;
        if (defaultsConfig != null) {
            try {
                this.dbConf.setLazyLoading(defaultsConfig.getBoolean("lazyLoading"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setCaseSensitive(defaultsConfig.getBoolean("CaseSensitive"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setMaxExecuteTime(defaultsConfig.getInt("maxExecuteTime"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setTransactionCheck(defaultsConfig.getBoolean("TransactionCheck"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setDeleteCheckVersion(defaultsConfig.getBoolean("DeleteCheckVersion"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setAutoSave(defaultsConfig.getBoolean("AutoSave"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setAutoSaveCreateVirgin(defaultsConfig.getBoolean("AutoSaveCreateVirgin"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setAutoWrite(defaultsConfig.getBoolean("AutoWrite"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setTransactionCaches(defaultsConfig.getBoolean("TransactionCaches"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setDeadlockWaitTime(defaultsConfig.getInt("CacheLockTimeout"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setDeadlockRetryCount(defaultsConfig.getInt("CacheLockRetryCount"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setReadOnly(defaultsConfig.getBoolean("AllReadOnly"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setDefaultFetchSize(defaultsConfig.getInt("DefaultFetchSize"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setQueryTimeout(defaultsConfig.getInt("QueryTimeout"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setSelectOids(defaultsConfig.getBoolean("SelectOids"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                this.dbConf.setIncrementVersions(defaultsConfig.getBoolean("IncrementVersions"));
            }
            catch (Exception fullDriverClassName) {
                // empty catch block
            }
            try {
                boolean tmpSCrN = defaultsConfig.getBoolean("UseCursorName");
                this.dbConf.setUseCursorName(tmpSCrN);
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setFullCacheCountLimit(defaultsConfig.getInt("FullCacheCountLimit"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setQueryCacheImplClass(defaultsConfig.getString("QueryCacheImplClass"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setInitCachesResultSetType(defaultsConfig.getString("InitCachesResultSetType"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setInitCachesResultSetConcurrency(defaultsConfig.getString("InitCachesResultSetConcurrency"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setSqlBatch(defaultsConfig.getBoolean("SQLBatch"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setQueryTimeLimit(new Integer(defaultsConfig.getInt("QueryTimeLimit")));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setXaDefaultTimeout(defaultsConfig.getInt("XADefaultTimeout"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setXaTransactonManagerLookupName(defaultsConfig.getString("XATransactonManagerLookupName"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setXaUsageCase(defaultsConfig.getInt("XAUsageCase"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setXaWrappedTransImplFactory(defaultsConfig.getString("XAWrappedTransImplFactory"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setXaUserTransactonLookupName(defaultsConfig.getString("XaUserTransactonLookupName"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
            try {
                this.dbConf.setXaJtaSupport(defaultsConfig.getString("JTASupport"));
            }
            catch (Exception tmpSCrN) {
                // empty catch block
            }
        }
        try {
            defaultsConfig = (Config)dbConfig.getSection("cache");
        }
        catch (KeywordValueException except) {
            throw new ConfigException("No DatabaseManager.defaults defined in config file.");
        }
        if (defaultsConfig != null) {
            try {
                this.dbConf.setReserveFactor(defaultsConfig.getDouble("reserveFactor"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dbConf.setCachePercentage(defaultsConfig.getDouble("CachePercentage"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dbConf.setMaxCacheSize(defaultsConfig.getInt("maxCacheSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dbConf.setMaxSimpleCacheSize(defaultsConfig.getInt("maxSimpleCacheSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dbConf.setMaxComplexCacheSize(defaultsConfig.getInt("maxComplexCacheSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dbConf.setMaxMultiJoinCacheSize(defaultsConfig.getInt("maxMultiJoinCacheSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dbConf.setInitialCacheFetchSize(defaultsConfig.getInt("InitialCacheFetchSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dbConf.setInitialDSCacheSize(defaultsConfig.getInt("InitialDSCacheSize"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dbConf.setDodsCacheFactory(defaultsConfig.getString("DODSCacheFactory"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void checkOId(ObjectId oid) throws ObjectIdException {
        this.objectIdAllocator.checkOId(oid);
    }

    public ConnectionAllocator loadConnectionAllocator(Config connectionConfig) throws ConfigException {
        Class<?> connectionAllocatorClass = null;
        Constructor<?> connectionAllocatorConstructor = null;
        Class[] methodTypes = new Class[]{LogicalDatabase.class, connectionConfig.getClass()};
        Object[] methodArgs = new Object[]{this, connectionConfig};
        ConnectionAllocator allocator = null;
        if (this.dbConf.getConnectionAllocatorName() != null) {
            try {
                connectionAllocatorClass = Class.forName(this.dbConf.getConnectionAllocatorName());
                connectionAllocatorConstructor = connectionAllocatorClass.getConstructor(methodTypes);
                allocator = (ConnectionAllocator)connectionAllocatorConstructor.newInstance(methodArgs);
            }
            catch (Exception e) {
                DODS.getLogChannel().write(3, "Failed to make Connection Allocator :" + this.dbConf.getConnectionAllocatorName() + " creating StandardConnectionAllocator insted");
                allocator = null;
            }
        }
        if (this.dbConf.getConnectionAllocatorName() == null || allocator == null) {
            try {
                connectionAllocatorClass = Class.forName("com.lutris.appserver.server.sql.standard.StandardConnectionAllocator");
                connectionAllocatorConstructor = connectionAllocatorClass.getConstructor(methodTypes);
                allocator = (ConnectionAllocator)connectionAllocatorConstructor.newInstance(methodArgs);
            }
            catch (Exception e) {
                String str = "Failed to make Standard Connection Allocator : com.lutris.appserver.server.sql.standard.StandardConnectionAllocator";
                DODS.getLogChannel().write(2, str);
                throw new Error(str);
            }
        }
        return allocator;
    }

    public ObjectIdAllocator loadObjectIdAllocator(Config objIdConfig) throws ConfigException {
        return new StandardObjectIdAllocator(this, objIdConfig);
    }

    public DBConnection allocateConnection() throws SQLException {
        return this.connectionAllocator.allocate();
    }

    public ObjectId allocateObjectId() throws ObjectIdException {
        return this.objectIdAllocator.allocate();
    }

    public DBTransaction createTransaction() throws SQLException {
        return this.transactionFactory.getTransaction(this.connectionAllocator.allocate());
    }

    public DBQuery createQuery() throws SQLException {
        return new StandardDBQuery(this.connectionAllocator.allocate());
    }

    public void shutdown() {
        this.connectionAllocator.dropAllNow();
        this.driver = null;
    }

    public String getName() {
        return this.dbName;
    }

    public String getType() {
        return this.dbType;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public String getDriverProperty(String paramName) {
        String key = "Drivers/" + this.driverClassName + "/" + paramName;
        return Common.getDodsConfProperty(key, this.dbType);
    }

    public int getActiveConnectionCount() {
        return this.connectionAllocator.getActiveCount();
    }

    public int getMaxConnectionCount() {
        return this.connectionAllocator.getMaxCount();
    }

    public Date getMaxConnectionCountDate() {
        return this.connectionAllocator.getMaxCountDate();
    }

    public void resetMaxConnectionCount() {
        this.connectionAllocator.resetMaxCount();
    }

    public long getRequestCount() {
        return this.connectionAllocator.getRequestCount();
    }

    public DatabaseConfiguration getDatabaseConfiguration() {
        return this.dbConf;
    }

    public boolean getDisableFetchSizeWithMaxRows() {
        return this.dbConf.getDisableFetchSizeWithMaxRows();
    }

    private void initDisableFetchSizeWithMaxRows() {
        String tmpDFSWMR = this.getDriverProperty("DisableFetchSizeWithMaxRows");
        if (tmpDFSWMR == null) {
            this.dbConf.setDisableFetchSizeWithMaxRows(false);
        } else if (tmpDFSWMR.equalsIgnoreCase("true")) {
            this.dbConf.setDisableFetchSizeWithMaxRows(true);
        } else if (tmpDFSWMR.equalsIgnoreCase("false")) {
            this.dbConf.setDisableFetchSizeWithMaxRows(false);
        } else {
            DODS.getLogChannel().write(7, "Invalid value for DisableFetchSizeWithMaxRows parameter :" + tmpDFSWMR);
            this.dbConf.setDisableFetchSizeWithMaxRows(false);
        }
    }

    public boolean getUseCursorName() {
        if (this.dbConf.getUseCursorName() == null) {
            String tmpUCrN = this.getDriverProperty("UseCursorName");
            if (tmpUCrN == null) {
                return true;
            }
            if (tmpUCrN.equalsIgnoreCase("true")) {
                this.setUseCursorName(true);
                return true;
            }
            if (tmpUCrN.equalsIgnoreCase("false")) {
                this.setUseCursorName(false);
                return false;
            }
            DODS.getLogChannel().write(7, "Invalid value for UseCursorName parameter :" + tmpUCrN);
            return true;
        }
        return this.dbConf.getUseCursorName();
    }

    public void setUseCursorName(boolean use) {
        this.dbConf.setUseCursorName(use);
    }

    public void setUseCursorName(Boolean use) {
        this.dbConf.setUseCursorName(use);
    }

    private void initResultSetType() {
        String tmpUCrN = this.getDriverProperty("ResultSetType");
        try {
            if (tmpUCrN == null) {
                this.dbConf.setResultSetType(-1);
            }
            if (tmpUCrN.equalsIgnoreCase("TYPE_SCROLL_SENSITIVE")) {
                this.dbConf.setResultSetType(1005);
            } else if (tmpUCrN.equalsIgnoreCase("TYPE_SCROLL_INSENSITIVE")) {
                this.dbConf.setResultSetType(1004);
            } else if (tmpUCrN.equalsIgnoreCase("TYPE_FORWARD_ONLY")) {
                this.dbConf.setResultSetType(1003);
            } else {
                DODS.getLogChannel().write(7, "Invalid value for ResultSetType parameter :" + tmpUCrN);
                this.dbConf.setResultSetType(-1);
            }
        }
        catch (Exception ex) {
            DODS.getLogChannel().write(7, "Use default value for ResultSetType parameter ");
        }
    }

    public int getResultSetType() {
        return this.dbConf.getResultSetType();
    }

    private void initResultSetConcurrency() {
        String tmpUCrN = this.getDriverProperty("ResultSetConcurrency");
        try {
            if (tmpUCrN == null) {
                this.dbConf.setResultSetConcurrency(-1);
            }
            if (tmpUCrN.equalsIgnoreCase("CONCUR_READ_ONLY")) {
                this.dbConf.setResultSetConcurrency(1007);
            } else if (tmpUCrN.equalsIgnoreCase("CONCUR_UPDATABLE")) {
                this.dbConf.setResultSetConcurrency(1008);
            } else {
                DODS.getLogChannel().write(7, "Invalid value for ResultSetConcurrency parameter :" + tmpUCrN);
                this.dbConf.setResultSetConcurrency(-1);
            }
        }
        catch (Exception ex) {
            DODS.getLogChannel().write(7, "Use default value for ResultSetType parameter ");
        }
    }

    public int getResultSetConcurrency() {
        return this.dbConf.getResultSetConcurrency();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DriverDependencies getDriverDependencies() {
        if (null != this.drivDepsInstance) return this.drivDepsInstance;
        String className = this.getDriverProperty(PARAMNAME_DRIV_DEP_CLASS);
        try {
            if (null != className) {
                this.drivDepsInstance = (DriverDependencies)Class.forName(className).newInstance();
            }
            if (null != this.drivDepsInstance) return this.drivDepsInstance;
        }
        catch (Exception e) {
            try {
                DODS.getLogChannel().write(3, "Didn't instantiated DriverDepenencies " + className, (Throwable)e);
                if (null != this.drivDepsInstance) return this.drivDepsInstance;
            }
            catch (Throwable throwable) {
                if (null != this.drivDepsInstance) throw throwable;
                this.drivDepsInstance = new DriverDependencies(){

                    @Override
                    public boolean isBlobAccessSpecial() {
                        return false;
                    }

                    @Override
                    public byte[] readBlob(ResultSet rs, String c) {
                        return null;
                    }

                    @Override
                    public void insertBlob(DBConnection conn, byte[] cont, RDBColumn primary, RDBColumn blobColumn, String handle) {
                    }
                };
                throw throwable;
            }
            this.drivDepsInstance = new /* invalid duplicate definition of identical inner class */;
            return this.drivDepsInstance;
        }
        this.drivDepsInstance = new /* invalid duplicate definition of identical inner class */;
        return this.drivDepsInstance;
    }
}

