/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.dods.statistics;

import java.util.Date;
import org.enhydra.dods.statistics.CacheStatistics;
import org.enhydra.dods.statistics.Statistics;

public class TableStatistics
implements Statistics {
    protected int insertNum = 0;
    protected int updateNum = 0;
    protected int deleteNum = 0;
    protected int lazyLoadingNum = 0;
    protected Date startTime;
    protected Date stopTime;
    protected int queryNum = 0;
    protected int queryByOIdNum = 0;
    protected int averageQueryTime = 0;
    protected int averageQueryByOIdTime = 0;

    public TableStatistics() {
        this.clears();
    }

    public int getStatisticsType() {
        return 0;
    }

    public int getInsertNum() {
        return this.insertNum;
    }

    public void setInsertNum(int newInsertNum) {
        this.insertNum = newInsertNum;
    }

    public void incrementInsertNum() {
        ++this.insertNum;
    }

    public int getUpdateNum() {
        return this.updateNum;
    }

    public void setUpdateNum(int newUpdateNum) {
        this.updateNum = newUpdateNum;
    }

    public void incrementUpdateNum() {
        ++this.updateNum;
    }

    public int getDeleteNum() {
        return this.deleteNum;
    }

    public void setDeleteNum(int newDeleteNum) {
        this.deleteNum = newDeleteNum;
    }

    public void incrementDeleteNum() {
        ++this.deleteNum;
    }

    public int getDMLNum() {
        return this.insertNum + this.updateNum + this.deleteNum;
    }

    public int getLazyLoadingNum() {
        return this.lazyLoadingNum;
    }

    public void setLazyLoadingNum(int newLazyLoadingNum) {
        this.lazyLoadingNum = newLazyLoadingNum;
    }

    public void incrementLazyLoadingNum() {
        ++this.lazyLoadingNum;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStopTime() {
        return this.stopTime;
    }

    public void setStopTime(Date stopTime) {
        this.stopTime = stopTime;
    }

    public void stopTime() {
        this.stopTime = new Date();
    }

    public int getQueryNum() {
        return this.queryNum;
    }

    public void setQueryNum(int newQueryNum) {
        this.queryNum = newQueryNum;
    }

    public void incrementQueryNum() {
        ++this.queryNum;
    }

    public int getQueryByOIdNum() {
        return this.queryByOIdNum;
    }

    public void setQueryByOIdNum(int newQueryByOIdNum) {
        this.queryByOIdNum = newQueryByOIdNum;
    }

    public void incrementQueryByOIdNum() {
        ++this.queryByOIdNum;
    }

    public int getQueryAverageTime() {
        return this.averageQueryTime;
    }

    public void updateQueryAverageTime(int newTime) {
        long sum = 0L;
        if (this.queryNum > 0) {
            sum = (this.queryNum - 1) * this.averageQueryTime + newTime;
            this.averageQueryTime = new Long(sum /= (long)this.queryNum).intValue();
        }
    }

    public int getQueryByOIdAverageTime() {
        return this.averageQueryByOIdTime;
    }

    public void updateQueryByOIdAverageTime(int newTime, int no) {
        if (no > 0) {
            long sum = 0L;
            if (this.queryByOIdNum > 0) {
                sum = this.queryByOIdNum * this.averageQueryByOIdTime + newTime;
                this.queryByOIdNum += no;
                this.averageQueryByOIdTime = new Long(sum /= (long)this.queryByOIdNum).intValue();
            } else {
                sum = newTime;
                this.queryByOIdNum += no;
                this.averageQueryByOIdTime = new Long(sum /= (long)this.queryByOIdNum).intValue();
            }
        }
    }

    public void clears() {
        this.insertNum = 0;
        this.updateNum = 0;
        this.deleteNum = 0;
        this.lazyLoadingNum = 0;
        this.startTime = new Date();
        this.stopTime = new Date();
        this.queryNum = 0;
        this.queryByOIdNum = 0;
        this.averageQueryTime = 0;
        this.averageQueryByOIdTime = 0;
    }

    public void clear() {
        this.clears();
    }

    public CacheStatistics getCacheStatistics(int type) {
        return null;
    }
}

