/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql;

import com.lutris.appserver.server.sql.standard.DriverSpecificConstants;
import com.lutris.util.Config;
import org.enhydra.dods.CommonConstants;
import org.enhydra.dods.DODS;
import org.enhydra.dods.cache.CacheConstants;

public class DatabaseManagerConfiguration
implements CacheConstants,
DriverSpecificConstants {
    private boolean lazyLoading = false;
    private boolean caseSensitive = false;
    private int maxExecuteTime = 0;
    private double reserveFactor = 0.0;
    private double cachePercentage = -1.0;
    private int maxCacheSize = 0;
    private int maxSimpleCacheSize = 0;
    private int maxComplexCacheSize = 0;
    private int maxMultiJoinCacheSize = 0;
    private boolean transactionCheck = false;
    private boolean deleteCheckVersion = false;
    private boolean autoSave = false;
    private boolean autoSaveCreateVirgin = false;
    private boolean autoWrite = false;
    private boolean transactionCaches = false;
    private int deadlockWaitTime = 0;
    private int deadlockRetryCount = 0;
    private int queryTimeout = 0;
    private boolean selectOids = false;
    private boolean incrementVersions = true;
    private int defaultFetchSize = -1;
    private boolean initialAllCaches = false;
    private boolean allReadOnly = false;
    private Boolean useCursorName = null;
    private String userConfigWildcard = null;
    private String userConfigSingleWildcard = null;
    private String userConfigSingleWildcardEscape = null;
    private String userConfigWildcardEscape = null;
    private String DBTransactionFactoryName = null;
    private String connectionAllocatorName = null;
    private String DBConnectionFactoryName = null;
    private int fullCacheCountLimit = -1;
    private int initialCacheFetchSize = 0;
    private int initialDSCacheSize = -1;
    private String queryCacheImplClass = null;
    private String initCachesResultSetType = null;
    private String initCachesResultSetConcurrency = null;
    private boolean sqlBatch = false;
    private boolean caseInsensitiveDatabase = false;
    private Integer queryTimeLimit = CommonConstants.DEFAULT_QUERY_TIME_LIMIT;
    private int xaDefaultTimeout = 120;
    private int xaUsageCase = 0;
    private String xaTransactonManagerLookupName = "java:comp/UserTransaction";
    private String xaUserTransactonLookupName = "java:comp/UserTransaction";
    private String xaWrappedTransImplFactory = "com.lutris.appserver.server.sql.standard.StandardDBTransactionFactory";
    private String xaJtaSupport = "REQUIRED";
    private String dodsCacheFactory = "org.enhydra.dods.cache.lru.DODSLRUCacheFactory";

    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean newValue) {
        this.caseSensitive = newValue;
    }

    protected void setLazyLoading(boolean newlazyLoading) {
        this.lazyLoading = newlazyLoading;
    }

    public int getMaxExecuteTime() {
        return this.maxExecuteTime;
    }

    protected void setMaxExecuteTime(int newMaxExecuteTime) {
        this.maxExecuteTime = newMaxExecuteTime;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    protected void setMaxCacheSize(int newMaxCacheSize) {
        this.maxCacheSize = newMaxCacheSize;
    }

    public double getReserveFactor() {
        return this.reserveFactor;
    }

    protected void setReserveFactor(double newReserveFactor) {
        this.reserveFactor = newReserveFactor;
    }

    protected void setCachePercentage(double percent) {
        this.cachePercentage = percent;
    }

    public double getCachePercentage() {
        return this.cachePercentage;
    }

    public int getMaxComplexCacheSize() {
        return this.maxComplexCacheSize;
    }

    protected void setMaxComplexCacheSize(int newMaxCacheSize) {
        this.maxComplexCacheSize = newMaxCacheSize;
    }

    public int getMaxMultiJoinCacheSize() {
        return this.maxMultiJoinCacheSize;
    }

    protected void setMaxMultiJoinCacheSize(int newMaxCacheSize) {
        this.maxMultiJoinCacheSize = newMaxCacheSize;
    }

    public int getMaxSimpleCacheSize() {
        return this.maxSimpleCacheSize;
    }

    protected void setMaxSimpleCacheSize(int newMaxCacheSize) {
        this.maxSimpleCacheSize = newMaxCacheSize;
    }

    public boolean getTransactionCheck() {
        return this.transactionCheck;
    }

    protected void setTransactionCheck(boolean newCheck) {
        this.transactionCheck = newCheck;
    }

    public boolean getDeleteCheckVersion() {
        return this.deleteCheckVersion;
    }

    protected void setDeleteCheckVersion(boolean newCheck) {
        this.deleteCheckVersion = newCheck;
    }

    public boolean getAutoSave() {
        return this.autoSave;
    }

    protected void setAutoSave(boolean newCheck) {
        this.autoSave = newCheck;
    }

    public boolean getAutoSaveCreateVirgin() {
        return this.autoSaveCreateVirgin;
    }

    protected void setAutoSaveCreateVirgin(boolean newCheck) {
        this.autoSaveCreateVirgin = newCheck;
    }

    public boolean getAutoWrite() {
        return this.autoWrite;
    }

    protected void setAutoWrite(boolean newCheck) {
        this.autoWrite = newCheck;
    }

    public boolean getTransactionCaches() {
        return this.transactionCaches;
    }

    protected void setTransactionCaches(boolean newCheck) {
        this.transactionCaches = newCheck;
    }

    public int getDeadlockWaitTime() {
        return this.deadlockWaitTime;
    }

    protected void setDeadlockWaitTime(int waitTime) {
        this.deadlockWaitTime = waitTime;
    }

    public int getDeadlockRetryCount() {
        return this.deadlockRetryCount;
    }

    protected void setDeadlockRetryCount(int newValue) {
        this.deadlockRetryCount = newValue;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    protected void setQueryTimeout(int newValue) {
        this.queryTimeout = newValue;
    }

    public boolean getSelectOids() {
        return this.selectOids;
    }

    protected void setSelectOids(boolean newValue) {
        this.selectOids = newValue;
    }

    public boolean getIncrementVersions() {
        return this.incrementVersions;
    }

    protected void setIncrementVersions(boolean newValue) {
        this.incrementVersions = newValue;
    }

    public int getDefaultFetchSize() {
        return this.defaultFetchSize;
    }

    protected void setDefaultFetchSize(int newValue) {
        this.defaultFetchSize = newValue;
    }

    public boolean getInitAllCaches() {
        return this.initialAllCaches;
    }

    protected void setInitAllCaches(boolean newValue) {
        this.initialAllCaches = newValue;
    }

    public Boolean getUseCursorName() {
        return this.useCursorName;
    }

    public void setUseCursorName(boolean newValue) {
        this.useCursorName = new Boolean(newValue);
    }

    public void setUseCursorName(Boolean newValue) {
        this.useCursorName = newValue;
    }

    public String getUserConfigSingleWildcard() {
        return this.userConfigSingleWildcard;
    }

    public String getUserConfigSingleWildcardEscape() {
        return this.userConfigSingleWildcardEscape;
    }

    public String getUserConfigWildcard() {
        return this.userConfigWildcard;
    }

    public String getUserConfigWildcardEscape() {
        return this.userConfigWildcardEscape;
    }

    public void setUserConfigSingleWildcard(String newValue) {
        this.userConfigSingleWildcard = newValue;
    }

    public void setUserConfigSingleWildcardEscape(String newValue) {
        this.userConfigSingleWildcardEscape = newValue;
    }

    public void setUserConfigWildcard(String newValue) {
        this.userConfigWildcard = newValue;
    }

    public void setUserConfigWildcardEscape(String newValue) {
        this.userConfigWildcardEscape = newValue;
    }

    public boolean isAllReadOnly() {
        return this.allReadOnly;
    }

    public void setAllReadOnly(boolean newValue) {
        this.allReadOnly = newValue;
    }

    public String getDBTransactionFactoryName() {
        return this.DBTransactionFactoryName;
    }

    public void setDBTransactionFactoryName(String string) {
        this.DBTransactionFactoryName = string;
    }

    public String getConnectionAllocatorName() {
        return this.connectionAllocatorName;
    }

    public void setConnectionAllocatorName(String string) {
        this.connectionAllocatorName = string;
    }

    public int getFullCacheCountLimit() {
        return this.fullCacheCountLimit;
    }

    public void setFullCacheCountLimit(int i) {
        this.fullCacheCountLimit = i;
    }

    public void readDatabaseManagerConfiguration() {
        Config databaseConfig = null;
        Config userConfig = null;
        try {
            userConfig = (Config)DODS.getDatabaseManager().getConfig().getSection("DB.User");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (userConfig != null) {
            try {
                this.userConfigWildcard = userConfig.getString("userWildcard");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.userConfigSingleWildcard = userConfig.getString("userSingleWildcard");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.userConfigSingleWildcardEscape = userConfig.getString("userSingleWildcardEscape");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.userConfigWildcardEscape = userConfig.getString("userWildcardEscape");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            databaseConfig = (Config)DODS.getDatabaseManager().getConfig().getSection("defaults");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (databaseConfig != null) {
            try {
                this.allReadOnly = databaseConfig.getBoolean("AllReadOnly");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.lazyLoading = databaseConfig.getBoolean("lazyLoading");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.caseSensitive = databaseConfig.getBoolean("CaseSensitive");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxExecuteTime = databaseConfig.getInt("maxExecuteTime");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.transactionCheck = databaseConfig.getBoolean("TransactionCheck");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.deleteCheckVersion = databaseConfig.getBoolean("DeleteCheckVersion");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.autoSave = databaseConfig.getBoolean("AutoSave");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.autoSaveCreateVirgin = databaseConfig.getBoolean("AutoSaveCreateVirgin");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.autoWrite = databaseConfig.getBoolean("AutoWrite");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.transactionCaches = databaseConfig.getBoolean("TransactionCaches");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.deadlockWaitTime = databaseConfig.getInt("CacheLockTimeout");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.deadlockRetryCount = databaseConfig.getInt("CacheLockRetryCount");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.queryTimeout = databaseConfig.getInt("QueryTimeout");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.selectOids = databaseConfig.getBoolean("SelectOids");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.incrementVersions = databaseConfig.getBoolean("IncrementVersions");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.defaultFetchSize = databaseConfig.getInt("DefaultFetchSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                boolean tmpUCrN = databaseConfig.getBoolean("UseCursorName");
                this.useCursorName = new Boolean(tmpUCrN);
            }
            catch (Exception e) {
                this.useCursorName = null;
            }
            try {
                this.DBTransactionFactoryName = databaseConfig.getString("TransactionFactory");
            }
            catch (Exception e) {
                this.DBTransactionFactoryName = null;
            }
            try {
                this.queryCacheImplClass = databaseConfig.getString("QueryCacheImplClass");
            }
            catch (Exception e) {
                this.queryCacheImplClass = null;
            }
            try {
                this.connectionAllocatorName = databaseConfig.getString("ConnectionAllocator");
            }
            catch (Exception e) {
                this.connectionAllocatorName = null;
            }
            try {
                this.DBConnectionFactoryName = databaseConfig.getString("ConnectionFactory");
            }
            catch (Exception e) {
                this.DBConnectionFactoryName = null;
            }
            try {
                this.fullCacheCountLimit = databaseConfig.getInt("FullCacheCountLimit");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.initCachesResultSetType = databaseConfig.getString("InitCachesResultSetType");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.initCachesResultSetConcurrency = databaseConfig.getString("InitCachesResultSetConcurrency");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.sqlBatch = databaseConfig.getBoolean("SQLBatch");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.caseInsensitiveDatabase = databaseConfig.getBoolean("CaseInsensitiveDatabase");
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                this.queryTimeLimit = new Integer(databaseConfig.getInt("QueryTimeLimit"));
            }
            catch (Exception e) {
                this.queryTimeLimit = null;
            }
            try {
                this.xaDefaultTimeout = databaseConfig.getInt("XADefaultTimeout");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.xaTransactonManagerLookupName = databaseConfig.getString("XATransactonManagerLookupName");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.xaUsageCase = databaseConfig.getInt("XAUsageCase");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.xaWrappedTransImplFactory = databaseConfig.getString("XAWrappedTransImplFactory");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.xaUserTransactonLookupName = databaseConfig.getString("XaUserTransactonLookupName");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.xaJtaSupport = databaseConfig.getString("JTASupport");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            databaseConfig = (Config)DODS.getDatabaseManager().getConfig().getSection("defaults.cache");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (databaseConfig != null) {
            try {
                this.reserveFactor = databaseConfig.getDouble("reserveFactor");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.cachePercentage = databaseConfig.getDouble("CachePercentage");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxCacheSize = databaseConfig.getInt("maxCacheSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxSimpleCacheSize = databaseConfig.getInt("maxSimpleCacheSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxComplexCacheSize = databaseConfig.getInt("maxComplexCacheSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.maxMultiJoinCacheSize = databaseConfig.getInt("maxMultiJoinCacheSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initialAllCaches = databaseConfig.getBoolean("initAllCaches");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initialCacheFetchSize = databaseConfig.getInt("InitialCacheFetchSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.initialDSCacheSize = databaseConfig.getInt("InitialDSCacheSize");
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.dodsCacheFactory = databaseConfig.getString("DODSCacheFactory");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getDBConnectionFactoryName() {
        return this.DBConnectionFactoryName;
    }

    public void setDBConnectionFactoryName(String string) {
        this.DBConnectionFactoryName = string;
    }

    public int getInitialCacheFetchSize() {
        return this.initialCacheFetchSize;
    }

    public int getInitialDSCacheSize() {
        return this.initialDSCacheSize;
    }

    public void setInitialCacheFetchSize(int i) {
        this.initialCacheFetchSize = i;
    }

    public void setInitialDSCacheSize(int i) {
        this.initialDSCacheSize = i;
    }

    public String getQueryCacheImplClass() {
        return this.queryCacheImplClass;
    }

    public void setQueryCacheImplClass(String string) {
        this.queryCacheImplClass = string;
    }

    public String getInitCachesResultSetConcurrency() {
        return this.initCachesResultSetConcurrency;
    }

    public String getInitCachesResultSetType() {
        return this.initCachesResultSetType;
    }

    public void setInitCachesResultSetConcurrency(String string) {
        this.initCachesResultSetConcurrency = string;
    }

    public void setInitCachesResultSetType(String string) {
        this.initCachesResultSetType = string;
    }

    public boolean isSqlBatch() {
        return this.sqlBatch;
    }

    public void setSqlBatch(boolean b) {
        this.sqlBatch = b;
    }

    public boolean isCaseInsensitiveDatabase() {
        return this.caseInsensitiveDatabase;
    }

    public void setCaseInsensitiveDatabase(boolean caseInsensitiveDatabase) {
        this.caseInsensitiveDatabase = caseInsensitiveDatabase;
    }

    public Integer getQueryTimeLimit() {
        return this.queryTimeLimit;
    }

    public void setQueryTimeLimit(Integer queryTimeLimit) {
        this.queryTimeLimit = queryTimeLimit;
    }

    public int getXaDefaultTimeout() {
        return this.xaDefaultTimeout;
    }

    public void setXaDefaultTimeout(int xaDefaultTimeout) {
        this.xaDefaultTimeout = xaDefaultTimeout;
    }

    public String getXaTransactonManagerLookupName() {
        return this.xaTransactonManagerLookupName;
    }

    public void setXaTransactonManagerLookupName(String xaTransactonManagerLookupName) {
        this.xaTransactonManagerLookupName = xaTransactonManagerLookupName;
    }

    public int getXaUsageCase() {
        return this.xaUsageCase;
    }

    public void setXaUsageCase(int xaUsageCase) {
        this.xaUsageCase = xaUsageCase;
    }

    public String getXaWrappedTransImplFactory() {
        return this.xaWrappedTransImplFactory;
    }

    public void setXaWrappedTransImplFactory(String xaWrappedTransImplFactory) {
        this.xaWrappedTransImplFactory = xaWrappedTransImplFactory;
    }

    public String getXaUserTransactonLookupName() {
        return this.xaUserTransactonLookupName;
    }

    public void setXaUserTransactonLookupName(String xaUserTransactonLookupName) {
        this.xaUserTransactonLookupName = xaUserTransactonLookupName;
    }

    public String getXaJtaSupport() {
        return this.xaJtaSupport;
    }

    public void setXaJtaSupport(String xaJtaSupport) {
        this.xaJtaSupport = xaJtaSupport;
    }

    public String getDodsCacheFactory() {
        return this.dodsCacheFactory;
    }

    public void setDodsCacheFactory(String dodsCacheFactory) {
        this.dodsCacheFactory = dodsCacheFactory;
    }
}

