
/**
 * Title:        WebDocWf AccessException<p>
 * Description:  AccessException is thrown if a User does not have the right to execute a certain DODS access or an error accurs during evaluation of rights<p>
 * Copyright:    Copyright (c) Together Teamlösungen EDV-Dienstleistungen GmbH. under LGPL<p>
 * Company:      Together Teamlösungen EDV-Dienstleistungen GmbH.<p>
 * @author Alfred Madl (a.madl@together.at)
 * @version 1.0
 */
package org.webdocwf.dods.access;

import java.io.PrintStream ;
import java.io.PrintWriter ;
import org.enhydra.dods.exceptions.DodsBaseException;

public abstract class AccessException extends DodsBaseException {
    public User usr = null;
    public String  operation = null;
    public SecureDO obj = null;
    public String  className = null;
    public String  attrName = null;
    public String  value = null;
    public String  oldValue = null;
    public String  datatype = null;
    public String  cmp_op = null;

    /**
     * Construct an exception with a message and detail data.
     *
     * @param msg The message associated with the exception.
     * @param inUsr The user for the access right check
     * @param inOperation The desired operation
     * @param inObj The accessed object
     * @param inClassName The accessed class
     * @param inAttrName The accessed attribute
     * @param inValue The accessed value
     * @param inOldValue The new value in set-operations
     * @param inDatatype The datatype of the value
     * @param inCmp_op The comparison operator for queries
     */
    public AccessException(String  msg, User inUsr, String  inOperation, SecureDO inObj, String  inClassName, String  inAttrName, String  inValue, String  inOldValue, String  inDatatype, String  inCmp_op) {
        super(msg);
        usr = inUsr;
        operation = inOperation;
        obj = inObj;
        className = inClassName;
        attrName = inAttrName;
        value = inValue;
        oldValue = inOldValue;
        datatype = inDatatype;
        cmp_op = inCmp_op;    
    }

    /**
     * Construct an exception with a message and detail data.
     *
     * @param msg The message associated with the exception.
     * @param cause The error or exception that cause this
     *  exception.
     * @param inUsr The user for the access right check
     * @param inOperation The desired operation
     * @param inObj The accessed object
     * @param inClassName The accessed class
     * @param inAttrName The accessed attribute
     * @param inValue The accessed value
     * @param inOldValue The new value in set-operations
     * @param inDatatype The datatype of the value
     * @param inCmp_op The comparison operator for queries
     */
    public AccessException(String  msg, Throwable  cause, User inUsr, String  inOperation, SecureDO inObj, String  inClassName, String  inAttrName, String  inValue, String  inOldValue, String  inDatatype, String  inCmp_op) {
        super(msg, cause);
        usr = inUsr;
        operation = inOperation;
        obj = inObj;
        className = inClassName;
        attrName = inAttrName;
        value = inValue;
        oldValue = inOldValue;
        datatype = inDatatype;
        cmp_op = inCmp_op;    
    }

    /**
     * Construct an exception with a message
     *
     * @param msg The message associated with the exception.
     */
    public AccessException(String  msg) {
        super(msg);
    }

    /**
     * Construct an exception with a message
     *
     * @param msg The message associated with the exception.
     * @param cause The error or exception that cause this
     *  exception.
     */
    public AccessException(String  msg, Throwable  cause) {
        super(msg, cause);
    }

    /**
     * Prints the details
     */
    private void printDetails(PrintWriter  out) {
        if (usr != null) {
            out.println("User : " + usr.getName());
        }
        if (operation != null) {
            out.println("Operation : " + operation);
        }
        if (obj != null) {
            out.println("Object OID: " + obj.get_OId());
        }
        if (obj != null) {
            out.println("Object class: " + obj.getClass().getName());
        }
        if (className != null) {
            out.println("Class name : " + className);
        }
        if (attrName != null) {
            out.println("Attribute name : " + attrName);
        }
        if (value != null) {
            out.println("Value : " + value);
        }
        if (oldValue != null) {
            out.println("Old value : " + oldValue);
        }
        if (datatype != null) {
            out.println("Datatype : " + datatype);
        }
        if (cmp_op != null) {
            out.println("Comparison operator : " + cmp_op);
        }
    }

    /**
     * Prints this Exception and its data to the standard error stream. 
     */
    public void printStackTrace() {
        super.printStackTrace();
        printTrace();
    }

    /**
     * Prints this Exception and its data to the e specified print stream. 
     */
    public void printStackTrace(PrintStream  s) {
        super.printStackTrace(s);
        printTrace(s);
    }

    /**
     * Prints this Exception and its data to the e specified print writer. 
     */
    public void printStackTrace(PrintWriter  s) {
        super.printStackTrace(s);
        printTrace(s);
    }

    /**
     * Prints stacktrace
     */
    protected void printTrace() {
        PrintWriter  pw = new PrintWriter (System.err);

        printDetails(pw);
        pw.flush();
    }

    /**
     * Prints stacktrace
     */
    protected void printTrace(PrintStream  s) {
        PrintWriter  pw = new PrintWriter (s);

        printDetails(pw);
        pw.flush();
    }

    /**
     * Prints stacktrace
     */
    public void printTrace(PrintWriter  out) {
        printDetails(out);
        out.flush();
    }
}
