
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 */
package org.enhydra.dods.wizard;

import java.io.File ;

/**
 * DomlFilter restricts file sets to only those files that are
 * .doml files. Use this with JFileChooser to create a directory
 * chooser.
 *
 *
 * @author Nenad Vico
 */
public class DomlFilter extends javax.swing.filechooser.FileFilter  {

    /**
     * Create a DomlFilter for use with the FileChooser dialog.
     */
    public DomlFilter() {}

    /**
     * Check to see if the passed file is a directory.
     *
     * @param f File to check.
     *
     * @return True if the file is a doml file (.doml).
     *
     */
    public boolean accept(File  f) {
        return f.getName().endsWith(".doml") || f.isDirectory();
    }

    /**
     * Get a description of this filter.
     *
     * @return The description of this filter.
     *
     */
    public String  getDescription() {
        return new String (".doml");
    }
}
