
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 */
package org.enhydra.dods.cache;

import java.util.Vector ;
import com.lutris.dods.builder.generator.dataobject.GenericDO;

/**
 * This class stores results of one query. 
 *
 * @author    Tanja Jovanovic
 * @version   2.0  15.06.2003.
 */
public class QueryResult {

    /**
     * Vector with results.
     */
    public Vector  DOs;
    
    /**
     * Vector with objects (from result) which have data set to null.
     */
    public Vector  lazy;
    
    /**
     * Database of the query result.
     */
    public String  database;
   
    /**
     * Number of results skipped because are not unique.
     */
    public int skippedUnique = 0;
   
    /**
     * Constructor().  
     */
    public QueryResult() {
        DOs = new Vector ();
        lazy = new Vector ();
        skippedUnique = 0;
    }

    /**
     * Shows content of this class.  
     * Can be used for debugging.
     */
    public String  toString() {
        return toString(false);
    }

    /**
     * Shows content of this class.  
     * Can be used for debugging.
     */
    public String  toString(boolean onlyID) {
        GenericDO DO = null;
        StringBuffer  ret = new StringBuffer ();

        ret.append("\n ----------------- QueryResult: -----------------");
        ret.append("\n DOs : \n");
        if (DOs != null) {
            for (int i = 0; i < DOs.size(); i++) {
                if (onlyID) {
                    if ((DO = (GenericDO) DOs.elementAt(i)).get_Data() != null) {
                        ret.append(" " + DO.get_OId());
                    }
                } else {
                    ret.append("\n" + DOs.elementAt(i));
                }
            }
        }
        ret.append("\n lazy : \n");
        if (lazy != null) {
            for (int i = 0; i < lazy.size(); i++) {
                if (onlyID) {
                    if ((DO = (GenericDO) lazy.elementAt(i)).get_Data() == null) {
                        ret.append(" " + DO.get_OId());
                    }
                } else {
                    ret.append("\n" + lazy.elementAt(i));
                }
            }
        }
        return ret.toString();
    }
}
