
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: RDBTable.java,v 1.1 2004/09/03 13:42:41 sinisa Exp $
 */
package com.lutris.dods.builder.generator.query;

/**
 * An instance of RDBTable describes a particular table in the database.
 * It is used to construct RDBColumn objects which can then be used
 * to perform database queries using the QueryBuilder class.
 * @see QueryBuilder
 * @author Jay Gunter
 */
public class RDBTable {
    protected String  name;

    /**
     * Constructor.  Application developers using QueryBuilder to perform
     * database queries will rarely need to construct RDBTable objects,
     * but instead will use the public static final RDBColumn objects 
     * inside the DO classes generated by DODS.
     * 
     * @param n the table name
     * @see QueryBuilder
     * author Jay Gunter
     */
    public RDBTable(String  n) {
        name = n;
    }
}
