
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: RDBColumn.java,v 1.1 2004/09/03 13:42:41 sinisa Exp $
 */
package com.lutris.dods.builder.generator.query;

/**
 * An instance of RDBColumn describes a particular column
 * in a particular table in the database.
 * It is used to construct database queries using the QueryBuilder class.
 * @see QueryBuilder
 * @author Jay Gunter
 */
public class RDBColumn {
    protected String  name;
    protected RDBTable table;
    protected boolean notNull;
    public RDBColumn(RDBTable _table, String  _str) {
        table = _table;
        name = _str;
        notNull = true;
    }

    public RDBColumn(RDBTable _table, String  _str, boolean _notNull) {
        table = _table;
        name = _str;
        notNull = _notNull;
    }

    public boolean equals(RDBColumn x) {
        if (null == x) {
            return false;
        }
        if (!x.table.name.equals(table.name)) {
            return false;
        }
        if (!x.name.equals(name)) {
            return false;
        }
        return true;
    }

    public boolean notNull() {
        return notNull;
    }

    public String  getTableName() {
        return table.name;
    }

    public String  getColumnName() {
        return name;
    }

    public String  getFullColumnName() {
        return table.name + "." + name;
    }
}
