
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: ObjectIdAllocator.java,v 1.1 2004/09/03 13:42:38 sinisa Exp $
 */
package com.lutris.appserver.server.sql;

/**
 * Defines the object id allocator. An object id allocator is an integral
 * part of a logical database implementation. It manages the allocation
 * of unique object ids.
 *
 * @author  Paul Morgan
 * @since   LBS1.8
 * @version $Revision: 1.1 $
 */
public interface ObjectIdAllocator {

    /**
     * Allocate a new and unique object id.
     */
    ObjectId allocate();

    /**
     * Check does oid belong to Object id's range [minOId, currentOId]
     *
     * @param oid
     *   oid which will be checked.
     * @exception ObjectIdException
     *   If a oid does't belong to range.
     */
    void checkOId(ObjectId oid)  throws ObjectIdException;
}
