
/*
 * Created on Jun 7, 2004 
 *
 */
package com.lutris.appserver.server.sql;

import java.sql.*;

/**
 *  Extensions of DBConnection interface needed to avoid explicit casting 
 *  to implementation class.
 */
public interface ExtendedDBConnection extends DBConnection{
    

    /**
     * Set new value for ConnectionEnterPoolTime.
     * 
     * @param i New value.
     */
    public void setConnectionEnterPoolTime(long i);
    
    /**
     * Return value off ConnectionEnterPoolTime.
     * 
     * @return ConnectionEnterPoolTime value.
     */
    public long getConnectionEnterPoolTime();
    

    /**
     * Set new value for connectionUsageCounter. 
     *
     * @param i New value. 
     */
    public void setConnectionUsageCounter(int i);
    
    /**
     *  Return value off connectionUsageCounter.
     *  @return ConnectionUsageCounter value. 
     */
    public int getConnectionUsageCounter();

    
    /**
     * Is connection droped.
     * 
     * @return Is connection droped.
     */
    public boolean isDroped();
    
    /**
     * Is connection closed.
     * 
     * @return Is connection closed.
     */
    public boolean isClosed();


    /**
     * Get a prepared statement given an SQL string.  If the statement is
     * cached, return that statement, otherwise prepare and save in the 
     * cache.
     *
     * @param sql The SQL statement to prepared.
     * @param iResultSetType a result set type; one of ResultSet.TYPE_FORWARD_ONLY, ResultSet.TYPE_SCROLL_INSENSITIVE, or ResultSet.TYPE_SCROLL_SENSITIVE.
     * @param iResultSetConcurrency a concurrency type; one of ResultSet.CONCUR_READ_ONLY or ResultSet.CONCUR_UPDATABLE.        
     * @return The prepared statement, which is associated only with this
     *  connection and must not be used once the connection is released.
     * @exception java.sql.SQLException If a SQL error occured compiling the
     *  statement.
     */
   public PreparedStatement prepareStatement(String  sql, int iResultSetType, int iResultSetConcurrency)
        throws SQLException;


    /**
     * @return Returns the maxPreparedStmts.
     */
    public int getMaxPreparedStmts() ;
   
}
