/*
 * Decompiled with CFR 0.152.
 */
package org.webdocwf.dods.access;

import com.lutris.appserver.server.sql.DBRowUpdateException;
import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManagerException;
import com.lutris.appserver.server.sql.ObjectId;
import com.lutris.appserver.server.sql.ObjectIdException;
import com.lutris.dods.builder.generator.dataobject.GenericDO;
import com.lutris.dods.builder.generator.query.DataObjectException;
import com.lutris.dods.builder.generator.query.QueryException;
import com.lutris.dods.builder.generator.query.RefAssertionException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.webdocwf.dods.access.AccessEvalException;
import org.webdocwf.dods.access.AccessException;
import org.webdocwf.dods.access.AccessRightException;
import org.webdocwf.dods.access.User;

public abstract class SecureDO
extends GenericDO {
    @Override
    public abstract void delete() throws SQLException, DatabaseManagerException, DataObjectException, RefAssertionException, DBRowUpdateException, QueryException;

    public abstract void delete(DBTransaction var1) throws SQLException, DatabaseManagerException, DataObjectException, RefAssertionException, DBRowUpdateException, QueryException;

    protected abstract void checkLoad() throws DataObjectException;

    @Override
    public abstract String getHandle() throws DatabaseManagerException;

    @Override
    public abstract String get_Handle() throws DatabaseManagerException;

    public abstract boolean hasMatchingHandle(String var1);

    public abstract boolean isReadOnly();

    public abstract void makeReadOnly();

    public abstract void makeReadWrite();

    public SecureDO() throws DatabaseManagerException, ObjectIdException {
    }

    public SecureDO(String dbName) throws DatabaseManagerException, ObjectIdException {
        super(dbName);
    }

    public SecureDO(boolean isView) throws ObjectIdException, DatabaseManagerException {
        super(isView);
    }

    public SecureDO(String dbName, boolean isView) throws ObjectIdException, DatabaseManagerException {
        super(dbName, isView);
    }

    public SecureDO(ObjectId id) throws ObjectIdException, DatabaseManagerException {
        super(id);
    }

    public SecureDO(String dbName, ObjectId id) throws ObjectIdException, DatabaseManagerException {
        super(dbName, id);
    }

    public SecureDO(ResultSet rs) throws SQLException, ObjectIdException, DatabaseManagerException {
        super(rs);
    }

    public SecureDO(String dbName, ResultSet rs) throws SQLException, ObjectIdException, DatabaseManagerException {
        super(dbName, rs);
    }

    public void delete(User usr) throws SQLException, DatabaseManagerException, DataObjectException, RefAssertionException, DBRowUpdateException, QueryException, AccessException {
        this.assertDODeleteAccess(usr);
        this.delete();
    }

    public void assertDODeleteAccess(User usr) throws AccessException {
        if (!this.hasDODeleteAccess(usr)) {
            throw new AccessRightException("No access !", usr, "Delete", this, null, null, null, null, null, null);
        }
    }

    public boolean hasDODeleteAccess(User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDODeleteAccess/checkLoad !", e, usr, "Delete", this, null, null, null, null, null, null);
        }
        return usr.hasDODeleteAccess(this);
    }

    public void delete(DBTransaction dbt, User usr) throws SQLException, DatabaseManagerException, DataObjectException, RefAssertionException, DBRowUpdateException, QueryException, AccessException {
        this.assertDODeleteAccess(usr);
        this.delete(dbt);
    }

    public void assertDOCopyAccess(User usr) throws AccessException {
        if (!this.hasDOCopyAccess(usr)) {
            throw new AccessRightException("No access !", usr, "Copy", this, null, null, null, null, null, null);
        }
    }

    public boolean hasDOCopyAccess(User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoCopyAccess/checkLoad !", e, usr, "Copy", this, null, null, null, null, null, null);
        }
        return usr.hasDOCopyAccess(this);
    }

    public String get_Handle(User usr) throws DatabaseManagerException, AccessException {
        this.assertDOGetAccess(usr);
        return this.getHandle();
    }

    public String getHandle(User usr) throws DatabaseManagerException, AccessException {
        return this.get_Handle();
    }

    public boolean hasMatchingHandle(String handle, User usr) throws AccessException {
        this.assertDOGetAccess(usr);
        return this.hasMatchingHandle(handle);
    }

    public boolean hasDOGetAttrAccess(String attrName, Object value, User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAttrAccess/checkLoad !", e, usr, "GetAttr", this, null, attrName, null, null, "Object", null);
        }
        return usr.hasDOGetAttrAccess((GenericDO)this, attrName, value);
    }

    public boolean hasDOGetAttrAccess(String attrName, boolean value, User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAttrAccess/checkLoad !", e, usr, "GetAttr", this, null, attrName, null, null, "boolean", null);
        }
        return usr.hasDOGetAttrAccess((GenericDO)this, attrName, value);
    }

    public boolean hasDOGetAttrAccess(String attrName, byte value, User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAttrAccess/checkLoad !", e, usr, "GetAttr", this, null, attrName, null, null, "byte", null);
        }
        return usr.hasDOGetAttrAccess((GenericDO)this, attrName, value);
    }

    public boolean hasDOGetAttrAccess(String attrName, short value, User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAttrAccess/checkLoad !", e, usr, "GetAttr", this, null, attrName, null, null, "short", null);
        }
        return usr.hasDOGetAttrAccess((GenericDO)this, attrName, value);
    }

    public boolean hasDOGetAttrAccess(String attrName, int value, User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAttrAccess/checkLoad !", e, usr, "GetAttr", this, null, attrName, null, null, "int", null);
        }
        return usr.hasDOGetAttrAccess((GenericDO)this, attrName, value);
    }

    public boolean hasDOGetAttrAccess(String attrName, long value, User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAttrAccess/checkLoad !", e, usr, "GetAttr", this, null, attrName, null, null, "long", null);
        }
        return usr.hasDOGetAttrAccess((GenericDO)this, attrName, value);
    }

    public boolean hasDOGetAttrAccess(String attrName, float value, User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAttrAccess/checkLoad !", e, usr, "GetAttr", this, null, attrName, null, null, "float", null);
        }
        return usr.hasDOGetAttrAccess((GenericDO)this, attrName, value);
    }

    public boolean hasDOGetAttrAccess(String attrName, double value, User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAttrAccess/checkLoad !", e, usr, "GetAttr", this, null, attrName, null, null, "double", null);
        }
        return usr.hasDOGetAttrAccess((GenericDO)this, attrName, value);
    }

    public boolean hasDOGetAttrAccess(String attrName, byte[] value, User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAttrAccess/checkLoad !", e, usr, "GetAttr", this, null, attrName, null, null, "byte[]", null);
        }
        return usr.hasDOGetAttrAccess((GenericDO)this, attrName, value);
    }

    protected boolean hasDOSetAttrAccess(String attrName, Object oldValue, Object newValue, User usr) throws AccessEvalException {
        return usr.hasDOSetAttrAccess((GenericDO)this, attrName, oldValue, newValue);
    }

    protected boolean hasDOSetAttrAccess(String attrName, boolean oldValue, boolean newValue, User usr) throws AccessEvalException {
        return usr.hasDOSetAttrAccess((GenericDO)this, attrName, oldValue, newValue);
    }

    protected boolean hasDOSetAttrAccess(String attrName, byte oldValue, byte newValue, User usr) throws AccessEvalException {
        return usr.hasDOSetAttrAccess((GenericDO)this, attrName, oldValue, newValue);
    }

    protected boolean hasDOSetAttrAccess(String attrName, short oldValue, short newValue, User usr) throws AccessEvalException {
        return usr.hasDOSetAttrAccess((GenericDO)this, attrName, oldValue, newValue);
    }

    protected boolean hasDOSetAttrAccess(String attrName, int oldValue, int newValue, User usr) throws AccessEvalException {
        return usr.hasDOSetAttrAccess((GenericDO)this, attrName, oldValue, newValue);
    }

    protected boolean hasDOSetAttrAccess(String attrName, long oldValue, long newValue, User usr) throws AccessEvalException {
        return usr.hasDOSetAttrAccess((GenericDO)this, attrName, oldValue, newValue);
    }

    protected boolean hasDOSetAttrAccess(String attrName, float oldValue, float newValue, User usr) throws AccessEvalException {
        return usr.hasDOSetAttrAccess((GenericDO)this, attrName, oldValue, newValue);
    }

    protected boolean hasDOSetAttrAccess(String attrName, double oldValue, double newValue, User usr) throws AccessEvalException {
        return usr.hasDOSetAttrAccess((GenericDO)this, attrName, oldValue, newValue);
    }

    protected boolean hasDOSetAttrAccess(String attrName, byte[] oldValue, byte[] newValue, User usr) throws AccessEvalException {
        return usr.hasDOSetAttrAccess((GenericDO)this, attrName, oldValue, newValue);
    }

    public void assertDOGetDOValueAccess(String attrName, SecureDO value, User usr) throws AccessException {
        if (value != null && !value.hasDOGetAccess(usr)) {
            throw new AccessRightException("No access !", usr, "GETDOValue", this, null, attrName, null, null, null, null);
        }
    }

    protected boolean hasDOGetDOValueAccess(SecureDO value, User usr) throws AccessEvalException {
        return value.hasDOGetAccess(usr);
    }

    protected boolean hasDOGetDOValueAccess(Object value, User usr) throws AccessEvalException {
        return true;
    }

    protected boolean hasDOGetDOValueAccess(boolean value, User usr) throws AccessEvalException {
        return true;
    }

    protected boolean hasDOGetDOValueAccess(byte value, User usr) throws AccessEvalException {
        return true;
    }

    protected boolean hasDOGetDOValueAccess(short value, User usr) throws AccessEvalException {
        return true;
    }

    protected boolean hasDOGetDOValueAccess(int value, User usr) throws AccessEvalException {
        return true;
    }

    protected boolean hasDOGetDOValueAccess(long value, User usr) throws AccessEvalException {
        return true;
    }

    protected boolean hasDOGetDOValueAccess(float value, User usr) throws AccessEvalException {
        return true;
    }

    protected boolean hasDOGetDOValueAccess(double value, User usr) throws AccessEvalException {
        return true;
    }

    protected boolean hasDOGetDOValueAccess(byte[] value, User usr) throws AccessEvalException {
        return true;
    }

    protected void assertDOGetDOValueAccess(String attrName, Object value, User usr) throws AccessException {
    }

    protected void assertDOGetDOValueAccess(String attrName, boolean value, User usr) throws AccessException {
    }

    protected void assertDOGetDOValueAccess(String attrName, byte value, User usr) throws AccessException {
    }

    protected void assertDOGetDOValueAccess(String attrName, short value, User usr) throws AccessException {
    }

    protected void assertDOGetDOValueAccess(String attrName, int value, User usr) throws AccessException {
    }

    protected void assertDOGetDOValueAccess(String attrName, long value, User usr) throws AccessException {
    }

    protected void assertDOGetDOValueAccess(String attrName, float value, User usr) throws AccessException {
    }

    protected void assertDOGetDOValueAccess(String attrName, double value, User usr) throws AccessException {
    }

    protected void assertDOGetDOValueAccess(String attrName, byte[] value, User usr) throws AccessException {
    }

    public boolean hasQueryFindAccess(User usr) throws AccessEvalException {
        if (usr == null) {
            return false;
        }
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasQueryFindAccess/checkLoad !", e, usr, "Query", this, null, null, null, null, null, null);
        }
        return usr.hasQueryFindAccess(this);
    }

    @Override
    public int getVersion() {
        return this.get_Version();
    }

    @Override
    public int get_Version() {
        return super.get_Version();
    }

    public int get_Version(User usr) throws AccessException {
        this.assertDOGetVersionAccess(usr);
        return this.get_Version();
    }

    public void assertDOGetVersionAccess(User usr) throws AccessException {
        if (!this.hasDOGetVersionAccess(usr)) {
            throw new AccessRightException("No access !", usr, "GetVersion", this, null, null, null, null, null, null);
        }
    }

    public boolean hasDOGetVersionAccess(User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDOGetVersionAccess/checkLoad !", e, usr, "GetVersion", this, null, null, null, null, null, null);
        }
        return usr.hasDOGetVersionAccess(this);
    }

    public boolean isReadOnly(User usr) throws AccessException {
        this.assertDOIsReadOnlyAccess(usr);
        return this.isReadOnly();
    }

    public void assertDOIsReadOnlyAccess(User usr) throws AccessException {
        if (!this.hasDOIsReadOnlyAccess(usr)) {
            throw new AccessRightException("No access !", usr, "IsReadOnly", this, null, null, null, null, null, null);
        }
    }

    public boolean hasDOIsReadOnlyAccess(User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDOIsReadOnlyAccess/checkLoad !", e, usr, "IsReadOnly", this, null, null, null, null, null, null);
        }
        return usr.hasDOIsReadOnlyAccess(this);
    }

    public void assertDOGetAccess(User usr) throws AccessException {
        if (!this.hasDOGetAccess(usr)) {
            throw new AccessRightException("No access", usr, "Get", this, null, null, null, null, null, null);
        }
    }

    public boolean hasDOGetAccess(User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDoGetAccess/checkLoad !", e, usr, "Get", this, null, null, null, null, null, null);
        }
        return usr.hasDOGetAccess(this);
    }

    public void makeReadOnly(User usr) throws AccessException {
        this.assertDOMakeReadOnlyAccess(usr);
        this.makeReadOnly();
    }

    public void assertDOMakeReadOnlyAccess(User usr) throws AccessException {
        if (!this.hasDOMakeReadOnlyAccess(usr)) {
            throw new AccessRightException("No access", usr, "MakeReadOnly", this, null, null, null, null, null, null);
        }
    }

    public boolean hasDOMakeReadOnlyAccess(User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDOMakeReadOnlyAccess/checkLoad !", e, usr, "MakeReadOnly", this, null, null, null, null, null, null);
        }
        return usr.hasDOMakeReadOnlyAccess(this);
    }

    public void makeReadWrite(User usr) throws AccessException {
        this.assertDOMakeReadWriteAccess(usr);
        this.makeReadWrite();
    }

    public void assertDOMakeReadWriteAccess(User usr) throws AccessException {
        if (!this.hasDOMakeReadWriteAccess(usr)) {
            throw new AccessRightException("No access", usr, "MakeReadWrite", this, null, null, null, null, null, null);
        }
    }

    public boolean hasDOMakeReadWriteAccess(User usr) throws AccessEvalException {
        try {
            this.checkLoad();
        }
        catch (Exception e) {
            throw new AccessEvalException("Error in hasDOMakeReadWriteAccess/checkLoad !", e, usr, "MakeReadWrite", this, null, null, null, null, null, null);
        }
        return usr.hasDOMakeReadWriteAccess(this);
    }
}

