/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql;

import com.lutris.appserver.server.sql.AbstractDBTransactionFactory;
import com.lutris.appserver.server.sql.LogicalDatabase;
import org.enhydra.dods.DODS;

public class DBTransactionFactoryCreator {
    public static AbstractDBTransactionFactory getDBTransactionFactory(String dbTransFactoryClassName, LogicalDatabase ldb) {
        Class<?> transFactoryClass = null;
        AbstractDBTransactionFactory transFactory = null;
        if (dbTransFactoryClassName != null) {
            try {
                transFactoryClass = Class.forName(dbTransFactoryClassName);
                transFactory = (AbstractDBTransactionFactory)transFactoryClass.newInstance();
            }
            catch (Exception e) {
                DODS.getLogChannel().write(3, "Failed to make DBTransactionFactory  :" + dbTransFactoryClassName + " creating StandardDBTransactionFactory instead");
                transFactory = null;
            }
        }
        if (dbTransFactoryClassName == null || transFactory == null) {
            try {
                transFactoryClass = Class.forName("com.lutris.appserver.server.sql.standard.StandardDBTransactionFactory");
                transFactory = (AbstractDBTransactionFactory)transFactoryClass.newInstance();
            }
            catch (Exception e) {
                String str = "Failed to make StandardTransactionFactory  : com.lutris.appserver.server.sql.standard.StandardDBTransactionFactory";
                DODS.getLogChannel().write(2, str);
                throw new Error(str);
            }
        }
        transFactory.setLogicalDb(ldb);
        return transFactory;
    }
}

