
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 */
package org.enhydra.dods.wizard;

import java.io.File ;
import java.io.FilenameFilter ;

/**
 * DirectoryNameFilter restricts file sets to only those files that are
 * directories. Use this with JFileChooser to create a directory
 * chooser.
 *
 * @author Nenad Vico
 * @version 1.0
 */
public class DirectoryNameFilter implements FilenameFilter  {

    /**
     * Create a DirectoryNameFilter for use with the FileChooser dialog.
     */
    public DirectoryNameFilter() {}

    /**
     * Check to see if the passed file is a directory.
     *
     * @param dir Parent folder.
     * @param name File to check.
     *
     * @return True if the file is a directory.
     *
     */
    public boolean accept(File  dir, String  name) {
        File  file = new File ("" + dir + File.separator + name);

        return file.isDirectory();
    }
}
