
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 */
package org.enhydra.dods.cache;

import java.lang.reflect.Method ;
import java.util.Enumeration ;
import java.util.Vector ;
import java.util.HashMap ;
import org.enhydra.dods.DODS;
import com.lutris.logging.Logger;


/**
 *
 *
 * @author    Tanja Jovanovic
 * @author    Sinisa Milosevic
 * @author    Vladimir Puskas
 * @version   $Revision: 1.3 $
 */
public final class Wrapper {

    /**
     *
     */
    private static Wrapper instance = null;
    private long locked;
    private long timeout;

    /**
     *
     */
    public static Wrapper getInstance() {
        if (null == instance) {
            instance = new Wrapper();
        }
        return instance;
    }

    /**
     *
     */
    protected Vector  vec;
    protected HashMap  nonVisibleSimpleComplexQCList;
    protected HashMap  nonVisibleMultiJoinQCList;

    /**
     * Constructor is private to ensure nobody instantiate this one.
     */
    private Wrapper() {
        vec = new Vector ();
        nonVisibleSimpleComplexQCList = new HashMap ();
        nonVisibleMultiJoinQCList = new HashMap ();
        locked = 0;
    }

    /**
     *
     */
    public void registerCache(DataStructCache dc) {
        if (dc instanceof QueryCache) {
            vec.add(dc);
        }
    }

    /**
     *
     */
    public void setTimeout(long to) {
        timeout = to;
    }

    /**
     *
     */
    public synchronized long lock() {
        if (locked > 0 && locked < System.currentTimeMillis()) {
            return 0;
        }
        for (Enumeration  e = vec.elements(); e.hasMoreElements();) {
            ((DataStructCache) e.nextElement()).lock();
        }
        locked = System.currentTimeMillis() + timeout;
        return locked;
    }

    /**
     *
     */
    public synchronized void unlock(long handle) {
        if (handle != locked) {
            DODS.getLogChannel().write(Logger.DEBUG,
                    "Wrapper: wrong handle to unlock " + handle);
            return;
        }
        for (Enumeration  e = vec.elements(); e.hasMoreElements();) {
            ((DataStructCache) e.nextElement()).unlock();
        }
        locked = 0;
    }

    /**
     *
     */
    public void removeAllComplexQueries() {
        for (Enumeration  e = vec.elements(); e.hasMoreElements();) {
            Object  obj = e.nextElement();

            if (obj instanceof QueryCache) {
                ((QueryCache) obj).getCacheAdministration(CacheConstants.COMPLEX_QUERY_CACHE).refresh();
            }
        }
    }

    /**
     *
     */
    public void removeAllMultiJoinQueries() {
        for (Enumeration  e = vec.elements(); e.hasMoreElements();) {
            Object  obj = e.nextElement();

            if (obj instanceof QueryCache) {
                ((QueryCache) obj).getCacheAdministration(CacheConstants.MULTI_JOIN_QUERY_CACHE).refresh();
            }
        }
    }

    /**
     *
     */
    public void makeSimpleComplexQCachesInvisible(Vector  vecQC) {
        for (Enumeration  e = vecQC.elements(); e.hasMoreElements();) {
            Class  doClass = (Class ) e.nextElement();
            Method  mtd = null;
            QueryCache qc = null;

            try {
                mtd = doClass.getMethod("getConfigurationAdministration",
                        new Class [] {});
                qc = (QueryCache) mtd.invoke(null, new Object [] {});
            } catch (Throwable  t) {
                DODS.getLogChannel().write(Logger.DEBUG,
                        "Wrapper: couldn't get QueryCache for " + doClass);
                continue;
            }
            Integer  intObj = (Integer ) nonVisibleSimpleComplexQCList.get(qc);
            int num;

            if (intObj != null) {
                num = intObj.intValue();
                num++;
                nonVisibleSimpleComplexQCList.put(qc, new Integer (num));
            } else {
                nonVisibleSimpleComplexQCList.put(qc, new Integer (1));
                qc.lockSimpleComplexQCache();
            }
        }
    }

    /**
     *
     */
    public void makeSimpleComplexQCachesVisible(Vector  vecQC) {
        for (Enumeration  e = vecQC.elements(); e.hasMoreElements();) {
            Class  doClass = (Class ) e.nextElement();
            Method  mtd = null;
            QueryCache qc = null;

            try {
                mtd = doClass.getMethod("getConfigurationAdministration",
                        new Class [] {});
                qc = (QueryCache) mtd.invoke(null, new Object [] {});
            } catch (Throwable  t) {
                DODS.getLogChannel().write(Logger.DEBUG,
                        "Wrapper: couldn't get QueryCache for " + doClass);
                continue;
            }
            Integer  intObj = (Integer ) nonVisibleSimpleComplexQCList.get(qc);
            int num;

            if (intObj != null) {
                num = intObj.intValue();
                num--;
                if (num == 0) {
                    nonVisibleSimpleComplexQCList.remove(qc);
                    qc.unlockSimpleComplexQCache();
                } else {
                    nonVisibleSimpleComplexQCList.put(qc, new Integer (num));
                }
            }
        }
    }
    public void makeMultiJoinQCachesInvisible() {
        for (Enumeration  e = vec.elements(); e.hasMoreElements();) {
            Object  obj = e.nextElement();

            if (obj instanceof QueryCache) {
               QueryCache qc = (QueryCache)obj;
               Integer  intObj = (Integer ) nonVisibleMultiJoinQCList.get(qc);
               int num;

                   if (intObj != null) {
                       num = intObj.intValue();
                       num++;
                       nonVisibleMultiJoinQCList.put(qc, new Integer (num));
                   } else {
                       nonVisibleMultiJoinQCList.put(qc, new Integer (1));
                       qc.lockMultiJoinQCache();
                   }
                }   
        }
    }
    public void makeMultiJoinQCachesVisible() {
        for (Enumeration  e = vec.elements(); e.hasMoreElements();) {
            Object  obj = e.nextElement();
            
            if (obj instanceof QueryCache) {
               QueryCache qc = (QueryCache)obj;
   
               Integer  intObj = (Integer ) nonVisibleSimpleComplexQCList.get(qc);
               int num;

               if (intObj != null) {
                  num = intObj.intValue();
                  num--;
                  if (num == 0) {
                     nonVisibleMultiJoinQCList.remove(qc);
                     qc.unlockMultiJoinQCache();
                  } 
                  else {
                     nonVisibleMultiJoinQCList.put(qc, new Integer (num));
                  }
               }   
            }
        }
    }
}
