
/*
 * Created on May 24, 2004
 *
 */
package com.lutris.appserver.server.sql;

import org.enhydra.dods.DODS;

import com.lutris.logging.Logger;

/**
 * @version 0.2
 */
public class DBTransactionFactoryCreator {

    public static AbstractDBTransactionFactory getDBTransactionFactory(String  dbTransFactoryClassName, LogicalDatabase ldb){
        Class  transFactoryClass = null;
        AbstractDBTransactionFactory transFactory = null;
        if (dbTransFactoryClassName != null) {
            try {
                transFactoryClass = Class.forName(dbTransFactoryClassName);
                transFactory = (AbstractDBTransactionFactory) transFactoryClass.newInstance();
            } catch (Exception  e) {
                DODS.getLogChannel()
                    .write(Logger.ERROR,
                    "Failed to make DBTransactionFactory  :"
                    + dbTransFactoryClassName
                    + " creating StandardDBTransactionFactory instead");
                transFactory = null;
            }
        }
        if (dbTransFactoryClassName == null || transFactory == null) {
            try {
                transFactoryClass = Class.forName("com.lutris.appserver.server.sql.standard.StandardDBTransactionFactory");
                transFactory = (AbstractDBTransactionFactory) transFactoryClass.newInstance();
            } catch (Exception  e) {
                String  str = "Failed to make StandardTransactionFactory  : com.lutris.appserver.server.sql.standard.StandardDBTransactionFactory";
                DODS.getLogChannel().write(Logger.CRITICAL, str);
                throw new Error (str);
            }
        }
        transFactory.setLogicalDb(ldb);     
        return transFactory;
    }
}