
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: OracleDBConnection.java,v 1.1 2004/09/03 13:42:52 sinisa Exp $
 */
package com.lutris.appserver.server.sql.oracle;

import java.sql.SQLException ;

import com.lutris.appserver.server.sql.ConnectionAllocator;
import com.lutris.appserver.server.sql.standard.StandardDBConnection;

/**
 * An Oracle database connection object used by the Oracle logical database.
 *
 * @see     StandardDBConnection
 * @author  Paul Morgan
 * @since   LBS1.8
 * @version $Revision: 1.1 $
 */
public class OracleDBConnection extends StandardDBConnection {

    /**
     * Create a connection to a JDBC database with oracle specific symantics.
     *
     * @see StandardDBConnection#StandardDBConnection
     * @param url
     *   JDBC URL of database.
     * @param user
     *   SQL user name.
     * @param password
     *   SQL password.
     * @param maxPreparedStatements 
     *   maximum number of preparse statements. a value of less than zero
     *   queries JDBC for the value.
     * @param connectionAllocator
     *   the connection allocator that this connection belongs to.
     * @param logging
     *   specifying <CODE>true</CODE> enables SQL logging.
     * @param generation
     *   a generation number used to drop old connection when they
     *   are released.
     * @exception SQLException
     *   If a connection can't be established.
     */
    protected OracleDBConnection(OracleConnectionAllocator connectionAllocator,
            String  url, String  user, String  password,
            int maxPreparedStatements,
            boolean logging, int generation)
        throws SQLException  {
        super((ConnectionAllocator)connectionAllocator, url, user, password, maxPreparedStatements,
                logging, generation);
    }
}
