/*
 * Decompiled with CFR 0.152.
 */
package com.lutris.appserver.server.sql.oracle;

import com.lutris.appserver.server.sql.ConnectionAllocator;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.DBQuery;
import com.lutris.appserver.server.sql.DBTransaction;
import com.lutris.appserver.server.sql.DatabaseManagerConfiguration;
import com.lutris.appserver.server.sql.LogicalDatabase;
import com.lutris.appserver.server.sql.ObjectIdAllocator;
import com.lutris.appserver.server.sql.oracle.OracleConnectionAllocator;
import com.lutris.appserver.server.sql.oracle.OracleDBConnection;
import com.lutris.appserver.server.sql.oracle.OracleDBQuery;
import com.lutris.appserver.server.sql.oracle.OracleDBTransaction;
import com.lutris.appserver.server.sql.oracle.OracleObjectIdAllocator;
import com.lutris.appserver.server.sql.standard.StandardLogicalDatabase;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;
import java.sql.SQLException;

public class OracleLogicalDatabase
extends StandardLogicalDatabase {
    public OracleLogicalDatabase(String dbName, Config dbConfig) throws ConfigException, SQLException {
        super.init(dbName, dbConfig);
    }

    public OracleLogicalDatabase(String dbName, Config dbConfig, DatabaseManagerConfiguration dbManagerConf) throws ConfigException, SQLException {
        super.init(dbName, dbConfig, dbManagerConf);
    }

    public OracleLogicalDatabase() {
    }

    public ConnectionAllocator loadConnectionAllocator(Config connectionConfig) throws ConfigException {
        return new OracleConnectionAllocator(this, connectionConfig);
    }

    public ObjectIdAllocator loadObjectIdAllocator(Config objIdConfig) throws ConfigException {
        return new OracleObjectIdAllocator((LogicalDatabase)this, objIdConfig);
    }

    public DBTransaction createTransaction() throws SQLException {
        return new OracleDBTransaction((DBConnection)((OracleDBConnection)this.connectionAllocator.allocate()));
    }

    public DBQuery createQuery() throws SQLException {
        return new OracleDBQuery(this.connectionAllocator.allocate());
    }

    public String getType() {
        return "Oracle";
    }
}

