
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 * Contributor(s):
 *
 * $Id: OracleObjectIdAllocator.java,v 1.1 2004/09/03 13:42:52 sinisa Exp $
 */
package com.lutris.appserver.server.sql.oracle;

import com.lutris.appserver.server.sql.LogicalDatabase;
import com.lutris.appserver.server.sql.standard.StandardObjectIdAllocator;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;

/**
 * An Oracle database object id allocator used by the Oracle logical
 * database.
 *
 * @see     StandardObjectIdAllocator
 * @author  Paul Morgan
 * @since   LBS1.8
 * @version $Revision: 1.1 $
 */
public class OracleObjectIdAllocator extends StandardObjectIdAllocator {

    /**
     * Initialize the object id manager.
     *
     * @see StandardObjectIdAllocator#StandardObjectIdAllocator
     * @param logicalDatabase
     *   The logical database that this object id allocator is associated
     *   with.
     * @param objIdConfig
     *   The configuration object.
     * @exception ConfigException
     *   if bad configuration information is given in the config file.
     */
    protected OracleObjectIdAllocator(LogicalDatabase logicalDatabase,
            Config objIdConfig)
        throws ConfigException {
        super(logicalDatabase, objIdConfig);
    }
}
