
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: OracleConnectionAllocator.java,v 1.1 2004/09/03 13:42:52 sinisa Exp $
 */
package com.lutris.appserver.server.sql.oracle;

import java.sql.SQLException ;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.standard.StandardConnectionAllocator;
import com.lutris.util.Config;
import com.lutris.util.ConfigException;

/**
 * An Oracle database connection allocator used by the Oracle logical
 * database.
 *
 * @see     StandardConnectionAllocator
 * @author  Paul Morgan
 * @since   LBS1.8
 * @version $Revision: 1.1 $
 */
public class OracleConnectionAllocator extends StandardConnectionAllocator {

    /**
     * Creates an Oracle database connection allocator.
     *
     * @see StandardConnectionAllocator#StandardConnectionAllocator
     * @param logicalDatabase
     *   the logical Oracle database for which connections are pooled.
     * @param connectionConfig
     *   configuration parameters for the database connections.  There
     *   are no Informix specific configuration data.
     * @exception ConfigException
     *   If bad configuration information is given in the config file.
     */
    protected OracleConnectionAllocator(OracleLogicalDatabase logicalDatabase,
            Config connectionConfig)
        throws ConfigException {
        super(logicalDatabase, connectionConfig);
    }

    /**
     * Creates a new Oracle connection to be added to the connection pool.
     * 
     * @exception SQLException If a SQL error occures.
     */
    protected DBConnection createConnection()
        throws SQLException  {
        return new OracleDBConnection(this, url, user, password,
                maxPreparedStatements, sqlLogging, generation);
    }
}
