
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: OracleDBQuery.java,v 1.1 2004/09/03 13:42:52 sinisa Exp $
 */
package com.lutris.appserver.server.sql.oracle;

import java.sql.SQLException ;
import com.lutris.appserver.server.sql.DBConnection;
import com.lutris.appserver.server.sql.standard.StandardDBQuery;

/**
 * An Oracle database query object used by the Oracle logical database.
 *
 * @see     StandardDBQuery
 * @author  Paul Morgan
 * @since   LBS1.8
 * @version $Revision: 1.1 $
 */
public class OracleDBQuery extends StandardDBQuery {

    /**
     * Private constructor. Used by the logical database object.
     *
     * @see StandardDBQuery#StandardDBQuery
     * @param dbConnection
     *   The database connection to use.
     * @exception SQLException
     *   If a database access error occurs. 
     */
    protected OracleDBQuery(DBConnection dbConnection)
        throws SQLException  {
        super(dbConnection);
    }
}
