
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 */
 
package org.enhydra.dods.exceptions;

import com.lutris.dods.builder.generator.query.DataObjectException;

/**
 * CacheObjectException handles exceptions occured in the work with cache.
 *
 * @author    Tanja Jovanovic
 * @version   1.0  15.06.2003.
 */
public class CacheObjectException extends DataObjectException {

    /**
     * Constructs an exception without a specified cause.
     *
     * @param msg The message associated with the exception.
     */
    public CacheObjectException(String  msg) {
        super(msg);
    }

    /**
     * Constructs an exception with an associated causing exception.
     *
     * @param msg The message associated with the exception.
     * @param cause The error or exception that cause this
     *  exception.
     */
    public CacheObjectException(String  msg,
            Throwable  cause) {
        super(msg, cause);
    }
}
