
/*
 * Enhydra Java Application Server Project
 *
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific terms governing rights and limitations
 * under the License.
 *
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 *
 */
package org.enhydra.dods.cache;

import org.enhydra.dods.exceptions.CacheObjectException;

/**
 * CacheAdministration handles configuration settings about cache
 * (data object (or DataStruct object), simple query or complex query cache).
 *
 * @author    Tanja Jovanovic
 * @author    Nenad Vico
 * @author    Zorica Suvajdzin
 * @version   2.0  15.06.2003.
 */
public abstract class CacheAdministration {

    /**
     * Returns maximum cache size.
     *
     * @return Maximum cache size.
     */
    public abstract int getMaxCacheSize();

    /**
     * Returns maximum cache size. If the cache is unbounded (the maximum size
     * is negative), the current cache size is returned.
     *
     * @param real If this parameter is true, this method returns real maximum
     * cache size, otherwise returns appropriate value for statistics.
     *
     * @return Maximum cache size.
     */
    public abstract int getMaxCacheSize(boolean real);

    /**
     * Returns current size of the cache (number of elements in the cache).
     *
     * @return Size of currently used data object cache.
     */
    public abstract int getCacheSize();

    /**
     * Sets maximum cache size.
     *
     * @param maxSize Maximum cache size.
     */
    protected abstract void setMaxCacheSize(int maxSize) throws CacheObjectException;

    /**
     * Refreshes cache.
     */
    public abstract void refresh();

    /**
     * Disables cache.
     */
    public abstract void disable();

    /**
     * Enables cache.
     */
    public abstract void enable();
}
