
/*
 * Enhydra Java Application Server Project
 * 
 * The contents of this file are subject to the Enhydra Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License on
 * the Enhydra web site ( http://www.enhydra.org/ ).
 * 
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See 
 * the License for the specific terms governing rights and limitations
 * under the License.
 * 
 * The Initial Developer of the Enhydra Application Server is Lutris
 * Technologies, Inc. The Enhydra Application Server and portions created
 * by Lutris Technologies, Inc. are Copyright Lutris Technologies, Inc.
 * All Rights Reserved.
 * 
 * Contributor(s):
 * 
 * $Id: DatabaseManagerException.java,v 1.1 2004/09/03 13:42:37 sinisa Exp $
 */
package com.lutris.appserver.server.sql;

import org.enhydra.dods.exceptions.DodsBaseException;;
/**
 * Exception for database manager failures.  These are errors detected
 * directly by the database manager rather than by JDBC.
 *
 * @since   LBS1.8
 * @author  Paul Morgan
 * @version $Revision: 1.1 $
 */
public class DatabaseManagerException extends DodsBaseException {

    /**
     * Construct with required messsage.
     *
     * @param msg
     *   Detailed message describing the exception.
     */
    public DatabaseManagerException(String  msg) {
        super(msg);
    }

    /**
     * Construct with a message and associated causing exception.
     *
     * @param msg The message associated with the exception.
     * @param cause The error or exception that cause this
     *  exception.
     */
    public DatabaseManagerException(String  msg,
            Throwable  cause) {
        super(msg, cause);
    }

    /**
     * Construct from a causing exception.
     *
     * @param cause The error or exception that cause this
     *  exception. The message will be this object's messasge.
     */
    public DatabaseManagerException(Throwable  cause) {
        super(cause);
    }
}
